/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import java.util.List;
import org.vikamine.kernel.subgroup.quality.AbstractRankedBasedQF;

public class MannWhitneyQF
extends AbstractRankedBasedQF {
    private static final String ID = "Mann-Whitney QF";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return ID;
    }

    @Override
    public double evaluateRanks(int dataViewSize, List<Double> ranksSG) {
        int sgSize = ranksSG.size();
        double rankSum = 0.0;
        for (Double i : ranksSG) {
            rankSum += i.doubleValue();
        }
        return this.evaluateRanks(dataViewSize, sgSize, rankSum);
    }

    public double evaluateRanks(int dataViewSize, int sgSize, double rankSum) {
        int complementSize = dataViewSize - sgSize;
        return Math.sqrt((double)sgSize / (double)complementSize) * (rankSum / (double)sgSize - (double)(dataViewSize + 1) / 2.0);
    }

    @Override
    public MannWhitneyQF clone() {
        return new MannWhitneyQF();
    }
}

