/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGFilters;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.search.MiningTaskFamily;
import org.vikamine.kernel.util.SGImprovementCalculator;
import org.vikamine.kernel.xpdl.DatasetProvider;
import org.vikamine.kernel.xpdl.DirectoryDatasetProvider;
import org.vikamine.kernel.xpdl.MiningTaskFamilyInterpreter;

public class TaskRunner {
    private static final boolean VERBOSE = true;

    public static void main(String[] args) throws IOException {
        File taskfile = new File("../VKM-UCI-Test/resources/tasks/credit-g_complete_nominal.xml");
        DirectoryDatasetProvider provider = new DirectoryDatasetProvider("../VKM-UCI-Test/resources/datasets/");
        TaskRunner.runTask(taskfile, provider);
    }

    public static void runTask(File taskfile, DatasetProvider datasetProvider) throws IOException {
        MiningTaskFamily min = new MiningTaskFamilyInterpreter(taskfile, datasetProvider).getTask();
        List<MiningTask> tasksList = min.getTasks();
        for (MiningTask task : tasksList) {
            System.out.println("********************");
            System.out.println(taskfile.getName());
            System.out.println("********************");
            SGSet result = task.performSubgroupDiscovery();
            result = new SGFilters.SignificantImprovementFilterGlobal(0.05).filterSGs(result);
            System.out.println(result.size());
            for (SG sg : result.toSortedList(false)) {
                SGStatisticsBinary statistics = (SGStatisticsBinary)sg.getStatistics();
                SGImprovementCalculator calc = new SGImprovementCalculator();
                System.out.println(sg.getSGDescription() + " -> " + statistics.getP() + "(" + "TP: " + statistics.getTp() + "; FP: " + statistics.getFp() + "/" + statistics.getDeviation() + ")[" + calc.calculateMaxPValueToSubsets(sg) + "]");
            }
        }
    }
}

