/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.driftdetection;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import moa.classifiers.core.driftdetection.AbstractChangeDetector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class DDM
extends AbstractChangeDetector {
    private static final long serialVersionUID = -3518369648142099719L;
    public IntOption minNumInstancesOption = new IntOption("minNumInstances", 'n', "The minimum number of instances before permitting detecting change.", 30, 0, Integer.MAX_VALUE);
    public FloatOption warningLevelOption = new FloatOption("warningLevel", 'w', "Warning Level.", 2.0, 1.0, 4.0);
    public FloatOption outcontrolLevelOption = new FloatOption("outcontrolLevel", 'o', "Outcontrol Level.", 3.0, 1.0, 5.0);
    private int m_n;
    private int minNumInstances;
    private double m_p;
    private double m_s;
    private double m_psmin;
    private double m_pmin;
    private double m_smin;
    private double warningLevel;
    private double outcontrolLevel;

    public DDM() {
        this.resetLearning();
    }

    @Override
    public void resetLearning() {
        this.m_n = 1;
        this.m_p = 1.0;
        this.m_s = 0.0;
        this.m_psmin = Double.MAX_VALUE;
        this.m_pmin = Double.MAX_VALUE;
        this.m_smin = Double.MAX_VALUE;
        this.minNumInstances = this.minNumInstancesOption.getValue();
        this.warningLevel = this.warningLevelOption.getValue();
        this.outcontrolLevel = this.outcontrolLevelOption.getValue();
    }

    @Override
    public void input(double prediction) {
        if (this.isChangeDetected || !this.isInitialized) {
            this.resetLearning();
            this.isInitialized = true;
        }
        this.m_p += (prediction - this.m_p) / (double)this.m_n;
        this.m_s = Math.sqrt(this.m_p * (1.0 - this.m_p) / (double)this.m_n);
        ++this.m_n;
        this.estimation = this.m_p;
        this.isChangeDetected = false;
        this.isWarningZone = false;
        this.delay = 0.0;
        if (this.m_n < this.minNumInstances) {
            return;
        }
        if (this.m_p + this.m_s <= this.m_psmin) {
            this.m_pmin = this.m_p;
            this.m_smin = this.m_s;
            this.m_psmin = this.m_p + this.m_s;
        }
        if (this.m_n > this.minNumInstances && this.m_p + this.m_s > this.m_pmin + this.outcontrolLevel * this.m_smin) {
            this.isChangeDetected = true;
        } else {
            this.isWarningZone = this.m_p + this.m_s > this.m_pmin + this.warningLevel * this.m_smin;
        }
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

