/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.FloatOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import moa.AbstractMOAObject;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Regressor;
import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.FIMTDDNumericAttributeClassObserver;
import moa.classifiers.core.conditionaltests.InstanceConditionalTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.core.SizeOf;
import moa.core.StringUtils;
import moa.options.ClassOption;

public class ARFFIMTDD
extends AbstractClassifier
implements Regressor {
    private static final long serialVersionUID = 1L;
    protected Node treeRoot;
    protected int leafNodeCount = 0;
    protected int splitNodeCount = 0;
    protected double examplesSeen = 0.0;
    protected double sumOfValues = 0.0;
    protected double sumOfSquares = 0.0;
    protected DoubleVector sumOfAttrValues = new DoubleVector();
    protected DoubleVector sumOfAttrSquares = new DoubleVector();
    public int maxID = 0;
    public IntOption subspaceSizeOption = new IntOption("subspaceSizeSize", 'k', "Number of features per subset for each node split. Negative values = #features - k", 2, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public ClassOption splitCriterionOption = new ClassOption("splitCriterion", 's', "Split criterion to use.", SplitCriterion.class, "moa.classifiers.core.splitcriteria.VarianceReductionSplitCriterion");
    public IntOption gracePeriodOption = new IntOption("gracePeriod", 'g', "Number of instances a leaf should observe between split attempts.", 200, 0, Integer.MAX_VALUE);
    public FloatOption splitConfidenceOption = new FloatOption("splitConfidence", 'c', "Allowed error in split decision, values close to 0 will take long to decide.", 1.0E-7, 0.0, 1.0);
    public FloatOption tieThresholdOption = new FloatOption("tieThreshold", 't', "Threshold below which a split will be forced to break ties.", 0.05, 0.0, 1.0);
    public FloatOption PageHinckleyAlphaOption = new FloatOption("PageHinckleyAlpha", 'a', "Alpha value to use in the Page Hinckley change detection tests.", 0.005, 0.0, 1.0);
    public IntOption PageHinckleyThresholdOption = new IntOption("PageHinckleyThreshold", 'h', "Threshold value used in the Page Hinckley change detection tests.", 50, 0, Integer.MAX_VALUE);
    public FloatOption alternateTreeFadingFactorOption = new FloatOption("alternateTreeFadingFactor", 'f', "Fading factor used to decide if an alternate tree should replace an original.", 0.995, 0.0, 1.0);
    public IntOption alternateTreeTMinOption = new IntOption("alternateTreeTMin", 'y', "Tmin value used to decide if an alternate tree should replace an original.", 150, 0, Integer.MAX_VALUE);
    public IntOption alternateTreeTimeOption = new IntOption("alternateTreeTime", 'u', "The number of instances used to decide if an alternate tree should be discarded.", 1500, 0, Integer.MAX_VALUE);
    public FlagOption regressionTreeOption = new FlagOption("regressionTree", 'e', "Build a regression tree instead of a model tree.");
    public FloatOption learningRatioOption = new FloatOption("learningRatio", 'l', "Learning ratio to used for training the Perceptrons in the leaves.", 0.02, 0.0, 1.0);
    public FloatOption learningRateDecayFactorOption = new FloatOption("learningRatioDecayFactor", 'd', "Learning rate decay factor (not used when learning rate is constant).", 0.001, 0.0, 1.0);
    public FlagOption learningRatioConstOption = new FlagOption("learningRatioConst", 'p', "Keep learning rate constant instead of decaying.");

    @Override
    public String getPurposeString() {
        return "Implementation of the FIMT-DD tree as described by Ikonomovska et al.";
    }

    @Override
    public void resetLearningImpl() {
        this.treeRoot = null;
        this.leafNodeCount = 0;
        this.splitNodeCount = 0;
        this.maxID = 0;
        this.examplesSeen = 0.0;
        this.sumOfValues = 0.0;
        this.sumOfSquares = 0.0;
        this.sumOfAttrValues = new DoubleVector();
        this.sumOfAttrSquares = new DoubleVector();
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
        if (this.treeRoot != null) {
            this.treeRoot.describeSubtree(out, indent);
        }
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        return new Measurement[]{new Measurement("tree size (leaves)", this.leafNodeCount)};
    }

    public int calcByteSize() {
        return (int)SizeOf.fullSizeOf(this);
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        if (this.treeRoot == null) {
            return new double[]{0.0};
        }
        double prediction = this.treeRoot.getPrediction(inst);
        return new double[]{prediction};
    }

    public double normalizeTargetValue(double value) {
        if (this.examplesSeen > 1.0) {
            double sd = Math.sqrt((this.sumOfSquares - this.sumOfValues * this.sumOfValues / this.examplesSeen) / this.examplesSeen);
            double average = this.sumOfValues / this.examplesSeen;
            if (sd > 0.0 && this.examplesSeen > 1.0) {
                return (value - average) / (3.0 * sd);
            }
            return 0.0;
        }
        return 0.0;
    }

    public double getNormalizedError(Instance inst, double prediction) {
        double normalPrediction = this.normalizeTargetValue(prediction);
        double normalValue = this.normalizeTargetValue(inst.classValue());
        return Math.abs(normalValue - normalPrediction);
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        this.checkRoot();
        this.examplesSeen += inst.weight();
        this.sumOfValues += inst.weight() * inst.classValue();
        this.sumOfSquares += inst.weight() * inst.classValue() * inst.classValue();
        for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            int aIndex = ARFFIMTDD.modelAttIndexToInstanceAttIndex(i, inst);
            this.sumOfAttrValues.addToValue(i, inst.weight() * inst.value(aIndex));
            this.sumOfAttrSquares.addToValue(i, inst.weight() * inst.value(aIndex) * inst.value(aIndex));
        }
        double prediction = this.treeRoot.getPrediction(inst);
        this.processInstance(inst, this.treeRoot, prediction, this.getNormalizedError(inst, prediction), true, false);
    }

    public void processInstance(Instance inst, Node node, double prediction, double normalError, boolean growthAllowed, boolean inAlternate) {
        Node currentNode = node;
        while (true) {
            if (currentNode instanceof LeafNode) break;
            currentNode.examplesSeen += inst.weight();
            currentNode.sumOfAbsErrors += inst.weight() * normalError;
            SplitNode iNode = (SplitNode)currentNode;
            if (!inAlternate && iNode.alternateTree != null) {
                boolean altTree = true;
                double lossO = Math.pow(inst.classValue() - prediction, 2.0);
                double lossA = Math.pow(inst.classValue() - iNode.alternateTree.getPrediction(inst), 2.0);
                int i = 0;
                while ((double)i < inst.weight()) {
                    iNode.lossFadedSumOriginal = lossO + this.alternateTreeFadingFactorOption.getValue() * iNode.lossFadedSumOriginal;
                    iNode.lossFadedSumAlternate = lossA + this.alternateTreeFadingFactorOption.getValue() * iNode.lossFadedSumAlternate;
                    iNode.lossExamplesSeen += 1.0;
                    double Qi = Math.log(iNode.lossFadedSumOriginal / iNode.lossFadedSumAlternate);
                    iNode.lossSumQi += Qi;
                    iNode.lossNumQiTests += 1.0;
                    ++i;
                }
                double Qi = Math.log(iNode.lossFadedSumOriginal / iNode.lossFadedSumAlternate);
                double previousQiAverage = iNode.lossSumQi / iNode.lossNumQiTests;
                double QiAverage = iNode.lossSumQi / iNode.lossNumQiTests;
                if (iNode.lossExamplesSeen - iNode.previousWeight >= (double)this.alternateTreeTMinOption.getValue()) {
                    iNode.previousWeight = iNode.lossExamplesSeen;
                    if (Qi > 0.0) {
                        Node parent = currentNode.getParent();
                        if (parent != null) {
                            Node replacementTree = iNode.alternateTree;
                            parent.setChild(parent.getChildIndex(currentNode), replacementTree);
                            if (growthAllowed) {
                                replacementTree.restartChangeDetection();
                            }
                        } else {
                            this.treeRoot = iNode.alternateTree;
                            this.treeRoot.restartChangeDetection();
                        }
                        currentNode = iNode.alternateTree;
                        currentNode.originalNode = null;
                        altTree = false;
                    } else if (QiAverage < previousQiAverage && iNode.lossExamplesSeen >= (double)(10 * this.gracePeriodOption.getValue()) || iNode.lossExamplesSeen >= (double)this.alternateTreeTimeOption.getValue()) {
                        iNode.alternateTree = null;
                        if (growthAllowed) {
                            iNode.restartChangeDetection();
                        }
                        altTree = false;
                    }
                }
                if (altTree) {
                    growthAllowed = false;
                    this.processInstance(inst, iNode.alternateTree, prediction, normalError, true, true);
                }
            }
            if (iNode.changeDetection && !inAlternate && iNode.PageHinckleyTest(normalError - iNode.sumOfAbsErrors / iNode.examplesSeen - this.PageHinckleyAlphaOption.getValue(), this.PageHinckleyThresholdOption.getValue())) {
                iNode.initializeAlternateTree();
            }
            if (!(currentNode instanceof SplitNode)) continue;
            currentNode = ((SplitNode)currentNode).descendOneStep(inst);
        }
        ((LeafNode)currentNode).learnFromInstance(inst, growthAllowed, this);
    }

    protected FIMTDDNumericAttributeClassObserver newNumericClassObserver() {
        return new FIMTDDNumericAttributeClassObserver();
    }

    protected SplitNode newSplitNode(InstanceConditionalTest splitTest) {
        ++this.maxID;
        return new SplitNode(splitTest, this);
    }

    protected LeafNode newLeafNode() {
        ++this.maxID;
        return new LeafNode(this, this.subspaceSizeOption.getValue());
    }

    protected FIMTDDPerceptron newLeafModel() {
        return new FIMTDDPerceptron(this);
    }

    protected void checkRoot() {
        if (this.treeRoot == null) {
            this.treeRoot = this.newLeafNode();
            this.leafNodeCount = 1;
        }
    }

    public static double computeHoeffdingBound(double range, double confidence, double n) {
        return Math.sqrt(range * range * Math.log(1.0 / confidence) / (2.0 * n));
    }

    public boolean buildingModelTree() {
        return !this.regressionTreeOption.isSet();
    }

    protected void attemptToSplit(LeafNode node, Node parent, int parentIndex) {
        SplitCriterion splitCriterion = (SplitCriterion)this.getPreparedClassOption(this.splitCriterionOption);
        Object[] bestSplitSuggestions = node.getBestSplitSuggestions(splitCriterion);
        Arrays.sort(bestSplitSuggestions);
        boolean shouldSplit = false;
        if (bestSplitSuggestions.length < 2) {
            shouldSplit = bestSplitSuggestions.length > 0;
        } else {
            double hoeffdingBound = ARFFIMTDD.computeHoeffdingBound(1.0, this.splitConfidenceOption.getValue(), node.examplesSeen);
            Object bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
            if (((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit < 1.0 - hoeffdingBound || hoeffdingBound < this.tieThresholdOption.getValue()) {
                shouldSplit = true;
            } else {
                for (int i = 0; i < node.attributeObservers.size(); ++i) {
                    FIMTDDNumericAttributeClassObserver obs = node.attributeObservers.get(i);
                    if (obs == null) continue;
                    obs.removeBadSplits(splitCriterion, ((AttributeSplitSuggestion)secondBestSuggestion).merit / ((AttributeSplitSuggestion)bestSuggestion).merit, ((AttributeSplitSuggestion)bestSuggestion).merit, hoeffdingBound);
                }
            }
        }
        if (shouldSplit) {
            Object splitDecision = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            SplitNode newSplit = this.newSplitNode(((AttributeSplitSuggestion)splitDecision).splitTest);
            newSplit.copyStatistics(node);
            newSplit.changeDetection = node.changeDetection;
            newSplit.ID = node.ID;
            --this.leafNodeCount;
            for (int i = 0; i < ((AttributeSplitSuggestion)splitDecision).numSplits(); ++i) {
                LeafNode newChild = this.newLeafNode();
                if (this.buildingModelTree()) {
                    newChild.learningModel = new FIMTDDPerceptron(node.learningModel);
                }
                newChild.changeDetection = node.changeDetection;
                newChild.setParent(newSplit);
                newSplit.setChild(i, newChild);
                ++this.leafNodeCount;
            }
            if (parent == null && node.originalNode == null) {
                this.treeRoot = newSplit;
            } else if (parent == null && node.originalNode != null) {
                node.originalNode.alternateTree = newSplit;
            } else {
                ((SplitNode)parent).setChild(parentIndex, newSplit);
                newSplit.setParent(parent);
            }
            ++this.splitNodeCount;
        }
    }

    public double computeSD(double squaredVal, double val, double size) {
        if (size > 1.0) {
            return Math.sqrt((squaredVal - val * val / size) / size);
        }
        return 0.0;
    }

    public double scalarProduct(DoubleVector u, DoubleVector v) {
        double ret = 0.0;
        for (int i = 0; i < Math.max(u.numValues(), v.numValues()); ++i) {
            ret += u.getValue(i) * v.getValue(i);
        }
        return ret;
    }

    public class FIMTDDPerceptron
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected ARFFIMTDD tree;
        protected DoubleVector weightAttribute = new DoubleVector();
        protected double sumOfValues;
        protected double sumOfSquares;
        protected double instancesSeen = 0.0;
        protected boolean reset;

        public String getPurposeString() {
            return "A perceptron regressor as specified by Ikonomovska et al. used for FIMTDD";
        }

        public FIMTDDPerceptron(FIMTDDPerceptron original) {
            this.tree = original.tree;
            this.weightAttribute = (DoubleVector)original.weightAttribute.copy();
            this.reset = false;
        }

        public FIMTDDPerceptron(ARFFIMTDD tree) {
            this.tree = tree;
            this.reset = true;
        }

        public DoubleVector getWeights() {
            return this.weightAttribute;
        }

        public void updatePerceptron(Instance inst) {
            if (this.reset) {
                this.reset = false;
                this.weightAttribute = new DoubleVector();
                this.instancesSeen = 0.0;
                for (int j = 0; j < inst.numAttributes(); ++j) {
                    this.weightAttribute.setValue(j, 2.0 * this.tree.classifierRandom.nextDouble() - 1.0);
                }
            }
            this.instancesSeen += inst.weight();
            double learningRatio = 0.0;
            learningRatio = this.tree.learningRatioConstOption.isSet() ? ARFFIMTDD.this.learningRatioOption.getValue() : ARFFIMTDD.this.learningRatioOption.getValue() / (1.0 + this.instancesSeen * this.tree.learningRateDecayFactorOption.getValue());
            this.sumOfValues += inst.weight() * inst.classValue();
            this.sumOfSquares += inst.weight() * inst.classValue() * inst.classValue();
            for (int i = 0; i < (int)inst.weight(); ++i) {
                this.updateWeights(inst, learningRatio);
            }
        }

        public void updateWeights(Instance inst, double learningRatio) {
            DoubleVector normalizedInstance = this.normalizedInstance(inst);
            double normalizedPrediction = this.prediction(normalizedInstance);
            double normalizedValue = this.tree.normalizeTargetValue(inst.classValue());
            double delta = normalizedValue - normalizedPrediction;
            normalizedInstance.scaleValues(delta * learningRatio);
            this.weightAttribute.addValues(normalizedInstance);
        }

        public DoubleVector normalizedInstance(Instance inst) {
            DoubleVector normalizedInstance = new DoubleVector();
            for (int j = 0; j < inst.numAttributes() - 1; ++j) {
                int instAttIndex = ARFFIMTDD.modelAttIndexToInstanceAttIndex(j, inst);
                double mean = this.tree.sumOfAttrValues.getValue(j) / this.tree.examplesSeen;
                double sd = ARFFIMTDD.this.computeSD(this.tree.sumOfAttrSquares.getValue(j), this.tree.sumOfAttrValues.getValue(j), this.tree.examplesSeen);
                if (inst.attribute(instAttIndex).isNumeric() && this.tree.examplesSeen > 1.0 && sd > 0.0) {
                    normalizedInstance.setValue(j, (inst.value(instAttIndex) - mean) / (3.0 * sd));
                    continue;
                }
                normalizedInstance.setValue(j, 0.0);
            }
            if (this.tree.examplesSeen > 1.0) {
                normalizedInstance.setValue(inst.numAttributes() - 1, 1.0);
            } else {
                normalizedInstance.setValue(inst.numAttributes() - 1, 0.0);
            }
            return normalizedInstance;
        }

        public double prediction(DoubleVector instanceValues) {
            return ARFFIMTDD.this.scalarProduct(this.weightAttribute, instanceValues);
        }

        protected double prediction(Instance inst) {
            DoubleVector normalizedInstance = this.normalizedInstance(inst);
            double normalizedPrediction = this.prediction(normalizedInstance);
            return this.denormalizePrediction(normalizedPrediction, this.tree);
        }

        private double denormalizePrediction(double normalizedPrediction, ARFFIMTDD tree) {
            double mean = tree.sumOfValues / tree.examplesSeen;
            double sd = ARFFIMTDD.this.computeSD(tree.sumOfSquares, tree.sumOfValues, tree.examplesSeen);
            if (ARFFIMTDD.this.examplesSeen > 1.0) {
                return normalizedPrediction * sd * 3.0 + mean;
            }
            return 0.0;
        }

        public void getModelDescription(StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, ARFFIMTDD.this.getClassNameString() + " =");
            if (ARFFIMTDD.this.getModelContext() != null) {
                for (int j = 0; j < ARFFIMTDD.this.getModelContext().numAttributes() - 1; ++j) {
                    if (!ARFFIMTDD.this.getModelContext().attribute(j).isNumeric()) continue;
                    out.append(j == 0 || this.weightAttribute.getValue(j) < 0.0 ? " " : " + ");
                    out.append(String.format("%.4f", this.weightAttribute.getValue(j)));
                    out.append(" * ");
                    out.append(ARFFIMTDD.this.getAttributeNameString(j));
                }
                out.append(" + " + this.weightAttribute.getValue(ARFFIMTDD.this.getModelContext().numAttributes() - 1));
            }
            StringUtils.appendNewline(out);
        }
    }

    public static class SplitNode
    extends InnerNode {
        private static final long serialVersionUID = 1L;
        protected InstanceConditionalTest splitTest;

        public SplitNode(InstanceConditionalTest splitTest, ARFFIMTDD tree) {
            super(tree);
            this.splitTest = splitTest;
        }

        public int instanceChildIndex(Instance inst) {
            return this.splitTest.branchForInstance(inst);
        }

        public Node descendOneStep(Instance inst) {
            return (Node)this.children.get(this.splitTest.branchForInstance(inst));
        }

        @Override
        public void describeSubtree(StringBuilder out, int indent) {
            for (int branch = 0; branch < this.children.size(); ++branch) {
                Node child = this.getChild(branch);
                if (child == null) continue;
                StringUtils.appendIndented(out, indent, "if ");
                out.append(this.splitTest.describeConditionForBranch(branch, this.tree.getModelContext()));
                out.append(": ");
                StringUtils.appendNewline(out);
                child.describeSubtree(out, indent + 2);
            }
        }

        @Override
        public double getPrediction(Instance inst) {
            return ((Node)this.children.get(this.splitTest.branchForInstance(inst))).getPrediction(inst);
        }
    }

    public static abstract class InnerNode
    extends Node {
        private static final long serialVersionUID = 1L;
        protected AutoExpandVector<Node> children = new AutoExpandVector();
        protected double PHsum = 0.0;
        protected double PHmin = Double.MAX_VALUE;
        protected double lossExamplesSeen;
        protected double lossFadedSumOriginal;
        protected double lossFadedSumAlternate;
        protected double lossNumQiTests;
        protected double lossSumQi;
        protected double previousWeight = 0.0;

        public InnerNode(ARFFIMTDD tree) {
            super(tree);
        }

        public int numChildren() {
            return this.children.size();
        }

        public Node getChild(int index) {
            return this.children.get(index);
        }

        @Override
        public int getChildIndex(Node child) {
            return this.children.indexOf(child);
        }

        @Override
        public void setChild(int index, Node child) {
            this.children.set(index, child);
        }

        @Override
        public void disableChangeDetection() {
            this.changeDetection = false;
            for (Node child : this.children) {
                child.disableChangeDetection();
            }
        }

        @Override
        public void restartChangeDetection() {
            if (this.alternateTree == null) {
                this.changeDetection = true;
                this.PHsum = 0.0;
                this.PHmin = 2.147483647E9;
                for (Node child : this.children) {
                    child.restartChangeDetection();
                }
            }
        }

        public boolean PageHinckleyTest(double error, double threshold) {
            this.PHsum += error;
            if (this.PHsum < this.PHmin) {
                this.PHmin = this.PHsum;
            }
            return this.PHsum - this.PHmin > threshold;
        }

        public void initializeAlternateTree() {
            this.alternateTree = this.tree.newLeafNode();
            this.alternateTree.originalNode = this;
            this.lossExamplesSeen = 0.0;
            this.lossFadedSumOriginal = 0.0;
            this.lossFadedSumAlternate = 0.0;
            this.lossNumQiTests = 0.0;
            this.lossSumQi = 0.0;
            this.previousWeight = 0.0;
            this.disableChangeDetection();
        }
    }

    public static class LeafNode
    extends Node {
        private static final long serialVersionUID = 1L;
        public FIMTDDPerceptron learningModel;
        protected AutoExpandVector<FIMTDDNumericAttributeClassObserver> attributeObservers = new AutoExpandVector();
        protected double examplesSeenAtLastSplitEvaluation = 0.0;
        protected int[] listAttributes;
        protected int numAttributes;

        public LeafNode(ARFFIMTDD tree, int subspaceSize) {
            super(tree);
            if (tree.buildingModelTree()) {
                this.learningModel = tree.newLeafModel();
            }
            this.examplesSeen = 0.0;
            this.sumOfValues = 0.0;
            this.sumOfSquares = 0.0;
            this.sumOfAbsErrors = 0.0;
            this.numAttributes = subspaceSize;
        }

        @Override
        public void setChild(int parentBranch, Node node) {
        }

        @Override
        public int getChildIndex(Node child) {
            return -1;
        }

        @Override
        public int getNumSubtrees() {
            return 1;
        }

        @Override
        protected boolean skipInLevelCount() {
            return false;
        }

        public void learnFromInstance(Instance inst, boolean growthAllowed, ARFFIMTDD arffimtdd) {
            int j;
            this.examplesSeen += inst.weight();
            this.sumOfValues += inst.weight() * inst.classValue();
            this.sumOfSquares += inst.weight() * inst.classValue() * inst.classValue();
            this.sumOfAbsErrors += inst.weight() * Math.abs(this.tree.normalizeTargetValue(Math.abs(inst.classValue() - this.getPrediction(inst))));
            if (this.tree.buildingModelTree()) {
                this.learningModel.updatePerceptron(inst);
            }
            if (this.listAttributes == null) {
                this.listAttributes = new int[this.numAttributes];
                for (j = 0; j < this.numAttributes; ++j) {
                    boolean isUnique = false;
                    block1: while (!isUnique) {
                        this.listAttributes[j] = arffimtdd.classifierRandom.nextInt(inst.numAttributes() - 1);
                        isUnique = true;
                        for (int i = 0; i < j; ++i) {
                            if (this.listAttributes[j] != this.listAttributes[i]) continue;
                            isUnique = false;
                            continue block1;
                        }
                    }
                }
            }
            for (j = 0; j < this.listAttributes.length; ++j) {
                int i = this.listAttributes[j];
                int instAttIndex = ARFFIMTDD.modelAttIndexToInstanceAttIndex(i, inst);
                FIMTDDNumericAttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null && inst.attribute(instAttIndex).isNumeric()) {
                    obs = this.tree.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                if (obs == null) continue;
                obs.observeAttributeClass(inst.value(instAttIndex), inst.classValue(), inst.weight());
            }
            if (growthAllowed) {
                this.checkForSplit(this.tree);
            }
        }

        public AttributeSplitSuggestion[] getBestSplitSuggestions(SplitCriterion criterion) {
            LinkedList<AttributeSplitSuggestion> bestSuggestions = new LinkedList<AttributeSplitSuggestion>();
            double[] nodeSplitDist = new double[]{this.examplesSeen, this.sumOfValues, this.sumOfSquares};
            for (int i = 0; i < this.attributeObservers.size(); ++i) {
                FIMTDDNumericAttributeClassObserver obs = this.attributeObservers.get(i);
                if (obs == null) continue;
                AttributeSplitSuggestion bestSuggestion = null;
                if (obs instanceof FIMTDDNumericAttributeClassObserver) {
                    bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, nodeSplitDist, i, true);
                }
                if (bestSuggestion == null) continue;
                bestSuggestions.add(bestSuggestion);
            }
            return bestSuggestions.toArray(new AttributeSplitSuggestion[bestSuggestions.size()]);
        }

        public double getPredictionModel(Instance inst) {
            return this.learningModel.prediction(inst);
        }

        public double getPredictionTargetMean(Instance inst) {
            return this.examplesSeen > 0.0 ? this.sumOfValues / this.examplesSeen : 0.0;
        }

        @Override
        public double getPrediction(Instance inst) {
            return this.tree.buildingModelTree() ? this.getPredictionModel(inst) : this.getPredictionTargetMean(inst);
        }

        public void checkForSplit(ARFFIMTDD tree) {
            if (this.examplesSeen - this.examplesSeenAtLastSplitEvaluation >= (double)tree.gracePeriodOption.getValue()) {
                int index = this.parent != null ? this.parent.getChildIndex(this) : 0;
                tree.attemptToSplit(this, this.parent, index);
                this.examplesSeenAtLastSplitEvaluation = this.examplesSeen;
            }
        }

        @Override
        public void describeSubtree(StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf ");
            if (this.tree.buildingModelTree()) {
                this.learningModel.getModelDescription(out, 0);
            } else {
                out.append(this.tree.getClassNameString() + " = " + String.format("%.4f", this.sumOfValues / this.examplesSeen));
                StringUtils.appendNewline(out);
            }
        }
    }

    public static abstract class Node
    extends AbstractMOAObject {
        private static final long serialVersionUID = 1L;
        public int ID;
        protected ARFFIMTDD tree;
        protected boolean changeDetection = true;
        protected Node parent;
        protected Node alternateTree;
        protected Node originalNode;
        protected double examplesSeen;
        protected double sumOfValues;
        protected double sumOfSquares;
        protected double sumOfAbsErrors;

        public Node(ARFFIMTDD tree) {
            this.tree = tree;
            this.ID = tree.maxID;
        }

        public void copyStatistics(Node node) {
            this.examplesSeen = node.examplesSeen;
            this.sumOfValues = node.sumOfValues;
            this.sumOfSquares = node.sumOfSquares;
            this.sumOfAbsErrors = node.sumOfAbsErrors;
        }

        public int calcByteSize() {
            return (int)SizeOf.fullSizeOf(this);
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public Node getParent() {
            return this.parent;
        }

        public void disableChangeDetection() {
            this.changeDetection = false;
        }

        public void restartChangeDetection() {
            this.changeDetection = true;
        }

        @Override
        public void getDescription(StringBuilder sb, int indent) {
        }

        public double getPrediction(Instance inst) {
            return 0.0;
        }

        public void describeSubtree(StringBuilder out, int indent) {
            StringUtils.appendIndented(out, indent, "Leaf");
        }

        public int getLevel() {
            Node target = this;
            int level = 0;
            while (target.getParent() != null) {
                if (target.skipInLevelCount()) {
                    target = target.getParent();
                    continue;
                }
                ++level;
                target = target.getParent();
            }
            if (target.originalNode == null) {
                return level;
            }
            return level + this.originalNode.getLevel();
        }

        public void setChild(int parentBranch, Node node) {
        }

        public int getChildIndex(Node child) {
            return -1;
        }

        public int getNumSubtrees() {
            return 1;
        }

        protected boolean skipInLevelCount() {
            return false;
        }
    }
}

