/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.Range;
import java.util.ArrayList;
import java.util.Random;
import moa.streams.filters.AbstractStreamFilter;

public class ReLUFilter
extends AbstractStreamFilter {
    private static final long serialVersionUID = 1L;
    protected InstancesHeader dataset;
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random noise.", 1);
    public IntOption numLatentOption = new IntOption("numLatent", 'h', "Percent of basis functions (wrt number of input attributes).", 10);
    private int H = 200;
    protected Random random;
    protected double[][] W;

    @Override
    public String getPurposeString() {
        return "Creates a random projection of the feature space with ReLU functions.";
    }

    @Override
    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    @Override
    public Instance filterInstance(Instance x) {
        if (this.dataset == null) {
            this.initialize(x);
        }
        double[] z_ = new double[this.H + 1];
        int d = x.numAttributes() - 1;
        for (int k = 0; k < this.H; ++k) {
            double a_k = 0.0;
            for (int j = 0; j < d; ++j) {
                a_k += x.value(j) * this.W[k][j];
            }
            z_[k] = a_k > 0.0 ? a_k : 0.0;
        }
        z_[this.H] = x.classValue();
        InstanceImpl z = new InstanceImpl(x.weight(), z_);
        z.setDataset(this.dataset);
        return z;
    }

    @Override
    protected void restartImpl() {
        this.random = new Random(this.randomSeedOption.getValue());
    }

    private void initialize(Instance instance) {
        this.random = new Random(this.randomSeedOption.getValue());
        int d = instance.numAttributes() - 1;
        this.H = this.numLatentOption.getValue() < 0 ? this.numLatentOption.getValue() : d * this.numLatentOption.getValue() / 100;
        this.W = new double[this.H][d];
        for (int j = 0; j < this.H; ++j) {
            for (int k = 0; k < d; ++k) {
                this.W[j][k] = this.random.nextGaussian();
            }
        }
        Instances ds = new Instances();
        ArrayList<Attribute> v = new ArrayList<Attribute>(this.H);
        ArrayList<Integer> indexValues = new ArrayList<Integer>(this.H);
        for (int j = 0; j < this.H; ++j) {
            v.add(new Attribute("z" + String.valueOf(j)));
            indexValues.add(j);
        }
        v.add(instance.dataset().classAttribute());
        indexValues.add(this.H);
        ds.setAttributes(v, indexValues);
        Range r = new Range("start-end");
        ds.setRangeOutputIndices(r);
        this.dataset = new InstancesHeader(ds);
        this.dataset.setClassIndex(this.H);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

