/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import com.github.javacliparser.FlagOption;
import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Random;
import moa.capabilities.CapabilitiesHandler;
import moa.capabilities.Capability;
import moa.capabilities.ImmutableCapabilities;
import moa.core.FastVector;
import moa.core.InstanceExample;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;

public class STAGGERGenerator
extends AbstractOptionHandler
implements InstanceStream,
CapabilitiesHandler {
    private static final long serialVersionUID = 1L;
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public IntOption functionOption = new IntOption("function", 'f', "Classification function used, as defined in the original paper.", 1, 1, 3);
    public FlagOption balanceClassesOption = new FlagOption("balanceClasses", 'b', "Balance the number of instances of each class.");
    protected static ClassFunction[] classificationFunctions = new ClassFunction[]{new ClassFunction(){

        @Override
        public int determineClass(int size, int color, int shape) {
            return size == 0 && color == 0 ? 1 : 0;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(int size, int color, int shape) {
            return color == 2 || shape == 0 ? 1 : 0;
        }
    }, new ClassFunction(){

        @Override
        public int determineClass(int size, int color, int shape) {
            return size == 1 || size == 2 ? 1 : 0;
        }
    }};
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected boolean nextClassShouldBeZero;

    @Override
    public String getPurposeString() {
        return "Generates STAGGER Concept functions.";
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        FastVector<String> sizeLabels = new FastVector<String>();
        sizeLabels.addElement("small");
        sizeLabels.addElement("medium");
        sizeLabels.addElement("large");
        attributes.addElement(new Attribute("size", sizeLabels));
        FastVector<String> colorLabels = new FastVector<String>();
        colorLabels.addElement("red");
        colorLabels.addElement("blue");
        colorLabels.addElement("green");
        attributes.addElement(new Attribute("color", colorLabels));
        FastVector<String> shapeLabels = new FastVector<String>();
        shapeLabels.addElement("circle");
        shapeLabels.addElement("square");
        shapeLabels.addElement("triangle");
        attributes.addElement(new Attribute("shape", shapeLabels));
        FastVector<String> classLabels = new FastVector<String>();
        classLabels.addElement("false");
        classLabels.addElement("true");
        attributes.addElement(new Attribute("class", classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    @Override
    public long estimatedRemainingInstances() {
        return -1L;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    @Override
    public boolean hasMoreInstances() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public InstanceExample nextInstance() {
        int size = 0;
        int color = 0;
        int shape = 0;
        int group = 0;
        boolean desiredClassFound = false;
        while (!desiredClassFound) {
            size = this.instanceRandom.nextInt(3);
            color = this.instanceRandom.nextInt(3);
            shape = this.instanceRandom.nextInt(3);
            group = classificationFunctions[this.functionOption.getValue() - 1].determineClass(size, color, shape);
            if (!this.balanceClassesOption.isSet()) {
                desiredClassFound = true;
                continue;
            }
            if ((!this.nextClassShouldBeZero || group != 0) && (this.nextClassShouldBeZero || group != 1)) continue;
            desiredClassFound = true;
            this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
        }
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance((double)header.numAttributes());
        inst.setValue(0, (double)size);
        inst.setValue(1, (double)color);
        inst.setValue(2, (double)shape);
        inst.setDataset(header);
        inst.setClassValue(group);
        return new InstanceExample(inst);
    }

    @Override
    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextClassShouldBeZero = false;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    public ImmutableCapabilities defineImmutableCapabilities() {
        if (this.getClass() == STAGGERGenerator.class) {
            return new ImmutableCapabilities(Capability.VIEW_STANDARD, Capability.VIEW_LITE);
        }
        return new ImmutableCapabilities(Capability.VIEW_STANDARD);
    }

    protected static interface ClassFunction {
        public int determineClass(int var1, int var2, int var3);
    }
}

