/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.plugins.tiff;

import java.io.IOException;

public class TIFFPackBitsUtil {
    private static final boolean debug = false;
    byte[] dstData = new byte[8192];
    int dstIndex = 0;

    private void ensureCapacity(int bytesToAdd) {
        if (this.dstIndex + bytesToAdd > this.dstData.length) {
            byte[] newDstData = new byte[Math.max((int)((float)this.dstData.length * 1.2f), this.dstIndex + bytesToAdd)];
            System.arraycopy(this.dstData, 0, newDstData, 0, this.dstData.length);
            this.dstData = newDstData;
        }
    }

    public byte[] decode(byte[] srcData) throws IOException {
        int inIndex = 0;
        while (inIndex < srcData.length) {
            byte b;
            if ((b = srcData[inIndex++]) >= 0 && b <= 127) {
                this.ensureCapacity(b + 1);
                for (int i = 0; i < b + 1; ++i) {
                    this.dstData[this.dstIndex++] = srcData[inIndex++];
                }
                continue;
            }
            if (b <= -1 && b >= -127) {
                byte repeat = srcData[inIndex++];
                this.ensureCapacity(-b + 1);
                for (int i = 0; i < -b + 1; ++i) {
                    this.dstData[this.dstIndex++] = repeat;
                }
                continue;
            }
            ++inIndex;
        }
        byte[] newDstData = new byte[this.dstIndex];
        System.arraycopy(this.dstData, 0, newDstData, 0, this.dstIndex);
        return newDstData;
    }
}

