/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.app.tools.NexusExporter;
import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.tree.SimpleNode;
import dr.evolution.tree.SimpleTree;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Date;
import dr.evolution.util.Taxa;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.math.MathUtils;
import dr.util.HeapSort;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class CoalescentSimulator {
    private final ArrayList<SimpleNode> nodeList = new ArrayList();
    private int activeNodeCount = 0;

    public SimpleTree simulateTree(TaxonList taxonList, DemographicFunction demographicFunction) {
        int n;
        if (taxonList.getTaxonCount() == 0) {
            return new SimpleTree();
        }
        SimpleNode[] simpleNodeArray = new SimpleNode[taxonList.getTaxonCount()];
        for (n = 0; n < taxonList.getTaxonCount(); ++n) {
            simpleNodeArray[n] = new SimpleNode();
            simpleNodeArray[n].setTaxon(taxonList.getTaxon(n));
        }
        n = Taxon.getMostRecentDate() != null ? 1 : 0;
        for (int i = 0; i < taxonList.getTaxonCount(); ++i) {
            Taxon taxon = taxonList.getTaxon(i);
            if (n != 0) {
                simpleNodeArray[i].setHeight(taxon.getHeight());
                continue;
            }
            simpleNodeArray[i].setHeight(0.0);
        }
        return new SimpleTree(this.simulateCoalescent(simpleNodeArray, demographicFunction));
    }

    public SimpleNode simulateCoalescent(SimpleNode[] simpleNodeArray, DemographicFunction demographicFunction) {
        if (!TreeUtils.allDisjoint(simpleNodeArray)) {
            throw new RuntimeException("subtrees' taxa overlap");
        }
        if (simpleNodeArray.length == 0) {
            throw new IllegalArgumentException("empty nodes set");
        }
        for (int i = 0; i < 1000; ++i) {
            SimpleNode[] simpleNodeArray2 = this.simulateCoalescent(simpleNodeArray, demographicFunction, 0.0, Double.POSITIVE_INFINITY);
            if (simpleNodeArray2.length != 1) continue;
            return simpleNodeArray2[0];
        }
        throw new RuntimeException("failed to merge trees after 1000 tries.");
    }

    public SimpleNode[] simulateCoalescent(SimpleNode[] simpleNodeArray, DemographicFunction demographicFunction, double d, double d2) {
        return this.simulateCoalescent(simpleNodeArray, demographicFunction, d, d2, false);
    }

    public SimpleNode[] simulateCoalescent(SimpleNode[] simpleNodeArray, DemographicFunction demographicFunction, double d, double d2, boolean bl) {
        if (simpleNodeArray.length == 1) {
            return simpleNodeArray;
        }
        double[] dArray = new double[simpleNodeArray.length];
        for (int i = 0; i < simpleNodeArray.length; ++i) {
            dArray[i] = simpleNodeArray[i].getHeight();
        }
        int[] nArray = new int[simpleNodeArray.length];
        HeapSort.sort(dArray, nArray);
        this.nodeList.clear();
        this.activeNodeCount = 0;
        for (int i = 0; i < simpleNodeArray.length; ++i) {
            this.nodeList.add(simpleNodeArray[nArray[i]]);
        }
        this.setCurrentHeight(d);
        while (this.getActiveNodeCount() < 2) {
            d = this.getMinimumInactiveHeight();
            this.setCurrentHeight(d);
        }
        double d3 = !bl ? d + DemographicFunction.Utils.getSimulatedInterval(demographicFunction, this.getActiveNodeCount(), d) : d + DemographicFunction.Utils.getSimulatedInterval(demographicFunction, this.getActiveNodeCount(), d, d2);
        while (d3 < d2 && this.getNodeCount() > 1) {
            if (d3 >= this.getMinimumInactiveHeight()) {
                d = this.getMinimumInactiveHeight();
                this.setCurrentHeight(d);
            } else {
                d = d3;
                this.coalesceTwoActiveNodes(d);
            }
            if (this.getNodeCount() <= 1) continue;
            while (this.getActiveNodeCount() < 2) {
                d = this.getMinimumInactiveHeight();
                this.setCurrentHeight(d);
            }
            if (!bl) {
                d3 = d + DemographicFunction.Utils.getSimulatedInterval(demographicFunction, this.getActiveNodeCount(), d);
                continue;
            }
            d3 = d + DemographicFunction.Utils.getSimulatedInterval(demographicFunction, this.getActiveNodeCount(), d, d2);
        }
        SimpleNode[] simpleNodeArray2 = new SimpleNode[this.nodeList.size()];
        for (int i = 0; i < simpleNodeArray2.length; ++i) {
            simpleNodeArray2[i] = this.nodeList.get(i);
        }
        return simpleNodeArray2;
    }

    private double getMinimumInactiveHeight() {
        if (this.activeNodeCount < this.nodeList.size()) {
            return this.nodeList.get(this.activeNodeCount).getHeight();
        }
        return Double.POSITIVE_INFINITY;
    }

    private void setCurrentHeight(double d) {
        while (this.getMinimumInactiveHeight() <= d) {
            ++this.activeNodeCount;
        }
    }

    private int getActiveNodeCount() {
        return this.activeNodeCount;
    }

    private int getNodeCount() {
        return this.nodeList.size();
    }

    private void coalesceTwoActiveNodes(double d) {
        int n;
        int n2 = n = MathUtils.nextInt(this.activeNodeCount);
        while (n2 == n) {
            n2 = MathUtils.nextInt(this.activeNodeCount);
        }
        SimpleNode simpleNode = this.nodeList.get(n);
        SimpleNode simpleNode2 = this.nodeList.get(n2);
        SimpleNode simpleNode3 = new SimpleNode();
        simpleNode3.setHeight(d);
        simpleNode3.addChild(simpleNode);
        simpleNode3.addChild(simpleNode2);
        this.nodeList.remove(simpleNode);
        this.nodeList.remove(simpleNode2);
        this.activeNodeCount -= 2;
        this.nodeList.add(this.activeNodeCount, simpleNode3);
        ++this.activeNodeCount;
        if (this.getMinimumInactiveHeight() < d) {
            throw new RuntimeException("This should never happen! Somehow the current active node is older than the next inactive node!");
        }
    }

    public static void main1(String[] stringArray) {
        int n;
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        ExponentialGrowth exponentialGrowth = new ExponentialGrowth(Units.Type.YEARS);
        exponentialGrowth.setN0(10.0);
        exponentialGrowth.setGrowthRate(0.5);
        ConstantPopulation constantPopulation = new ConstantPopulation(Units.Type.YEARS);
        constantPopulation.setN0(10.0);
        Taxa taxa = new Taxa();
        int n2 = 1;
        for (double d : dArray) {
            Taxon taxon = new Taxon("tip" + n2);
            taxon.setAttribute("date", new Date(d, Units.Type.YEARS, true));
            ++n2;
            taxa.addTaxon(taxon);
        }
        Object object = new CoalescentSimulator();
        SimpleTree simpleTree = ((CoalescentSimulator)object).simulateTree(taxa, exponentialGrowth);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (n = 0; n < simpleTree.getInternalNodeCount(); ++n) {
            arrayList.add(simpleTree.getNodeHeight(simpleTree.getInternalNode(n)));
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            System.out.println(n + "\t" + arrayList.get(n));
        }
    }

    public static void main(String[] stringArray) {
        int n = 100000000;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        ConstantPopulation constantPopulation = new ConstantPopulation(Units.Type.YEARS);
        constantPopulation.setN0(1.0);
        Taxa taxa = new Taxa();
        int n2 = 1;
        for (double d : dArray) {
            Taxon taxon = new Taxon("tip" + n2);
            taxon.setAttribute("date", new Date(d, Units.Type.YEARS, true));
            ++n2;
            taxa.addTaxon(taxon);
        }
        Object object = new CoalescentSimulator();
        PrintStream printStream = System.out;
        NexusExporter nexusExporter = new NexusExporter(printStream);
        SimpleTree simpleTree = ((CoalescentSimulator)object).simulateTree(taxa, constantPopulation);
        Map map = nexusExporter.writeNexusHeader((Tree)simpleTree);
        printStream.println("\t\t;");
        nexusExporter.writeNexusTree((Tree)simpleTree, "TREE_0", true, map);
        for (n2 = 1; n2 < n; ++n2) {
            simpleTree = ((CoalescentSimulator)object).simulateTree(taxa, constantPopulation);
            nexusExporter.writeNexusTree((Tree)simpleTree, "TREE_" + n2, true, map);
        }
        printStream.println("End;");
    }
}

