/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.LogisticGrowth;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodelxml.coalescent.demographicmodel.LogisticGrowthModelParser;
import dr.inference.model.Parameter;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class LogisticGrowthModel
extends DemographicModel
implements Citable {
    Parameter N0Parameter = null;
    Parameter growthRateParameter = null;
    Parameter shapeParameter = null;
    double alpha = 0.5;
    LogisticGrowth logisticGrowth = null;
    boolean usingGrowthRate = true;
    public static Citation CITATION = new Citation(new Author[]{new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "GENIE: estimating demographic history from molecular phylogenies", 2001, "Bioinformatics", 18, 1404, 1405);

    public LogisticGrowthModel(Parameter parameter, Parameter parameter2, Parameter parameter3, double d, Units.Type type, boolean bl) {
        this(LogisticGrowthModelParser.LOGISTIC_GROWTH_MODEL, parameter, parameter2, parameter3, d, type, bl);
    }

    public LogisticGrowthModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, double d, Units.Type type, boolean bl) {
        super(string);
        this.logisticGrowth = new LogisticGrowth(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.growthRateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.shapeParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.alpha = d;
        this.usingGrowthRate = bl;
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.logisticGrowth.setN0(this.N0Parameter.getParameterValue(0));
        if (this.usingGrowthRate) {
            double d = this.growthRateParameter.getParameterValue(0);
            this.logisticGrowth.setGrowthRate(d);
        } else {
            double d = this.growthRateParameter.getParameterValue(0);
            this.logisticGrowth.setDoublingTime(d);
        }
        this.logisticGrowth.setTime50(this.shapeParameter.getParameterValue(0) - this.getTimeOffset());
        return this.logisticGrowth;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Logistic Growth Coalescent";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

