/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.alignment.PatternList;
import dr.evolution.tree.NodeRef;
import dr.evomodel.continuous.AbstractMultivariateTraitLikelihood;
import dr.evomodel.continuous.LatentTruncation;
import dr.evomodel.continuous.SoftThresholdLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.FastMatrixParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.Distribution;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AndRule;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public class OrderedLatentLiabilityLikelihood
extends AbstractModelLikelihood
implements LatentTruncation,
Citable,
SoftThresholdLikelihood {
    public static final String ORDERED_LATENT_LIABILITY_LIKELIHOOD = "orderedLatentLiabilityLikelihood";
    private final LatentTruncation.Delegate normalizationDelegate = new LatentTruncation.Delegate(){

        @Override
        protected double computeNormalizationConstant(Distribution distribution) {
            double d = 0.0;
            return d;
        }
    };
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String TIP_TRAIT = "tipTrait";
        public static final String THRESHOLD_PARAMETER = "threshold";
        public static final String NUM_CLASSES = "numClasses";
        public static final String IS_UNORDERED = "isUnordered";
        public static final String N_DATA = "NData";
        public static final String N_TRAITS = "NTraits";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new XORRule(new ElementRule(AbstractMultivariateTraitLikelihood.class), new AndRule(AttributeRule.newIntegerRule("NData"), AttributeRule.newIntegerRule("NTraits"))), new ElementRule("tipTrait", CompoundParameter.class, "The parameter of tip locations from the tree"), new ElementRule("threshold", CompoundParameter.class, "The parameter with nonzero thershold values"), new ElementRule("numClasses", Parameter.class, "Number of multinomial classes in each dimention"), new ElementRule(PatternList.class, "The binary/multinomial tip data"), new ElementRule(TreeModel.class, "The tree model"), AttributeRule.newBooleanRule("isUnordered", true)};

        @Override
        public String getParserName() {
            return OrderedLatentLiabilityLikelihood.ORDERED_LATENT_LIABILITY_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n;
            int n2;
            Object object;
            Object object2;
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            int n3 = treeModel.getTaxonCount();
            CompoundParameter compoundParameter = (CompoundParameter)xMLObject.getElementFirstChild(TIP_TRAIT);
            if (xMLObject.hasAttribute(N_DATA) && xMLObject.hasAttribute(N_TRAITS)) {
                object2 = (String)xMLObject.getAttribute(N_DATA);
                object = (String)xMLObject.getAttribute(N_TRAITS);
                n2 = Integer.parseInt((String)object2);
                n = Integer.parseInt((String)object);
            } else {
                object2 = (AbstractMultivariateTraitLikelihood)xMLObject.getChild(AbstractMultivariateTraitLikelihood.class);
                if (object2 != null) {
                    n2 = ((AbstractMultivariateTraitLikelihood)object2).getNumData();
                    n = ((AbstractMultivariateTraitLikelihood)object2).getDimTrait();
                } else {
                    n2 = 1;
                    if (compoundParameter.getParameterCount() != n3) {
                        throw new XMLParseException("Tip trait parameter is wrong dimension");
                    }
                    n = compoundParameter.getDimension() / n3;
                }
            }
            object2 = (PatternList)xMLObject.getChild(PatternList.class);
            object = (CompoundParameter)xMLObject.getElementFirstChild(THRESHOLD_PARAMETER);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(NUM_CLASSES);
            boolean bl = xMLObject.getAttribute(IS_UNORDERED, false);
            if (compoundParameter.getDimension() != n3 * n2 * n) {
                throw new XMLParseException("Tip trait parameter is wrong dimension in latent liability model");
            }
            if (!bl && object2.getPatternCount() != n2 * n) {
                throw new XMLParseException("Data are wrong dimension in latent liability model. Pattern count = " + object2.getPatternCount() + ", while per-taxon parameter dimension = " + n2 * n);
            }
            return new OrderedLatentLiabilityLikelihood(treeModel, (PatternList)object2, compoundParameter, (CompoundParameter)object, parameter, bl);
        }

        @Override
        public String getParserDescription() {
            return "Provides the likelihood of a latent liability model on multivariate ordered trait data";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return OrderedLatentLiabilityLikelihood.class;
        }
    };
    public TreeModel treeModel;
    private PatternList patternList;
    public CompoundParameter tipTraitParameter;
    private CompoundParameter thresholdParameter;
    private final HashMap<Integer, Integer> thresholdIndices;
    public Parameter numClasses;
    private Parameter containsMissing;
    private int NAcode;
    private boolean isUnordered = false;
    private int[][] tipData;
    private boolean likelihoodKnown = false;
    private double logLikelihood;
    private double storedLogLikelihood;
    private static final boolean DEBUG = false;
    private double pathParameter = 1.0;

    public OrderedLatentLiabilityLikelihood(TreeModel treeModel, PatternList patternList, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, Parameter parameter, boolean bl) {
        super(ORDERED_LATENT_LIABILITY_LIKELIHOOD);
        this.treeModel = treeModel;
        this.patternList = patternList;
        this.tipTraitParameter = compoundParameter;
        this.thresholdParameter = compoundParameter2;
        this.numClasses = parameter;
        this.isUnordered = bl;
        this.NAcode = this.setNAcode();
        this.thresholdIndices = this.setupThresholdIndices();
        this.addVariable(compoundParameter);
        this.addVariable(compoundParameter2);
        this.setTipDataValuesForAllNodes();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing a latent liability likelihood model:\n");
        stringBuilder.append("\tBinary patterns: ").append(patternList.getId()).append("\n");
        stringBuilder.append("\tPlease cite:\n").append(Citable.Utils.getCitationString(this));
        Logger.getLogger("dr.evomodel.continous").info(stringBuilder.toString());
    }

    private HashMap<Integer, Integer> setupThresholdIndices() {
        int n = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.numClasses.getDimension(); ++i) {
            if (!(this.numClasses.getParameterValue(i) > 2.0)) continue;
            hashMap.put(i, n);
            ++n;
        }
        return hashMap;
    }

    public ArrayList<Integer> getConstrainedTraits() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.numClasses.getDimension(); ++i) {
            if (!(this.numClasses.getParameterValue(i) > 1.0)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public CompoundParameter getTipTraitParameter() {
        return this.tipTraitParameter;
    }

    public PatternList getPatternList() {
        return this.patternList;
    }

    private void setTipDataValuesForAllNodes() {
        if (this.tipData == null) {
            this.tipData = new int[this.treeModel.getExternalNodeCount()][this.patternList.getPatternCount()];
        }
        int n = this.tipTraitParameter.getParameter(0).getDimension();
        double[] dArray = new double[n * this.treeModel.getExternalNodeCount()];
        double[] dArray2 = new double[n * this.treeModel.getExternalNodeCount()];
        this.getTipDataValuesForAllNode(dArray, dArray2);
        if (this.tipTraitParameter instanceof FastMatrixParameter) {
            this.tipTraitParameter.addBounds(new Parameter.DefaultBounds(dArray, dArray2));
        } else {
            for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
                double[] dArray3 = new double[n];
                double[] dArray4 = new double[n];
                String string = this.treeModel.getTaxonId(i);
                int n2 = this.patternList.getTaxonIndex(string);
                System.arraycopy(dArray, i * n, dArray3, 0, n);
                System.arraycopy(dArray2, i * n, dArray4, 0, n);
                this.tipTraitParameter.getParameter(i).addBounds(new Parameter.DefaultBounds(dArray3, dArray4));
            }
        }
    }

    private void getTipDataValuesForAllNode(double[] dArray, double[] dArray2) {
        int n = this.tipTraitParameter.getParameter(0).getDimension();
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        for (int i = 0; i < this.treeModel.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = this.treeModel.getExternalNode(i);
            String string = this.treeModel.getTaxonId(i);
            int n2 = this.patternList.getTaxonIndex(string);
            this.getTipDataValueForNode(nodeRef, n2, dArray3, dArray4);
            System.arraycopy(dArray3, 0, dArray, i * n, n);
            System.arraycopy(dArray4, 0, dArray2, i * n, n);
        }
    }

    private void getTipDataValueForNode(NodeRef nodeRef, int n, double[] dArray, double[] dArray2) {
        int n2 = nodeRef.getNumber();
        block4: for (int i = 0; i < this.patternList.getPatternCount(); ++i) {
            this.tipData[n2][i] = this.patternList.getPattern(i)[n];
            switch (this.tipData[n2][i]) {
                case 0: {
                    dArray[i] = 0.0;
                    dArray2[i] = Double.NEGATIVE_INFINITY;
                    continue block4;
                }
                case 1: {
                    dArray[i] = Double.POSITIVE_INFINITY;
                    dArray2[i] = 0.0;
                    continue block4;
                }
                default: {
                    dArray[i] = Double.POSITIVE_INFINITY;
                    dArray2[i] = Double.NEGATIVE_INFINITY;
                }
            }
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = true;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void setPathParameter(double d) {
        this.pathParameter = d;
    }

    @Override
    public double getLikelihoodCorrection() {
        boolean bl = true;
        for (int i = 0; i < this.tipData.length && bl; ++i) {
            bl = this.validTraitForTip(i);
        }
        if (bl) {
            return 0.0;
        }
        return -1.0 / (1.0 - this.pathParameter);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.getLogLikelihood() + ")";
    }

    protected double computeLogLikelihood() {
        boolean bl = true;
        for (int i = 0; i < this.tipData.length && bl; ++i) {
            bl = this.validTraitForTip(i);
        }
        if (bl) {
            return 0.0;
        }
        if (this.pathParameter == 1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(1.0 - this.pathParameter);
    }

    public int[] getData(int n) {
        return this.tipData[n];
    }

    private boolean validTraitForTipOrdered(double d, int n, int n2) {
        int n3 = this.tipData[n][n2];
        if ((double)n3 == -1.0) {
            return true;
        }
        int n4 = (int)this.numClasses.getParameterValue(n2);
        if ((double)n4 == 1.0) {
            return true;
        }
        if ((double)n4 == 2.0) {
            boolean bl;
            if (d == 0.0) {
                return true;
            }
            if (n3 > 1) {
                return true;
            }
            boolean bl2 = bl = d > 0.0;
            if (bl) {
                return (double)n3 == 1.0;
            }
            return (double)n3 == 0.0;
        }
        int n5 = this.thresholdIndices.get(n2);
        if (n3 == 0) {
            return d <= 0.0;
        }
        if (n3 == 1) {
            return d >= 0.0 && d <= this.thresholdParameter.getParameter(n5).getParameterValue(0);
        }
        if (n3 == n4 - 1) {
            return d >= this.thresholdParameter.getParameter(n5).getParameterValue(n4 - 3);
        }
        if (n3 > n4 - 1) {
            return true;
        }
        return d >= this.thresholdParameter.getParameter(n5).getParameterValue(n3 - 2) && d <= this.thresholdParameter.getParameter(n5).getParameterValue(n3 - 1);
    }

    private boolean validTraitForTipUnordered(double d, int n, int n2) {
        throw new RuntimeException("not yet implemented");
    }

    public boolean validTraitForTip(double d, int n, int n2) {
        if (this.isUnordered) {
            return this.validTraitForTipUnordered(d, n, n2);
        }
        return this.validTraitForTipOrdered(d, n, n2);
    }

    @Override
    public boolean validTraitForTip(int n) {
        boolean bl = true;
        Parameter parameter = this.tipTraitParameter.getParameter(n);
        int[] nArray = this.tipData[n];
        if (!this.isUnordered) {
            for (int i = 0; i < nArray.length && bl; ++i) {
                double d = parameter.getParameterValue(i);
                bl = this.validTraitForTipOrdered(d, n, i);
            }
        } else {
            int n2 = 0;
            for (int i = 0; i < nArray.length && bl; ++i) {
                int n3 = nArray[i];
                int n4 = (int)this.numClasses.getParameterValue(i);
                if (n3 == this.NAcode) {
                    bl = true;
                    if (n4 == 1) {
                        ++n2;
                        continue;
                    }
                    n2 += n4 - 1;
                    continue;
                }
                if ((double)n4 == 1.0) {
                    bl = true;
                    ++n2;
                    continue;
                }
                if ((double)n4 == 2.0) {
                    double d = parameter.getParameterValue(n2);
                    if (d == 0.0) {
                        bl = true;
                    } else {
                        boolean bl2;
                        boolean bl3 = bl2 = d > 0.0;
                        bl = bl2 ? (double)n3 == 1.0 : (double)n3 == 0.0;
                    }
                    ++n2;
                    continue;
                }
                double[] dArray = new double[n4];
                dArray[0] = 0.0;
                for (int j = 1; j < n4; ++j) {
                    dArray[j] = parameter.getParameterValue(n2 + j - 1);
                }
                bl = this.isMax(dArray, n3);
                n2 += n4 - 1;
            }
        }
        return bl;
    }

    private boolean isMax(double[] dArray, int n) {
        boolean bl = true;
        for (int i = 0; i < dArray.length && bl; ++i) {
            bl = dArray[n] >= dArray[i];
        }
        return bl;
    }

    private int setNAcode() {
        int n = this.numClasses.getDimension();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (int)this.numClasses.getParameterValue(i);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    @Override
    public double getNormalizationConstant(Distribution distribution) {
        return this.normalizationDelegate.getNormalizationConstant(distribution);
    }

    public Boolean getOrdering() {
        return this.isUnordered;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TRAIT_MODELS;
    }

    @Override
    public String getDescription() {
        return "Latent Liability model";
    }

    @Override
    public List<Citation> getCitations() {
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        arrayList.add(CommonCitations.CYBIS_2015_ASSESSING);
        return arrayList;
    }

    public Parameter getThreshold() {
        return this.thresholdParameter;
    }
}

