/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.epidemiology.casetocase.AbstractCase;
import dr.evomodel.epidemiology.casetocase.BranchMapModel;
import dr.evomodel.epidemiology.casetocase.CaseToCaseTreeLikelihood;
import dr.evomodel.epidemiology.casetocase.PartitionedTreeModel;
import dr.evomodel.epidemiology.casetocase.operators.TransmissionSubtreeSlideA;
import dr.evomodel.operators.AbstractAdaptableTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TransmissionSubtreeSlideB
extends AbstractAdaptableTreeOperator {
    private CaseToCaseTreeLikelihood c2cLikelihood;
    private PartitionedTreeModel tree;
    private double size = 1.0;
    private boolean gaussian = false;
    private final boolean swapInRandomRate;
    private final boolean swapInRandomTrait;
    private final boolean resampleInfectionTimes;
    private AdaptationMode mode = AdaptationMode.DEFAULT;
    private static final boolean DEBUG = false;
    public static final String TRANSMISSION_SUBTREE_SLIDE_B = "transmissionSubtreeSlideB";
    public static final String SWAP_RATES = "swapInRandomRate";
    public static final String SWAP_TRAITS = "swapInRandomTrait";
    public static final String TARGET_ACCEPTANCE = "targetAcceptance";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String RESAMPLE_INFECTION_TIMES = "resampleInfectionTimes";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("size", true), AttributeRule.newDoubleRule("targetAcceptance", true), AttributeRule.newBooleanRule("gaussian"), AttributeRule.newBooleanRule("swapInRandomRate", true), AttributeRule.newBooleanRule("swapInRandomTrait", true), AttributeRule.newBooleanRule("autoOptimize", true), AttributeRule.newBooleanRule("resampleInfectionTimes", true), new ElementRule(CaseToCaseTreeLikelihood.class)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.getAttribute(TransmissionSubtreeSlideB.SWAP_RATES, false);
            boolean bl2 = xMLObject.getAttribute(TransmissionSubtreeSlideB.SWAP_TRAITS, false);
            AdaptationMode adaptationMode = AdaptationMode.DEFAULT;
            if (xMLObject.hasAttribute("autoOptimize")) {
                adaptationMode = xMLObject.getBooleanAttribute("autoOptimize") ? AdaptationMode.ADAPTATION_ON : AdaptationMode.ADAPTATION_OFF;
            }
            CaseToCaseTreeLikelihood caseToCaseTreeLikelihood = (CaseToCaseTreeLikelihood)xMLObject.getChild(CaseToCaseTreeLikelihood.class);
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getAttribute(TransmissionSubtreeSlideB.TARGET_ACCEPTANCE, 0.234);
            double d3 = xMLObject.getAttribute("size", 1.0);
            if (Double.isInfinite(d3) || d3 <= 0.0) {
                throw new XMLParseException("size attribute must be positive and not infinite. was " + d3 + " for tree " + caseToCaseTreeLikelihood.getTreeModel().getId());
            }
            boolean bl3 = false;
            if (xMLObject.hasAttribute(RESAMPLE_INFECTION_TIMES)) {
                bl3 = xMLObject.getBooleanAttribute(RESAMPLE_INFECTION_TIMES);
            }
            boolean bl4 = xMLObject.getBooleanAttribute("gaussian");
            TransmissionSubtreeSlideB transmissionSubtreeSlideB = new TransmissionSubtreeSlideB(caseToCaseTreeLikelihood, d, d3, bl4, bl, bl2, adaptationMode, bl3);
            return transmissionSubtreeSlideB;
        }

        @Override
        public String getParserDescription() {
            return "An operator that slides a phylogenetic subtree and a transmission subtree simultaneously.";
        }

        @Override
        public Class getReturnType() {
            return TransmissionSubtreeSlideA.class;
        }

        @Override
        public String getParserName() {
            return TransmissionSubtreeSlideB.TRANSMISSION_SUBTREE_SLIDE_B;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public TransmissionSubtreeSlideB(CaseToCaseTreeLikelihood caseToCaseTreeLikelihood, double d, double d2, boolean bl, boolean bl2, boolean bl3, AdaptationMode adaptationMode, boolean bl4) {
        super(adaptationMode);
        this.c2cLikelihood = caseToCaseTreeLikelihood;
        this.tree = caseToCaseTreeLikelihood.getTreeModel();
        this.setWeight(d);
        if (d2 == 0.0) {
            double d3 = 0.0;
            for (int i = 0; i < this.tree.getNodeCount(); ++i) {
                d3 += this.tree.getBranchLength(this.tree.getNode(i));
            }
            d2 = d3 / (double)(2 * this.tree.getNodeCount());
        }
        this.size = d2;
        this.gaussian = bl;
        this.swapInRandomRate = bl2;
        this.swapInRandomTrait = bl3;
        this.resampleInfectionTimes = bl4;
        this.mode = adaptationMode;
    }

    @Override
    public double doOperation() {
        double d;
        Serializable serializable;
        NodeRef nodeRef;
        BranchMapModel branchMapModel = this.c2cLikelihood.getBranchMap();
        while (!this.eligibleForMove(nodeRef = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount())), this.tree, branchMapModel)) {
        }
        NodeRef nodeRef2 = this.tree.getParent(nodeRef);
        NodeRef nodeRef3 = this.getOtherChild(this.tree, nodeRef2, nodeRef);
        NodeRef nodeRef4 = this.tree.getParent(nodeRef2);
        double d2 = this.getDelta();
        double d3 = this.tree.getNodeHeight(nodeRef2);
        double d4 = d3 + d2;
        AbstractCase abstractCase = branchMapModel.get(nodeRef.getNumber());
        AbstractCase abstractCase2 = branchMapModel.get(nodeRef2.getNumber());
        AbstractCase abstractCase3 = branchMapModel.get(nodeRef3.getNumber());
        AbstractCase abstractCase4 = null;
        if (nodeRef4 != null) {
            abstractCase4 = branchMapModel.get(nodeRef4.getNumber());
        }
        if (this.resampleInfectionTimes) {
            abstractCase.setInfectionBranchPosition(MathUtils.nextDouble());
            if (abstractCase4 == null || abstractCase3 != abstractCase4) {
                abstractCase3.setInfectionBranchPosition(MathUtils.nextDouble());
            }
        }
        if (d2 > 0.0) {
            if (nodeRef4 != null && this.tree.getNodeHeight(nodeRef4) < d4) {
                AbstractCase abstractCase5;
                serializable = nodeRef4;
                NodeRef nodeRef5 = nodeRef2;
                while (this.tree.getNodeHeight((NodeRef)serializable) < d4) {
                    nodeRef5 = serializable;
                    if ((serializable = this.tree.getParent((NodeRef)serializable)) != null) continue;
                }
                this.tree.beginTreeEdit();
                if (this.tree.isRoot(nodeRef5)) {
                    this.tree.removeChild(nodeRef2, nodeRef3);
                    this.tree.removeChild(nodeRef4, nodeRef2);
                    this.tree.addChild(nodeRef2, nodeRef5);
                    this.tree.addChild(nodeRef4, nodeRef3);
                    this.tree.setRoot(nodeRef2);
                    if (this.tree.hasNodeTraits()) {
                        this.tree.swapAllTraits(nodeRef5, nodeRef2);
                    }
                    if (this.tree.hasRates()) {
                        double d5 = this.tree.getNodeRate(nodeRef5);
                        this.tree.setNodeRate(nodeRef5, this.tree.getNodeRate(nodeRef2));
                        this.tree.setNodeRate(nodeRef2, d5);
                    }
                } else {
                    this.tree.removeChild(nodeRef2, nodeRef3);
                    this.tree.removeChild(nodeRef4, nodeRef2);
                    this.tree.removeChild((NodeRef)serializable, nodeRef5);
                    this.tree.addChild(nodeRef2, nodeRef5);
                    this.tree.addChild(nodeRef4, nodeRef3);
                    this.tree.addChild((NodeRef)serializable, nodeRef2);
                }
                this.tree.setNodeHeight(nodeRef2, d4);
                this.tree.endTreeEdit();
                int n = this.intersectingEdges(this.tree, nodeRef5, d3, null);
                d = -Math.log(n);
                if (abstractCase4 != abstractCase3) {
                    d += Math.log(0.5);
                }
                AbstractCase abstractCase6 = branchMapModel.get(nodeRef5.getNumber());
                if (serializable != null && branchMapModel.get(serializable.getNumber()) != branchMapModel.get(nodeRef5.getNumber())) {
                    abstractCase5 = MathUtils.nextInt(2) == 0 ? branchMapModel.get(serializable.getNumber()) : abstractCase6;
                    if (this.resampleInfectionTimes) {
                        abstractCase6.setInfectionBranchPosition(MathUtils.nextDouble());
                    }
                    d += Math.log(2.0);
                } else {
                    abstractCase5 = abstractCase6;
                    if (this.resampleInfectionTimes && serializable == null) {
                        abstractCase6.setInfectionBranchPosition(MathUtils.nextDouble());
                    }
                }
                branchMapModel.set(nodeRef2.getNumber(), abstractCase5, true);
            } else {
                this.tree.setNodeHeight(nodeRef2, d4);
                d = 0.0;
            }
        } else {
            if (this.tree.getNodeHeight(nodeRef) > d4) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.tree.getNodeHeight(nodeRef3) > d4) {
                AbstractCase abstractCase7;
                serializable = new ArrayList();
                int n = this.intersectingEdges(this.tree, nodeRef3, d4, (List<NodeRef>)((Object)serializable));
                if (serializable.size() == 0) {
                    return Double.NEGATIVE_INFINITY;
                }
                int n2 = MathUtils.nextInt(serializable.size());
                NodeRef nodeRef6 = (NodeRef)serializable.get(n2);
                NodeRef nodeRef7 = this.tree.getParent(nodeRef6);
                this.tree.beginTreeEdit();
                if (this.tree.isRoot(nodeRef2)) {
                    this.tree.removeChild(nodeRef2, nodeRef3);
                    this.tree.removeChild(nodeRef7, nodeRef6);
                    this.tree.addChild(nodeRef2, nodeRef6);
                    this.tree.addChild(nodeRef7, nodeRef2);
                    this.tree.setRoot(nodeRef3);
                    if (this.tree.hasNodeTraits()) {
                        this.tree.swapAllTraits(nodeRef2, nodeRef3);
                    }
                    if (this.tree.hasRates()) {
                        double d6 = this.tree.getNodeRate(nodeRef2);
                        this.tree.setNodeRate(nodeRef2, this.tree.getNodeRate(nodeRef3));
                        this.tree.setNodeRate(nodeRef3, d6);
                    }
                } else {
                    this.tree.removeChild(nodeRef2, nodeRef3);
                    this.tree.removeChild(nodeRef4, nodeRef2);
                    this.tree.removeChild(nodeRef7, nodeRef6);
                    this.tree.addChild(nodeRef2, nodeRef6);
                    this.tree.addChild(nodeRef4, nodeRef3);
                    this.tree.addChild(nodeRef7, nodeRef2);
                }
                this.tree.setNodeHeight(nodeRef2, d4);
                this.tree.endTreeEdit();
                d = Math.log(n);
                if (nodeRef4 != null && abstractCase4 != abstractCase3) {
                    d += Math.log(0.5);
                }
                AbstractCase abstractCase8 = branchMapModel.get(nodeRef6.getNumber());
                if (branchMapModel.get(nodeRef7.getNumber()) != branchMapModel.get(nodeRef6.getNumber())) {
                    abstractCase7 = MathUtils.nextInt(2) == 0 ? branchMapModel.get(nodeRef7.getNumber()) : abstractCase8;
                    if (this.resampleInfectionTimes) {
                        abstractCase8.setInfectionBranchPosition(MathUtils.nextDouble());
                    }
                    d += Math.log(2.0);
                } else {
                    abstractCase7 = abstractCase8;
                }
                branchMapModel.set(nodeRef2.getNumber(), abstractCase7, true);
            } else {
                this.tree.setNodeHeight(nodeRef2, d4);
                d = 0.0;
            }
        }
        if (this.swapInRandomRate && (serializable = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()))) != nodeRef) {
            double d7 = this.tree.getNodeRate(nodeRef);
            this.tree.setNodeRate(nodeRef, this.tree.getNodeRate((NodeRef)serializable));
            this.tree.setNodeRate((NodeRef)serializable, d7);
        }
        if (this.swapInRandomTrait && (serializable = this.tree.getNode(MathUtils.nextInt(this.tree.getNodeCount()))) != nodeRef) {
            this.tree.swapAllTraits(nodeRef, (NodeRef)serializable);
        }
        return d;
    }

    private double getDelta() {
        if (!this.gaussian) {
            return MathUtils.nextDouble() * this.size - this.size / 2.0;
        }
        return MathUtils.nextGaussian() * this.size;
    }

    private boolean eligibleForMove(NodeRef nodeRef, TreeModel treeModel, BranchMapModel branchMapModel) {
        return !treeModel.isRoot(nodeRef) && branchMapModel.get(treeModel.getParent(nodeRef).getNumber()) != branchMapModel.get(nodeRef.getNumber());
    }

    private int intersectingEdges(Tree tree, NodeRef nodeRef, double d, List<NodeRef> list) {
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        if (tree.getNodeHeight(nodeRef2) < d) {
            return 0;
        }
        if (tree.getNodeHeight(nodeRef) < d) {
            if (list != null) {
                list.add(nodeRef);
            }
            return 1;
        }
        int n = 0;
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            n += this.intersectingEdges(tree, tree.getChild(nodeRef, i), d, list);
        }
        return n;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.getSize());
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.setSize(Math.exp(d));
    }

    @Override
    public double getRawParameter() {
        return this.getSize();
    }

    @Override
    public double getTargetAcceptanceProbability() {
        return 0.234;
    }

    @Override
    public String getAdaptableParameterName() {
        return "size";
    }

    @Override
    public String getOperatorName() {
        return "transmissionSubtreeSlideB (" + this.tree.getId() + ")";
    }
}

