/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import dr.evomodel.treedatalikelihood.TreeTraversal;
import java.util.List;

public interface ProcessOnTreeDelegate {
    public TreeTraversal.TraversalType getOptimalTraversalType();

    public static final class Utils {
        static <T> String toString(List<T> list) {
            StringBuilder stringBuilder = new StringBuilder();
            for (T t : list) {
                stringBuilder.append(t.toString()).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    public static final class BranchNodeOperation {
        private final int nodeNumber;
        private final int parentNumber;
        private final double branchLength;

        BranchNodeOperation(int n, int n2, double d) {
            this.nodeNumber = n;
            this.parentNumber = n2;
            this.branchLength = d;
        }

        public int getNodeNumber() {
            return this.nodeNumber;
        }

        public int getParentNumber() {
            return this.parentNumber;
        }

        public double getBranchLength() {
            return this.branchLength;
        }

        public String toString() {
            return this.nodeNumber + "(" + this.parentNumber + "):" + this.branchLength;
        }
    }

    public static final class NodeOperation {
        private final int nodeNumber;
        private final int leftChild;
        private final int rightChild;

        NodeOperation(int n, int n2, int n3) {
            this.nodeNumber = n;
            this.leftChild = n2;
            this.rightChild = n3;
        }

        public int getNodeNumber() {
            return this.nodeNumber;
        }

        public int getLeftChild() {
            return this.leftChild;
        }

        public int getRightChild() {
            return this.rightChild;
        }

        public String toString() {
            return this.nodeNumber + "(" + this.leftChild + "," + this.rightChild + ")";
        }
    }

    public static final class BranchOperation {
        private final int branchNumber;
        private final double branchLength;

        BranchOperation(int n, double d) {
            this.branchNumber = n;
            this.branchLength = d;
        }

        public int getBranchNumber() {
            return this.branchNumber;
        }

        public double getBranchLength() {
            return this.branchLength;
        }

        public String toString() {
            return this.branchNumber + ":" + this.branchLength;
        }
    }
}

