/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.geo.math.SphericalPolarCoordinates;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class PolarCoordinatesParser
extends AbstractXMLObjectParser {
    private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("longitude"), AttributeRule.newDoubleRule("latitude")};

    @Override
    public String getParserName() {
        return "latLong";
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        double d = xMLObject.getDoubleAttribute("latitude");
        double d2 = xMLObject.getDoubleAttribute("longitude");
        return new SphericalPolarCoordinates(d, d2);
    }

    @Override
    public String getParserDescription() {
        return "A latitude/longitude pair representing a point on the surface of the Earth.";
    }

    @Override
    public Class getReturnType() {
        return SphericalPolarCoordinates.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

