/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.model.TransformedParameter;
import dr.inference.model.Variable;
import dr.util.Transform;

public class TransformedMultivariateParameter
extends TransformedParameter {
    private double[] transformedValues;
    private double[] unTransformedValues;
    private boolean valuesKnown = false;

    public TransformedMultivariateParameter(Parameter parameter, Transform.MultivariableTransform multivariableTransform) {
        this(parameter, multivariableTransform, false);
    }

    public TransformedMultivariateParameter(Parameter parameter, Transform.MultivariableTransform multivariableTransform, boolean bl) {
        super(parameter, multivariableTransform, bl);
        this.unTransformedValues = parameter.getParameterValues();
        this.transformedValues = this.transform(this.unTransformedValues);
    }

    @Override
    public double getParameterValue(int n) {
        this.update();
        return this.transformedValues[n];
    }

    @Override
    protected void storeValues() {
        super.storeValues();
    }

    @Override
    protected void restoreValues() {
        super.restoreValues();
        this.valuesKnown = false;
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.setParameterValueQuietly(n, d);
        this.parameter.fireParameterChangedEvent();
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.update();
        this.transformedValues[n] = d;
        this.updateParameterQuietlyFromTransformedValues();
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray) {
        if (dArray.length != this.transformedValues.length) {
            throw new IllegalArgumentException("supplied values must be of same dimension as transformed parameter");
        }
        for (int i = 0; i < this.transformedValues.length; ++i) {
            this.transformedValues[i] = dArray[i];
        }
        this.updateParameterQuietlyFromTransformedValues();
    }

    private void updateParameterQuietlyFromTransformedValues() {
        this.unTransformedValues = this.inverse(this.transformedValues);
        for (int i = 0; i < this.parameter.getDimension(); ++i) {
            this.parameter.setParameterValueQuietly(i, this.unTransformedValues[i]);
        }
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.setParameterValue(n, d);
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        this.transformedBounds = bounds;
    }

    private void update() {
        if (!this.valuesKnown) {
            this.unTransformedValues = this.parameter.getParameterValues();
            this.transformedValues = this.transform(this.unTransformedValues);
            this.valuesKnown = true;
        }
    }

    private boolean hasChanged() {
        for (int i = 0; i < this.unTransformedValues.length; ++i) {
            if (this.parameter.getParameterValue(i) == this.unTransformedValues[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.valuesKnown = false;
        if (!this.doNotPropagateChangeUp) {
            this.fireParameterChangedEvent(-1, Variable.ChangeType.ALL_VALUES_CHANGED);
        }
    }
}

