/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.MCMCOperator;

public abstract class SimpleOperator
implements MCMCOperator {
    private long sumEvaluationTime = 0L;
    private long sumCalculationCount = 0L;
    private double[] spanDeviation = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
    private int spanCount = 0;
    private double weight = 1.0;
    private long accepted = 0L;
    private long rejected = 0L;
    private double sumDeviation = 0.0;
    private double lastDeviation = 0.0;
    protected boolean operateAllowed = true;

    @Override
    public abstract String getOperatorName();

    @Override
    public final double getWeight() {
        return this.weight;
    }

    @Override
    public final void setWeight(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException("Weight must be a positive real. (called with " + d + ")");
        }
        this.weight = d;
    }

    @Override
    public void accept(double d) {
        this.lastDeviation = d;
        if (!this.operateAllowed) {
            this.operateAllowed = true;
            ++this.accepted;
            this.sumDeviation += d;
        } else {
            throw new RuntimeException("Accept/reject methods called twice without operate called in between!");
        }
    }

    @Override
    public void reject() {
        if (!this.operateAllowed) {
            this.operateAllowed = true;
            ++this.rejected;
        } else {
            throw new RuntimeException("Accept/reject methods called twice without operate called in between!");
        }
    }

    @Override
    public final void reset() {
        this.operateAllowed = true;
        this.accepted = 0L;
        this.rejected = 0L;
        this.lastDeviation = 0.0;
        this.sumDeviation = 0.0;
    }

    @Override
    public final long getCount() {
        return this.accepted + this.rejected;
    }

    @Override
    public final long getAcceptCount() {
        return this.accepted;
    }

    @Override
    public final void setAcceptCount(long l) {
        this.accepted = l;
    }

    @Override
    public final long getRejectCount() {
        return this.rejected;
    }

    @Override
    public final void setRejectCount(long l) {
        this.rejected = l;
    }

    @Override
    public final double getMeanDeviation() {
        return this.sumDeviation / (double)this.accepted;
    }

    public final double getDeviation() {
        return this.lastDeviation;
    }

    @Override
    public final double getSumDeviation() {
        return this.sumDeviation;
    }

    @Override
    public final void setSumDeviation(double d) {
        this.sumDeviation = d;
    }

    @Override
    public final double getAcceptanceProbability() {
        return (double)this.accepted / (double)(this.accepted + this.rejected);
    }

    @Override
    public final double getSmoothedAcceptanceProbability() {
        throw new UnsupportedOperationException("Not implemented for SimpleOperator");
    }

    public double getSpan(boolean bl) {
        double d = 0.0;
        if (this.spanDeviation[1] > this.spanDeviation[0] && this.spanCount > 20) {
            d = this.spanDeviation[1] - this.spanDeviation[0];
            if (bl) {
                this.spanDeviation[0] = Double.MAX_VALUE;
                this.spanDeviation[1] = -1.7976931348623157E308;
                this.spanCount = 0;
            }
        }
        return d;
    }

    @Override
    public double getMeanEvaluationTime() {
        return (double)this.sumEvaluationTime / (double)(this.accepted + this.rejected);
    }

    @Override
    public long getTotalEvaluationTime() {
        return this.sumEvaluationTime;
    }

    @Override
    public void addEvaluationTime(long l) {
        this.sumEvaluationTime += l;
    }

    @Override
    public double getMeanCalculationCount() {
        return (double)this.sumCalculationCount / (double)(this.accepted + this.rejected);
    }

    @Override
    public void addCalculationCount(long l) {
        this.sumCalculationCount += l;
    }

    @Override
    public long getTotalCalculationCount() {
        return this.sumCalculationCount;
    }
}

