/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ohdsi.circe.check.Warning;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCheck;
import org.ohdsi.circe.check.checkers.CriteriaCheckerFactory;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.warnings.ConceptSetWarning;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.ConceptSet;
import org.ohdsi.circe.cohortdefinition.CorelatedCriteria;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.CriteriaGroup;
import org.ohdsi.circe.cohortdefinition.CustomEraStrategy;

public class UnusedConceptsCheck
extends BaseCheck {
    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected WarningReporter getReporter(WarningSeverity severity, List<Warning> warnings) {
        return (template, conceptSet) -> warnings.add(new ConceptSetWarning(severity, template, (ConceptSet)conceptSet[0]));
    }

    @Override
    public void check(CohortExpression expression, WarningReporter reporter) {
        List<Criteria> additionalCriteria = this.getAdditionalCriteria(expression);
        Arrays.stream(expression.conceptSets).filter(conceptSet -> this.isNotUsed(expression, additionalCriteria, (ConceptSet)conceptSet)).forEach(conceptSet -> reporter.add("Concept Set \"%s\" is not used", conceptSet));
    }

    private List<Criteria> getAdditionalCriteria(CohortExpression expression) {
        if (Objects.isNull(expression.additionalCriteria)) {
            return Collections.emptyList();
        }
        ArrayList<Criteria> additionalCriteria = new ArrayList<Criteria>(this.toCriteriaList(expression.additionalCriteria.criteriaList));
        additionalCriteria.addAll(this.toCriteriaList(expression.additionalCriteria.groups));
        return additionalCriteria;
    }

    private boolean isNotUsed(CohortExpression expression, List<Criteria> additionalCriteria, ConceptSet conceptSet) {
        return !this.isUsed(expression, additionalCriteria, conceptSet);
    }

    private boolean isUsed(CohortExpression expression, List<Criteria> additionalCriteria, ConceptSet conceptSet) {
        if (this.isConceptSetUsed(conceptSet, Arrays.asList(expression.primaryCriteria.criteriaList))) {
            return true;
        }
        if (this.isConceptSetUsed(conceptSet, additionalCriteria)) {
            return true;
        }
        if (expression.inclusionRules.stream().anyMatch(rule -> this.isConceptSetUsed(conceptSet, rule.expression))) {
            return true;
        }
        if (expression.endStrategy instanceof CustomEraStrategy && Objects.equals(((CustomEraStrategy)expression.endStrategy).drugCodesetId, conceptSet.id)) {
            return true;
        }
        return this.isConceptSetUsed(conceptSet, Arrays.asList(expression.censoringCriteria));
    }

    private boolean isConceptSetUsed(ConceptSet conceptSet, List<Criteria> criteriaList) {
        CriteriaCheckerFactory factory = CriteriaCheckerFactory.getFactory(conceptSet);
        boolean mainCheck = criteriaList.stream().anyMatch(criteria -> factory.getCriteriaChecker((Criteria)criteria).apply((Criteria)criteria));
        return mainCheck || criteriaList.stream().anyMatch(criteria -> {
            if (criteria.CorrelatedCriteria != null) {
                return this.isConceptSetUsed(conceptSet, criteria.CorrelatedCriteria);
            }
            return false;
        });
    }

    private boolean isConceptSetUsed(ConceptSet conceptSet, CriteriaGroup group) {
        List<Criteria> criteriaList = this.toCriteriaList(group.criteriaList);
        return this.isConceptSetUsed(conceptSet, criteriaList) || Arrays.stream(group.groups).anyMatch(cg -> this.isConceptSetUsed(conceptSet, (CriteriaGroup)cg));
    }

    private List<Criteria> toCriteriaList(CorelatedCriteria[] criteriaList) {
        return Objects.nonNull(criteriaList) ? Arrays.stream(criteriaList).map(c -> c.criteria).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Criteria> toCriteriaList(CriteriaGroup[] groups) {
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        Arrays.stream(groups).map(c -> c.criteriaList).map(this::toCriteriaList).forEach(criteria::addAll);
        for (CriteriaGroup group : groups) {
            List<Criteria> criteriaFromChildGroups = this.toCriteriaList(group.groups);
            criteria.addAll(criteriaFromChildGroups);
        }
        return criteria;
    }
}

