/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.DigitalNet;
import umontreal.iro.lecuyer.hups.PointSetIterator;

public abstract class DigitalSequence
extends DigitalNet {
    public abstract void extendSequence(int var1);

    private int[][] copyDigitalShift(int[][] nArray) {
        if (nArray == null) {
            return null;
        }
        int[][] nArray2 = new int[nArray.length][nArray[0].length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length; ++j) {
                nArray2[i][j] = nArray[i][j];
            }
        }
        return nArray2;
    }

    private DigitalNet initNetVar(boolean bl) {
        DigitalNet digitalNet = new DigitalNet();
        digitalNet.dim = bl ? this.dim + 1 : this.dim;
        digitalNet.numPoints = this.numPoints;
        digitalNet.numCols = this.numCols;
        digitalNet.numRows = this.numRows;
        digitalNet.outDigits = this.outDigits;
        digitalNet.normFactor = this.normFactor;
        digitalNet.b = this.b;
        digitalNet.factor = new double[this.outDigits];
        for (int i = 0; i < this.outDigits; ++i) {
            digitalNet.factor[i] = this.factor[i];
        }
        digitalNet.genMat = new int[digitalNet.dim * this.numCols][this.numRows];
        digitalNet.shiftStream = this.shiftStream;
        digitalNet.capacityShift = this.capacityShift;
        digitalNet.dimShift = this.dimShift;
        digitalNet.digitalShift = this.copyDigitalShift(this.digitalShift);
        if (bl && this.shiftStream != null) {
            digitalNet.addRandomShift(this.dimShift, this.dimShift + 1, this.shiftStream);
        }
        return digitalNet;
    }

    public DigitalNet toNet() {
        DigitalNet digitalNet = this.initNetVar(false);
        int n = this.dim * this.numCols;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.numRows; ++j) {
                digitalNet.genMat[i][j] = this.genMat[i][j];
            }
        }
        return digitalNet;
    }

    public DigitalNet toNetShiftCj() {
        int n;
        int n2;
        DigitalNet digitalNet = this.initNetVar(true);
        for (int i = this.dim; i >= 1; --i) {
            int n3 = i * this.numCols;
            for (n2 = 0; n2 < this.numCols; ++n2) {
                for (n = 0; n < this.numRows; ++n) {
                    digitalNet.genMat[n3 + n2][n] = this.genMat[n3 - this.numCols + n2][n];
                }
            }
        }
        for (n2 = 0; n2 < this.numCols; ++n2) {
            for (n = 0; n < this.numRows; ++n) {
                digitalNet.genMat[n2][n] = 0;
            }
            digitalNet.genMat[n2][this.numCols - n2 - 1] = 1;
        }
        return digitalNet;
    }

    public PointSetIterator iteratorShift() {
        return new DigitalNetIteratorShiftGenerators();
    }

    public PointSetIterator iteratorShiftNoGray() {
        return new DigitalNetIteratorShiftNoGray();
    }

    protected class DigitalNetIteratorShiftNoGray
    extends DigitalNet.DigitalNetIterator {
        public DigitalNetIteratorShiftNoGray() {
            this.dimS = DigitalSequence.this.dim + 1;
            if (DigitalSequence.this.digitalShift != null && DigitalSequence.this.dimShift < this.dimS) {
                DigitalSequence.this.addRandomShift(DigitalSequence.this.dimShift, this.dimS);
            }
            this.init2();
        }

        public void init() {
        }

        public void init2() {
            this.resetCurPointIndex();
        }

        public void setCurPointIndex(int n) {
            int n2;
            int n3;
            int n4;
            if (n == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            this.idigits = DigitalSequence.this.intToDigitsGray(DigitalSequence.this.b, n, DigitalSequence.this.numCols, this.bdigit, this.gdigit);
            for (int i = 1; i <= DigitalSequence.this.dim; ++i) {
                for (n4 = 0; n4 < DigitalSequence.this.outDigits; ++n4) {
                    n3 = DigitalSequence.this.digitalShift == null ? 0 : DigitalSequence.this.digitalShift[i][n4];
                    if (n4 < DigitalSequence.this.numRows) {
                        for (n2 = 0; n2 < this.idigits; ++n2) {
                            n3 += DigitalSequence.this.genMat[(i - 1) * DigitalSequence.this.numCols + n2][n4] * this.bdigit[n2];
                            n3 %= DigitalSequence.this.b;
                        }
                    }
                    this.cachedCurPoint[i * DigitalSequence.this.outDigits + n4] = n3;
                }
            }
            for (n4 = 0; n4 < DigitalSequence.this.outDigits; ++n4) {
                n3 = DigitalSequence.this.digitalShift == null ? 0 : DigitalSequence.this.digitalShift[0][n4];
                if (n4 < DigitalSequence.this.numRows) {
                    for (n2 = 0; n2 < this.idigits; ++n2) {
                        if (n4 != DigitalSequence.this.numCols - n2 - 1) continue;
                        n3 += this.bdigit[n2];
                    }
                }
                this.cachedCurPoint[n4] = n3 % DigitalSequence.this.b;
            }
        }

        public int resetToNextPoint() {
            int n;
            int n2;
            ++this.curPointIndex;
            this.curCoordIndex = 0;
            if (this.curPointIndex >= DigitalSequence.this.numPoints) {
                return this.curPointIndex;
            }
            int n3 = 0;
            while (this.bdigit[n3] == DigitalSequence.this.b - 1) {
                this.bdigit[n3] = 0;
                ++n3;
            }
            int n4 = n3;
            this.bdigit[n4] = this.bdigit[n4] + 1;
            int n5 = DigitalSequence.this.numRows;
            if (DigitalSequence.this.outDigits < DigitalSequence.this.numRows) {
                n5 = DigitalSequence.this.outDigits;
            }
            for (int i = 1; i <= DigitalSequence.this.dim; ++i) {
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n <= n3; ++n) {
                        int n6 = i * DigitalSequence.this.outDigits + n2;
                        this.cachedCurPoint[n6] = this.cachedCurPoint[n6] + DigitalSequence.this.genMat[(i - 1) * DigitalSequence.this.numCols + n][n2];
                    }
                    int n7 = i * DigitalSequence.this.outDigits + n2;
                    this.cachedCurPoint[n7] = this.cachedCurPoint[n7] % DigitalSequence.this.b;
                }
            }
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n <= n3; ++n) {
                    if (n2 != DigitalSequence.this.numCols - n - 1) continue;
                    int n8 = n2;
                    this.cachedCurPoint[n8] = this.cachedCurPoint[n8] + 1;
                    int n9 = n2;
                    this.cachedCurPoint[n9] = this.cachedCurPoint[n9] % DigitalSequence.this.b;
                }
            }
            return this.curPointIndex;
        }
    }

    protected class DigitalNetIteratorShiftGenerators
    extends DigitalNet.DigitalNetIterator {
        public DigitalNetIteratorShiftGenerators() {
            this.dimS = DigitalSequence.this.dim + 1;
            if (DigitalSequence.this.digitalShift != null && DigitalSequence.this.dimShift < this.dimS) {
                DigitalSequence.this.addRandomShift(DigitalSequence.this.dimShift, this.dimS);
            }
            this.init2();
        }

        public void init() {
        }

        public void init2() {
            this.resetCurPointIndex();
        }

        public void setCurPointIndex(int n) {
            int n2;
            int n3;
            int n4;
            if (n == 0) {
                this.resetCurPointIndex();
                return;
            }
            this.curPointIndex = n;
            this.curCoordIndex = 0;
            this.idigits = DigitalSequence.this.intToDigitsGray(DigitalSequence.this.b, n, DigitalSequence.this.numCols, this.bdigit, this.gdigit);
            for (int i = 1; i <= DigitalSequence.this.dim; ++i) {
                for (n4 = 0; n4 < DigitalSequence.this.outDigits; ++n4) {
                    n3 = DigitalSequence.this.digitalShift == null ? 0 : DigitalSequence.this.digitalShift[i][n4];
                    if (n4 < DigitalSequence.this.numRows) {
                        for (n2 = 0; n2 < this.idigits; ++n2) {
                            n3 += DigitalSequence.this.genMat[(i - 1) * DigitalSequence.this.numCols + n2][n4] * this.gdigit[n2];
                        }
                    }
                    this.cachedCurPoint[i * DigitalSequence.this.outDigits + n4] = n3 % DigitalSequence.this.b;
                }
            }
            for (n4 = 0; n4 < DigitalSequence.this.outDigits; ++n4) {
                n3 = DigitalSequence.this.digitalShift == null ? 0 : DigitalSequence.this.digitalShift[0][n4];
                if (n4 < DigitalSequence.this.numRows) {
                    for (n2 = 0; n2 < this.idigits; ++n2) {
                        if (n4 != DigitalSequence.this.numCols - n2 - 1) continue;
                        n3 += this.gdigit[n2];
                    }
                }
                this.cachedCurPoint[n4] = n3 % DigitalSequence.this.b;
            }
        }

        public int resetToNextPoint() {
            int n;
            ++this.curPointIndex;
            this.curCoordIndex = 0;
            if (this.curPointIndex >= DigitalSequence.this.numPoints) {
                return this.curPointIndex;
            }
            int n2 = 0;
            while (this.gdigit[n2] == DigitalSequence.this.b - 1) {
                this.gdigit[n2] = 0;
                ++n2;
            }
            int n3 = n2;
            this.gdigit[n3] = this.gdigit[n3] + 1;
            int n4 = DigitalSequence.this.numRows;
            if (DigitalSequence.this.outDigits < DigitalSequence.this.numRows) {
                n4 = DigitalSequence.this.outDigits;
            }
            for (int i = 1; i <= DigitalSequence.this.dim; ++i) {
                for (n = 0; n < n4; ++n) {
                    int n5 = i * DigitalSequence.this.outDigits + n;
                    this.cachedCurPoint[n5] = this.cachedCurPoint[n5] + DigitalSequence.this.genMat[(i - 1) * DigitalSequence.this.numCols + n2][n];
                    int n6 = i * DigitalSequence.this.outDigits + n;
                    this.cachedCurPoint[n6] = this.cachedCurPoint[n6] % DigitalSequence.this.b;
                }
            }
            n = DigitalSequence.this.numCols - n2 - 1;
            if (n < n4) {
                int n7 = n;
                this.cachedCurPoint[n7] = this.cachedCurPoint[n7] + 1;
                int n8 = n;
                this.cachedCurPoint[n8] = this.cachedCurPoint[n8] % DigitalSequence.this.b;
            }
            return this.curPointIndex;
        }
    }
}

