/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class DriverMap {
    public static final String uri = "http://db.jena.hpl.hp.com/vocabulary#";
    public static final Property driverClass = DriverMap.property("driverClass");
    public static final Property driverName = DriverMap.property("driverName");
    private static final Map mapped = new HashMap();

    public static String get(String name) {
        return (String)mapped.get(name.toLowerCase());
    }

    public static void add(String name, String className) {
        mapped.put(name.toLowerCase(), className);
    }

    public static void addIfPresent(String fileName) {
        InputStream in = FileManager.get().open(fileName);
        if (in != null) {
            DriverMap.add(in);
        }
    }

    static void add(InputStream in) {
        Resource ANY = null;
        Model m = ModelFactory.createDefaultModel();
        m.read(in, "", "N3");
        StmtIterator A = m.listStatements(ANY, driverClass, ANY);
        while (A.hasNext()) {
            Statement st = A.nextStatement();
            Resource S = st.getSubject();
            String className = st.getString();
            StmtIterator B = m.listStatements(S, driverName, ANY);
            while (B.hasNext()) {
                DriverMap.add(B.nextStatement().getString(), className);
            }
        }
    }

    static Property property(String s) {
        return ResourceFactory.createProperty(uri + s);
    }

    static {
        DriverMap.add("mysql", "com.mysql.jdbc.Driver");
        DriverMap.add("postgres", "org.postgresql.Driver");
        DriverMap.add("postgresql", "org.postgresql.Driver");
        DriverMap.addIfPresent("etc/db-default-drivers.n3");
        DriverMap.addIfPresent("etc/db-extra-drivers.n3");
    }
}

