/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.TreeSet;
import weka.associations.ItemSet;
import weka.associations.PriorEstimation;
import weka.associations.RuleItem;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Statistics;
import weka.core.Utils;

public class RuleGeneration
implements Serializable {
    protected int[] m_items;
    protected int m_counter;
    protected int m_totalTransactions;
    protected boolean m_change = false;
    protected double m_expectation;
    protected static final int MAX_N = 300;
    protected int m_minRuleCount;
    protected double[] m_midPoints;
    protected Hashtable m_priors;
    protected TreeSet m_best;
    protected int m_count;
    protected Instances m_instances;

    public RuleGeneration(ItemSet itemSet) {
        this.m_totalTransactions = itemSet.m_totalTransactions;
        this.m_counter = itemSet.m_counter;
        this.m_items = itemSet.m_items;
    }

    public static final double binomialDistribution(double d, double d2, double d3) {
        if (d3 < 300.0) {
            return Math.pow(2.0, Utils.log2(Math.pow(d, d2)) + Utils.log2(Math.pow(1.0 - d, d3 - d2)) + PriorEstimation.logbinomialCoefficient((int)d3, (int)d2));
        }
        double d4 = d3 * d;
        double d5 = Math.sqrt(d3 * (1.0 - d) * d);
        return Statistics.normalProbability((d2 + 0.5 - d4) / (d5 * Math.sqrt(2.0)));
    }

    public static final double expectation(double d, int n, double[] dArray, Hashtable hashtable) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            Double d4 = (Double)hashtable.get(new Double(dArray[i]));
            if (d4 == null || d4 == 0.0) continue;
            double d5 = d4 * RuleGeneration.binomialDistribution(dArray[i], d, n);
            d3 += d5;
            d2 += d5 * dArray[i];
        }
        if (d3 <= 0.0 || Double.isNaN(d3)) {
            System.out.println("RuleItem denominator: " + d3);
        }
        if (d2 <= 0.0 || Double.isNaN(d2)) {
            System.out.println("RuleItem numerator: " + d2);
        }
        return d2 / d3;
    }

    public TreeSet generateRules(int n, double[] dArray, Hashtable hashtable, double d, Instances instances, TreeSet treeSet, int n2) {
        boolean bl = false;
        FastVector fastVector = new FastVector();
        FastVector fastVector2 = new FastVector();
        boolean bl2 = false;
        RuleItem ruleItem = null;
        this.m_change = false;
        this.m_midPoints = dArray;
        this.m_priors = hashtable;
        this.m_best = treeSet;
        this.m_expectation = d;
        this.m_count = n2;
        this.m_instances = instances;
        ItemSet itemSet = null;
        itemSet = new ItemSet(this.m_totalTransactions);
        itemSet.m_items = new int[this.m_items.length];
        System.arraycopy(this.m_items, 0, itemSet.m_items, 0, this.m_items.length);
        itemSet.m_counter = this.m_counter;
        do {
            this.m_minRuleCount = 1;
            while (RuleGeneration.expectation(this.m_minRuleCount, itemSet.m_counter, this.m_midPoints, this.m_priors) <= this.m_expectation) {
                ++this.m_minRuleCount;
                if (this.m_minRuleCount <= itemSet.m_counter) continue;
                return this.m_best;
            }
            bl = false;
            for (int i = 0; i < instances.numAttributes(); ++i) {
                int n3;
                if (i == 0) {
                    for (int j = 0; j < this.m_items.length; ++j) {
                        if (this.m_items[j] != -1) continue;
                        fastVector = RuleGeneration.singleConsequence(instances, j, fastVector);
                    }
                    if (itemSet == null || fastVector.size() == 0) {
                        return this.m_best;
                    }
                }
                FastVector fastVector3 = new FastVector();
                int n4 = 0;
                do {
                    n3 = 0;
                    while (n3 < fastVector.size()) {
                        RuleItem ruleItem2 = new RuleItem();
                        ruleItem = ruleItem2.generateRuleItem(itemSet, (ItemSet)fastVector.elementAt(n3), instances, this.m_count, this.m_minRuleCount, this.m_midPoints, this.m_priors);
                        if (ruleItem != null) {
                            fastVector3.addElement(ruleItem);
                            ++n3;
                            continue;
                        }
                        fastVector.removeElementAt(n3);
                    }
                    if (n4 == i) break;
                    fastVector2 = fastVector;
                    fastVector = ItemSet.mergeAllItemSets(fastVector2, n4, instances.numInstances());
                    Hashtable hashtable2 = ItemSet.getHashtable(fastVector2, fastVector2.size());
                    fastVector = ItemSet.pruneItemSets(fastVector, hashtable2);
                    ++n4;
                } while (fastVector.size() > 0);
                for (n3 = 0; n3 < fastVector3.size(); ++n3) {
                    ruleItem = (RuleItem)fastVector3.elementAt(n3);
                    ++this.m_count;
                    if (this.m_best.size() < n) {
                        this.m_change = true;
                        bl = this.removeRedundant(ruleItem);
                        continue;
                    }
                    if (!(ruleItem.accuracy() > this.m_expectation)) continue;
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    boolean bl3 = this.m_best.remove(this.m_best.first());
                    this.m_change = true;
                    bl = this.removeRedundant(ruleItem);
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    while (RuleGeneration.expectation(this.m_minRuleCount, ruleItem.premise().m_counter, this.m_midPoints, this.m_priors) < this.m_expectation) {
                        ++this.m_minRuleCount;
                        if (this.m_minRuleCount <= ruleItem.premise().m_counter) continue;
                    }
                }
            }
        } while (bl);
        return this.m_best;
    }

    public static boolean aSubsumesB(RuleItem ruleItem, RuleItem ruleItem2) {
        if (ruleItem.m_accuracy < ruleItem2.m_accuracy) {
            return false;
        }
        for (int i = 0; i < ruleItem.premise().m_items.length; ++i) {
            if (ruleItem.premise().m_items[i] != ruleItem2.premise().m_items[i] && (ruleItem.premise().m_items[i] != -1 && ruleItem2.premise().m_items[i] != -1 || ruleItem2.premise().m_items[i] == -1)) {
                return false;
            }
            if (ruleItem.consequence().m_items[i] == ruleItem2.consequence().m_items[i] || (ruleItem.consequence().m_items[i] == -1 || ruleItem2.consequence().m_items[i] == -1) && ruleItem.consequence().m_items[i] != -1) continue;
            return false;
        }
        return true;
    }

    public static FastVector singleConsequence(Instances instances, int n, FastVector fastVector) {
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i != n) continue;
            int n2 = 0;
            while (n2 < instances.attribute(i).numValues()) {
                ItemSet itemSet = new ItemSet(instances.numInstances());
                itemSet.m_items = new int[instances.numAttributes()];
                for (int j = 0; j < instances.numAttributes(); ++j) {
                    itemSet.m_items[j] = -1;
                }
                itemSet.m_items[i] = n2++;
                fastVector.addElement(itemSet);
            }
        }
        return fastVector;
    }

    public boolean removeRedundant(RuleItem ruleItem) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        Object[] objectArray = this.m_best.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            RuleItem ruleItem2 = (RuleItem)objectArray[i];
            bl2 = RuleGeneration.aSubsumesB(ruleItem2, ruleItem);
            bl3 = RuleGeneration.aSubsumesB(ruleItem, ruleItem2);
            if (bl2) {
                n = 1;
                break;
            }
            if (!bl3) continue;
            boolean bl4 = this.m_best.remove(ruleItem2);
            n = 2;
            bl = true;
        }
        if (n == 0 || n == 2) {
            this.m_best.add(ruleItem);
        }
        return bl;
    }

    public int count() {
        return this.m_count;
    }

    public boolean change() {
        return this.m_change;
    }
}

