/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.Utils;
import weka.experiment.ResultMatrix;

public class ResultMatrixPlainText
extends ResultMatrix {
    public ResultMatrixPlainText() {
        this(1, 1);
    }

    public ResultMatrixPlainText(int n, int n2) {
        super(n, n2);
    }

    public ResultMatrixPlainText(ResultMatrix resultMatrix) {
        super(resultMatrix);
    }

    public String getDisplayName() {
        return "Plain Text";
    }

    public void clear() {
        super.clear();
        this.setRowNameWidth(25);
        this.setCountWidth(5);
    }

    public String toStringHeader() {
        int n;
        String string = "";
        String[][] stringArray = new String[this.m_HeaderKeys.size()][2];
        for (n = 0; n < this.m_HeaderKeys.size(); ++n) {
            stringArray[n][0] = this.m_HeaderKeys.get(n).toString() + ":";
            stringArray[n][1] = this.m_HeaderValues.get(n).toString();
        }
        int n2 = this.getColSize(stringArray, 0);
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n][0] = this.padString(stringArray[n][0], n2);
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = string + stringArray[n][0] + " " + stringArray[n][1] + "\n";
        }
        return string;
    }

    public String toStringMatrix() {
        String string;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        String[][] stringArray = this.toArray();
        int[] nArray = new int[this.getColCount()];
        int[] nArray2 = new int[this.getColCount() - 1];
        int n3 = 0;
        for (n2 = 1; n2 < stringArray[0].length; ++n2) {
            int n4 = this.getColSize(stringArray, n2, true, true);
            for (n = 1; n < stringArray.length - 1; ++n) {
                stringArray[n][n2] = this.padString(stringArray[n][n2], n4, true);
            }
        }
        int n5 = 1;
        if (this.getShowStdDev()) {
            ++n5;
        }
        int n6 = n5 + 1;
        if (this.getShowStdDev()) {
            ++n6;
        }
        int n7 = 0;
        int n8 = 0;
        for (n = 1; n < stringArray.length - 1; ++n) {
            if (this.isAverage(n)) {
                stringBuffer3.append(this.padString("", n3).replaceAll(".", "-") + "\n");
            }
            string = "";
            for (n2 = 0; n2 < stringArray[0].length; ++n2) {
                if (n == 1) {
                    if (this.isMean(n2)) {
                        nArray[n7] = string.length();
                        ++n7;
                    }
                    if (this.isSignificance(n2)) {
                        nArray2[n8] = string.length();
                        ++n8;
                    }
                }
                if (n2 == 0) {
                    string = string + this.padString(stringArray[n][n2], this.getRowNameWidth());
                    string = !this.isAverage(n) ? string + this.padString("(" + Utils.doubleToString(this.getCount(this.getDisplayRow(n - 1)), 0) + ")", this.getCountWidth(), true) : string + this.padString("", this.getCountWidth(), true);
                } else {
                    if (this.isMean(n2)) {
                        string = string + "  ";
                    }
                    string = this.getShowStdDev() ? (this.isMean(n2 - 1) ? (!stringArray[n][n2].trim().equals("") ? string + "(" + stringArray[n][n2] + ")" : string + " " + stringArray[n][n2] + " ") : string + " " + stringArray[n][n2]) : string + " " + stringArray[n][n2];
                }
                if (n2 != n5) continue;
                string = string + " |";
            }
            if (n == 1) {
                n3 = string.length();
            }
            stringBuffer3.append(string + "\n");
        }
        string = this.padString(stringArray[0][0], nArray[0]);
        n = -1;
        for (n2 = 1; n2 < stringArray[0].length; ++n2) {
            if (!this.isMean(n2)) continue;
            if (++n == 0) {
                string = this.padString(string, nArray[n] - this.getCountWidth());
            } else if (n == 1) {
                string = this.padString(string, nArray[n] - " |".length());
            } else if (n > 1) {
                string = this.padString(string, nArray[n]);
            }
            if (n == 1) {
                string = string + " |";
            }
            string = string + " " + stringArray[0][n2];
        }
        string = this.padString(string, n3);
        stringBuffer2.append(string + "\n");
        stringBuffer2.append(string.replaceAll(".", "-") + "\n");
        stringBuffer3.append(string.replaceAll(".", "-") + "\n");
        if (this.getColCount() > 1) {
            string = this.padString(stringArray[stringArray.length - 1][0], nArray[1] - 2, true) + " |";
            n = 0;
            for (n2 = 1; n2 < stringArray[stringArray.length - 1].length; ++n2) {
                if (!this.isSignificance(n2)) continue;
                string = this.padString(string, nArray2[n] + 1 - stringArray[stringArray.length - 1][n2].length());
                string = string + " " + stringArray[stringArray.length - 1][n2];
                ++n;
            }
            string = this.padString(string, n3);
        } else {
            string = this.padString(stringArray[stringArray.length - 1][0], string.length() - 2) + " |";
        }
        stringBuffer4.append(string + "\n");
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append(stringBuffer4.toString());
        return stringBuffer.toString();
    }

    public String toStringKey() {
        String string = "Key:\n";
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            string = string + this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES + " " + this.removeFilterName(this.m_ColNames[i]) + "\n";
        }
        return string;
    }

    public String toStringSummary() {
        int n;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String string = "";
        String string2 = "";
        int n2 = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        for (n = 0; n < this.getColCount(); ++n) {
            if (this.getColHidden(n)) continue;
            string2 = string2 + " " + Utils.padLeft("" + this.getSummaryTitle(n), n2 * 2 + 3);
        }
        string = string + string2 + "  (No. of datasets where [col] >> [row])\n";
        for (n = 0; n < this.getColCount(); ++n) {
            if (this.getColHidden(n)) continue;
            for (int i = 0; i < this.getColCount(); ++i) {
                if (this.getColHidden(i)) continue;
                string = string + " ";
                string = i == n ? string + Utils.padLeft("-", n2 * 2 + 3) : string + Utils.padLeft("" + this.m_NonSigWins[n][i] + " (" + this.m_Wins[n][i] + ")", n2 * 2 + 3);
            }
            string = string + " | " + this.getSummaryTitle(n) + " = " + this.getColName(n) + '\n';
        }
        return string;
    }

    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int n = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int n2 = Math.max(2 + (int)(Math.log(n) / Math.log(10.0)), ">-<".length());
        String string = Utils.padLeft(">-<", n2) + ' ' + Utils.padLeft(">", n2) + ' ' + Utils.padLeft("<", n2) + " Resultset\n";
        int[] nArray = Utils.sort(this.m_RankingDiff);
        for (int i = this.getColCount() - 1; i >= 0; --i) {
            int n3 = nArray[i];
            if (this.getColHidden(n3)) continue;
            string = string + Utils.padLeft("" + this.m_RankingDiff[n3], n2) + ' ' + Utils.padLeft("" + this.m_RankingWins[n3], n2) + ' ' + Utils.padLeft("" + this.m_RankingLosses[n3], n2) + ' ' + this.removeFilterName(this.m_ColNames[n3]) + '\n';
        }
        return string;
    }

    public static void main(String[] stringArray) {
        ResultMatrixPlainText resultMatrixPlainText = new ResultMatrixPlainText(3, 3);
        resultMatrixPlainText.addHeader("header1", "value1");
        resultMatrixPlainText.addHeader("header2", "value2");
        resultMatrixPlainText.addHeader("header2", "value3");
        for (int i = 0; i < resultMatrixPlainText.getRowCount(); ++i) {
            for (int j = 0; j < resultMatrixPlainText.getColCount(); ++j) {
                resultMatrixPlainText.setMean(j, i, (i + 1) * j);
                resultMatrixPlainText.setStdDev(j, i, (double)(i + 1) * (double)j / 100.0);
                if (i != j) continue;
                if (i % 2 == 1) {
                    resultMatrixPlainText.setSignificance(j, i, 1);
                    continue;
                }
                resultMatrixPlainText.setSignificance(j, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)resultMatrixPlainText).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)resultMatrixPlainText).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)resultMatrixPlainText).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)resultMatrixPlainText).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        resultMatrixPlainText.setShowStdDev(true);
        System.out.println(((ResultMatrix)resultMatrixPlainText).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        resultMatrixPlainText.setPrintColNames(false);
        System.out.println(((ResultMatrix)resultMatrixPlainText).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        resultMatrixPlainText.setColHidden(1, true);
        System.out.println(((ResultMatrix)resultMatrixPlainText).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        resultMatrixPlainText.setRowHidden(2, true);
        resultMatrixPlainText.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixPlainText).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        resultMatrixPlainText.setMeanPrec(3);
        resultMatrixPlainText.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixPlainText).toStringMatrix());
    }
}

