/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import weka.core.Capabilities;
import weka.core.Memory;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.gui.LogPanel;
import weka.gui.LookAndFeel;
import weka.gui.WekaTaskMonitor;
import weka.gui.explorer.AssociationsPanel;
import weka.gui.explorer.AttributeSelectionPanel;
import weka.gui.explorer.ClassifierPanel;
import weka.gui.explorer.ClustererPanel;
import weka.gui.explorer.PreprocessPanel;
import weka.gui.visualize.MatrixPanel;

public class Explorer
extends JPanel {
    protected PreprocessPanel m_PreprocessPanel = new PreprocessPanel();
    protected ClassifierPanel m_ClassifierPanel = new ClassifierPanel();
    protected ClustererPanel m_ClustererPanel = new ClustererPanel();
    protected AssociationsPanel m_AssociationPanel = new AssociationsPanel();
    protected AttributeSelectionPanel m_AttributeSelectionPanel = new AttributeSelectionPanel();
    protected MatrixPanel m_VisualizePanel = new MatrixPanel();
    protected JTabbedPane m_TabbedPane = new JTabbedPane();
    protected LogPanel m_LogPanel = new LogPanel(new WekaTaskMonitor());
    protected HashSet<CapabilitiesFilterChangeListener> m_CapabilitiesFilterChangeListeners = new HashSet();
    private static Explorer m_explorer;
    private static Memory m_Memory;

    public Explorer() {
        String string = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        this.m_LogPanel.logMessage("Weka Explorer");
        this.m_LogPanel.logMessage("(c) 1999-2005 The University of Waikato, Hamilton, New Zealand");
        this.m_LogPanel.logMessage("web: http://www.cs.waikato.ac.nz/~ml/weka");
        this.m_LogPanel.logMessage("Started on " + string);
        this.m_LogPanel.statusMessage("Welcome to the Weka Explorer");
        this.m_PreprocessPanel.setLog(this.m_LogPanel);
        this.m_ClassifierPanel.setLog(this.m_LogPanel);
        this.m_AssociationPanel.setLog(this.m_LogPanel);
        this.m_ClustererPanel.setLog(this.m_LogPanel);
        this.m_AttributeSelectionPanel.setLog(this.m_LogPanel);
        this.m_TabbedPane.addTab("Preprocess", null, this.m_PreprocessPanel, "Open/Edit/Save instances");
        this.m_TabbedPane.addTab("Classify", null, this.m_ClassifierPanel, "Classify instances");
        this.m_TabbedPane.addTab("Cluster", null, this.m_ClustererPanel, "Identify instance clusters");
        this.m_TabbedPane.addTab("Associate", null, this.m_AssociationPanel, "Discover association rules");
        this.m_TabbedPane.addTab("Select attributes", null, this.m_AttributeSelectionPanel, "Determine relevance of attributes");
        this.m_TabbedPane.addTab("Visualize", null, this.m_VisualizePanel, "Explore the data");
        this.m_TabbedPane.setSelectedIndex(0);
        this.m_TabbedPane.setEnabledAt(1, false);
        this.m_TabbedPane.setEnabledAt(2, false);
        this.m_TabbedPane.setEnabledAt(3, false);
        this.m_TabbedPane.setEnabledAt(4, false);
        this.m_TabbedPane.setEnabledAt(5, false);
        this.m_PreprocessPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Explorer.this.m_ClassifierPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_AssociationPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_ClustererPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_AttributeSelectionPanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_VisualizePanel.setInstances(Explorer.this.m_PreprocessPanel.getInstances());
                Explorer.this.m_TabbedPane.setEnabledAt(1, true);
                Explorer.this.m_TabbedPane.setEnabledAt(2, true);
                Explorer.this.m_TabbedPane.setEnabledAt(3, true);
                Explorer.this.m_TabbedPane.setEnabledAt(4, true);
                Explorer.this.m_TabbedPane.setEnabledAt(5, true);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_TabbedPane, "Center");
        this.add((Component)this.m_LogPanel, "South");
        this.m_PreprocessPanel.setExplorer(this);
        this.addCapabilitiesFilterListener(this.m_PreprocessPanel);
        this.addCapabilitiesFilterListener(this.m_ClassifierPanel);
        this.addCapabilitiesFilterListener(this.m_ClustererPanel);
        this.addCapabilitiesFilterListener(this.m_AssociationPanel);
        this.addCapabilitiesFilterListener(this.m_AttributeSelectionPanel);
    }

    public void addCapabilitiesFilterListener(CapabilitiesFilterChangeListener capabilitiesFilterChangeListener) {
        this.m_CapabilitiesFilterChangeListeners.add(capabilitiesFilterChangeListener);
    }

    public boolean removeCapabilitiesFilterListener(CapabilitiesFilterChangeListener capabilitiesFilterChangeListener) {
        return this.m_CapabilitiesFilterChangeListeners.remove(capabilitiesFilterChangeListener);
    }

    public void notifyCapabilitiesFilterListener(Capabilities capabilities) {
        for (CapabilitiesFilterChangeListener capabilitiesFilterChangeListener : this.m_CapabilitiesFilterChangeListeners) {
            if (capabilitiesFilterChangeListener == this) continue;
            capabilitiesFilterChangeListener.capabilitiesFilterChanged(new CapabilitiesFilterChangeEvent(this, capabilities));
        }
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        try {
            Object object;
            m_explorer = new Explorer();
            final JFrame jFrame = new JFrame("Weka Explorer");
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)m_explorer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
            Image image = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_icon.gif"));
            jFrame.setIconImage(image);
            if (stringArray.length == 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                object = ConverterUtils.getLoaderForFile(stringArray[0]);
                ((AbstractFileLoader)object).setFile(new File(stringArray[0]));
                Explorer.m_explorer.m_PreprocessPanel.setInstancesFromFile((AbstractFileLoader)object);
            }
            object = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                3.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                jFrame.dispose();
                                m_explorer = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            ((Thread)object).setPriority(10);
            ((Thread)object).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }

    public static class CapabilitiesFilterChangeEvent
    extends ChangeEvent {
        private static final long serialVersionUID = 1194260517270385559L;
        protected Capabilities m_Filter;

        public CapabilitiesFilterChangeEvent(Object object, Capabilities capabilities) {
            super(object);
            this.m_Filter = capabilities;
        }

        public Capabilities getFilter() {
            return this.m_Filter;
        }
    }

    public static interface CapabilitiesFilterChangeListener
    extends EventListener {
        public void capabilitiesFilterChanged(CapabilitiesFilterChangeEvent var1);
    }
}

