/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.falco;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.sourceforge.jclec.AlgorithmEvent;
import net.sourceforge.jclec.IAlgorithmListener;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.problem.classification.Classifier;
import net.sourceforge.jclec.problem.classification.IClassificationRule;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.problem.classification.blocks.AttributeValue;
import net.sourceforge.jclec.problem.classification.falco.FalcoAlgorithm;
import net.sourceforge.jclec.syntaxtree.TerminalNode;
import net.sourceforge.jclec.util.dataset.CategoricalAttribute;
import net.sourceforge.jclec.util.dataset.FileDataset;
import net.sourceforge.jclec.util.dataset.IAttribute;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class KeelFalcoPopulationReport
implements IAlgorithmListener,
IConfigure {
    private static final long serialVersionUID = -8548482239030974796L;
    protected String reportDirName;
    protected String globalReportName;
    private File reportDirectory;
    private String reportTrainName;
    private String reportRulesName;
    private String reportTestName;

    public final String getReportDirName() {
        return this.reportDirName;
    }

    public final void setReportDirName(String reportDirName) {
        this.reportDirName = reportDirName;
    }

    public final String getGlobalReportName() {
        return this.globalReportName;
    }

    public final void setGlobalReportName(String name) {
        this.globalReportName = name;
    }

    @Override
    public void algorithmStarted(AlgorithmEvent event) {
        this.reportDirectory = new File(this.reportDirName);
    }

    @Override
    public void algorithmFinished(AlgorithmEvent event) {
        this.doClassificationReport((FalcoAlgorithm)event.getAlgorithm());
        this.doDataReport((FalcoAlgorithm)event.getAlgorithm());
        System.out.println("Algorithm finished");
    }

    @Override
    public void iterationCompleted(AlgorithmEvent event) {
    }

    @Override
    public void algorithmTerminated(AlgorithmEvent event) {
    }

    @Override
    public void configure(Configuration settings) {
        this.reportTrainName = settings.getString("train-report-file");
        this.reportTestName = settings.getString("test-report-file");
        this.reportRulesName = settings.getString("rules-report-file");
        String reportDirName = settings.getString("report-dir-name", "report");
        this.setReportDirName(reportDirName);
        String globalReportName = settings.getString("global-report-name", "global-report");
        this.setGlobalReportName(globalReportName);
    }

    public boolean equals(Object other) {
        if (other instanceof KeelFalcoPopulationReport) {
            KeelFalcoPopulationReport cother = (KeelFalcoPopulationReport)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.reportDirName, cother.reportDirName);
            return eb.isEquals();
        }
        return false;
    }

    protected void doClassificationReport(FalcoAlgorithm algorithm) {
        File rulesReportFile = new File(this.reportDirectory, this.reportRulesName);
        FileWriter rulesFile = null;
        Classifier classifier = (Classifier)algorithm.getClassifier();
        try {
            rulesFile = new FileWriter(rulesReportFile);
            IMetadata metadata = algorithm.getTrainMetadata();
            double[] predictedTrain = classifier.classify(algorithm.getTrainSet());
            double[] predictedTest = classifier.classify(algorithm.getTestSet());
            List<IClassificationRule> classificationRules = classifier.getClassificationRules();
            double[] trainResult = this.checkingResult(algorithm.getTrainSet(), predictedTrain);
            double[] testResult = this.checkingResult(algorithm.getTestSet(), predictedTest);
            rulesFile.write("Reglas:\n");
            int i = 0;
            while (i < classificationRules.size()) {
                rulesFile.write(String.valueOf(this.toString((SyntaxTreeClassificationRule)classificationRules.get(i), metadata)) + "\n");
                ++i;
            }
            rulesFile.write("Generica ==> " + metadata.getAttribute(metadata.getClassIndex()).show(classifier.getDefaultClass()) + "\n");
            rulesFile.write("Accuracy Train " + trainResult[0] + "\n");
            rulesFile.write("Accuracy Test " + testResult[0]);
            rulesFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double[] checkingResult(IDataset dataset, double[] predicted) {
        IMetadata metadata = dataset.getMetadata();
        int classIndex = metadata.getClassIndex();
        int numClasses = ((CategoricalAttribute)metadata.getAttribute(classIndex)).getCategories().size();
        double[] result = new double[3 + numClasses * 2];
        double success = 0.0;
        double fail = 0.0;
        double unclassified = 0.0;
        int i = 0;
        while (i < numClasses * 2) {
            result[3 + i] = 0.0;
            ++i;
        }
        i = 0;
        IDataset.IInstance[] iInstanceArray = dataset.getInstances();
        int n = iInstanceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset.IInstance instance = iInstanceArray[n2];
            double value = instance.getValue(classIndex);
            int n3 = 3 + numClasses + (int)Math.round(value);
            result[n3] = result[n3] + 1.0;
            if (predicted[i] == -1.0) {
                unclassified += 1.0;
            } else if (value != predicted[i]) {
                fail += 1.0;
            } else {
                success += 1.0;
                int n4 = 3 + (int)Math.round(value);
                result[n4] = result[n4] + 1.0;
            }
            ++i;
            ++n2;
        }
        result[0] = success / (double)dataset.getInstances().length;
        result[1] = fail / (double)dataset.getInstances().length;
        result[2] = unclassified / (double)dataset.getInstances().length;
        return result;
    }

    protected void doDataReport(FalcoAlgorithm algorithm) {
        FileWriter testFile = null;
        FileWriter trainFile = null;
        Classifier classifier = (Classifier)algorithm.getClassifier();
        File testReportFile = new File(this.reportDirectory, this.reportTestName);
        File trainReportFile = new File(this.reportDirectory, this.reportTrainName);
        try {
            testReportFile.createNewFile();
            testFile = new FileWriter(testReportFile);
            trainReportFile.createNewFile();
            trainFile = new FileWriter(trainReportFile);
            double[] predictedTrain = classifier.classify(algorithm.getTrainSet());
            double[] predictedTest = classifier.classify(algorithm.getTestSet());
            this.printResult(algorithm.getTrainMetadata(), algorithm.getTrainSet(), trainFile, predictedTrain);
            this.printResult(algorithm.getTestMetadata(), algorithm.getTestSet(), testFile, predictedTest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printResult(IMetadata metadata, IDataset dataset, FileWriter file, double[] predictedValues) {
        int numInstances = 0;
        File datasetfile = new File(((FileDataset)dataset).getFileName());
        try {
            BufferedReader bf = new BufferedReader(new FileReader(datasetfile));
            String str = "";
            while ((str = bf.readLine()).compareTo("@data") != 0) {
                file.write(String.valueOf(str) + "\n");
            }
            file.write(str);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            IDataset.IInstance[] iInstanceArray = dataset.getInstances();
            int n = iInstanceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDataset.IInstance instance = iInstanceArray[n2];
                double value = instance.getValue(metadata.getClassIndex());
                IAttribute attribute = metadata.getAttribute(metadata.getClassIndex());
                file.write("\n" + attribute.show(value));
                file.write(" " + attribute.show(predictedValues[numInstances]));
                ++numInstances;
                ++n2;
            }
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString(SyntaxTreeClassificationRule rule, IMetadata metadata) {
        StringBuffer sb = new StringBuffer("IF (");
        int j = 0;
        while (j < rule.getAntecedent().size()) {
            if (rule.getAntecedent().getNode(j).arity() == 0) {
                if (((TerminalNode)rule.getAntecedent().getNode(j)).getCode() instanceof AttributeValue) {
                    sb.append(rule.getAntecedent().getNode(j) + " ");
                } else {
                    sb.append(((TerminalNode)rule.getAntecedent().getNode(j)).getCode() + " ");
                }
            }
            ++j;
        }
        sb.append(") THEN (" + metadata.getAttribute(metadata.getClassIndex()).getName() + " = " + metadata.getAttribute(metadata.getClassIndex()).show(rule.getConsequent()) + ")");
        return sb.toString();
    }
}

