/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.BaseD;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.Difuso;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.myDataset;

class BaseR {
    public Difuso[][] BaseReglas;
    public int n_reglas;
    public int n_genes;
    public int n_var_estado;
    public double[] GradoEmp;
    public Difuso[] Consecuentes;
    public myDataset tabla;
    public BaseD base_datos;
    int pos_gen;

    public BaseR(int n_genes, BaseD base, myDataset t) {
        this.tabla = t;
        this.base_datos = base;
        this.n_reglas = 0;
        this.n_genes = n_genes;
        this.BaseReglas = new Difuso[n_genes][this.tabla.getnVars()];
        this.Consecuentes = new Difuso[n_genes];
        for (int i = 0; i < n_genes; ++i) {
            this.BaseReglas[i] = new Difuso[this.tabla.getnVars()];
            this.Consecuentes[i] = new Difuso();
            for (int j = 0; j < this.tabla.getnVars(); ++j) {
                this.BaseReglas[i][j] = new Difuso();
            }
        }
        this.GradoEmp = new double[n_genes];
        this.n_var_estado = this.tabla.getnInputs();
    }

    public static double Fuzzifica(double X, Difuso D) {
        if (X < D.x0 || X > D.x3) {
            return 0.0;
        }
        if (X < D.x1) {
            return (X - D.x0) * (D.y / (D.x1 - D.x0));
        }
        if (X > D.x2) {
            return (D.x3 - X) * (D.y / (D.x3 - D.x2));
        }
        return D.y;
    }

    public void Min(double[] entradas) {
        for (int b = 0; b < this.n_reglas; ++b) {
            double minimo = BaseR.Fuzzifica(entradas[0], this.BaseReglas[b][0]);
            for (int b2 = 1; b2 < this.tabla.getnInputs(); ++b2) {
                double y = BaseR.Fuzzifica(entradas[b2], this.BaseReglas[b][b2]);
                if (!(y < minimo)) continue;
                minimo = y;
            }
            this.GradoEmp[b] = minimo;
        }
    }

    public void T_Min() {
        for (int b = 0; b < this.n_reglas; ++b) {
            if (this.GradoEmp[b] != 0.0) {
                if (this.GradoEmp[b] == 1.0) {
                    this.Consecuentes[b].x0 = this.BaseReglas[b][this.tabla.getnVars() - 1].x0;
                    this.Consecuentes[b].x1 = this.BaseReglas[b][this.tabla.getnVars() - 1].x1;
                    this.Consecuentes[b].x2 = this.BaseReglas[b][this.tabla.getnVars() - 1].x2;
                    this.Consecuentes[b].x3 = this.BaseReglas[b][this.tabla.getnVars() - 1].x3;
                } else {
                    this.Consecuentes[b].x0 = this.BaseReglas[b][this.tabla.getnVars() - 1].x0;
                    this.Consecuentes[b].x1 = this.BaseReglas[b][this.tabla.getnVars() - 1].x0 + (this.BaseReglas[b][this.tabla.getnVars() - 1].x1 - this.BaseReglas[b][this.tabla.getnVars() - 1].x0) * this.GradoEmp[b];
                    this.Consecuentes[b].x2 = this.BaseReglas[b][this.tabla.getnVars() - 1].x3 + (this.BaseReglas[b][this.tabla.getnVars() - 1].x2 - this.BaseReglas[b][this.tabla.getnVars() - 1].x3) * this.GradoEmp[b];
                    this.Consecuentes[b].x3 = this.BaseReglas[b][this.tabla.getnVars() - 1].x3;
                }
            }
            this.Consecuentes[b].y = this.GradoEmp[b];
        }
    }

    public double AreaTrapecioX(double x0, double x1, double x2, double x3, double y) {
        double izq = x1 != x0 ? (2.0 * x1 * x1 * x1 - 3.0 * x0 * x1 * x1 + x0 * x0 * x0) / (6.0 * (x1 - x0)) : 0.0;
        double centro = (x2 * x2 - x1 * x1) / 2.0;
        double der = x3 != x2 ? (2.0 * x2 * x2 * x2 - 3.0 * x3 * x2 * x2 + x3 * x3 * x3) / (6.0 * (x3 - x2)) : 0.0;
        return y * (izq + centro + der);
    }

    public double AreaTrapecio(double x0, double x1, double x2, double x3, double y) {
        double izq = x1 != x0 ? (x1 * x1 - 2.0 * x0 * x1 + x0 * x0) / (2.0 * (x1 - x0)) : 0.0;
        double centro = x2 - x1;
        double der = x3 != x2 ? (x3 * x3 - 2.0 * x3 * x2 + x2 * x2) / (2.0 * (x3 - x2)) : 0.0;
        return y * (izq + centro + der);
    }

    public double WECOA() {
        double num = 0.0;
        double den = 0.0;
        for (int i = 0; i < this.n_reglas; ++i) {
            if (this.Consecuentes[i].y == 0.0) continue;
            num += this.GradoEmp[i] * (this.AreaTrapecioX(this.Consecuentes[i].x0, this.Consecuentes[i].x1, this.Consecuentes[i].x2, this.Consecuentes[i].x3, this.Consecuentes[i].y) / this.AreaTrapecio(this.Consecuentes[i].x0, this.Consecuentes[i].x1, this.Consecuentes[i].x2, this.Consecuentes[i].x3, this.Consecuentes[i].y));
            den += this.GradoEmp[i];
        }
        if (den != 0.0) {
            return num / den;
        }
        return 0.0;
    }

    public double FLC(double[] Entrada, int n_reglas) {
        this.n_reglas = n_reglas;
        this.Min(Entrada);
        this.T_Min();
        return this.WECOA();
    }

    public String BRtoString() {
        String cadena = "";
        cadena = cadena + "Numero de reglas: " + this.n_reglas + "\n\n";
        for (int i = 0; i < this.n_reglas; ++i) {
            for (int j = 0; j < this.tabla.getnVars(); ++j) {
                cadena = cadena + "" + this.BaseReglas[i][j].x0 + " " + this.BaseReglas[i][j].x1 + " " + this.BaseReglas[i][j].x3 + "\n";
            }
            cadena = cadena + "\n";
        }
        return cadena;
    }

    void RecorreAntecedentes(int[] cromosoma, int[] Regla_act, int pos) {
        if (pos == this.n_var_estado) {
            if (cromosoma[this.pos_gen] != this.base_datos.getnLabels(this.n_var_estado)) {
                for (int i = 0; i < this.n_var_estado; ++i) {
                    this.BaseReglas[this.n_reglas][i] = this.base_datos.getParticion(i, Regla_act[i]);
                }
                this.BaseReglas[this.n_reglas][this.n_var_estado] = this.base_datos.getParticion(this.n_var_estado, cromosoma[this.pos_gen]);
                ++this.n_reglas;
            }
            ++this.pos_gen;
        } else {
            Regla_act[pos] = 0;
            while (Regla_act[pos] < this.base_datos.getnLabels(pos)) {
                this.RecorreAntecedentes(cromosoma, Regla_act, pos + 1);
                int n = pos;
                Regla_act[n] = Regla_act[n] + 1;
            }
        }
    }

    public int decodifica(int[] cromosoma) {
        int[] Regla_act = new int[this.tabla.getnVars()];
        this.n_reglas = 0;
        this.pos_gen = 0;
        this.RecorreAntecedentes(cromosoma, Regla_act, 0);
        return this.n_reglas;
    }
}

