/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

import keel.Algorithms.Genetic_Rule_Learning.M5Rules.MyDataset;

public final class StatisticsStore {
    int numInstances;
    int missingInstances;
    int first;
    int last;
    int attr;
    double sum;
    double sqrSum;
    double va;
    double sd;

    public StatisticsStore(int low, int high, int attribute, MyDataset inst) {
        int count = 0;
        this.numInstances = high - low + 1;
        this.missingInstances = 0;
        this.first = low;
        this.last = high;
        this.attr = attribute;
        this.sum = 0.0;
        this.sqrSum = 0.0;
        for (int i = this.first; i <= this.last; ++i) {
            if (inst.itemset(i).isMissing(this.attr)) continue;
            ++count;
            double value = inst.itemset(i).getValue(this.attr);
            this.sum += value;
            this.sqrSum += value * value;
        }
        if (count > 1) {
            this.va = (this.sqrSum - this.sum * this.sum / (double)count) / (double)count;
            this.va = Math.abs(this.va);
            this.sd = Math.sqrt(this.va);
        } else {
            this.va = 0.0;
            this.sd = 0.0;
        }
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append("Print statistic values of itemsets (" + this.first + "-" + this.last + "\n");
        text.append("    Number of itemsets:\t" + this.numInstances + "\n");
        text.append("    NUmber of itemsets with unknowns:\t" + this.missingInstances + "\n");
        text.append("    Attribute:\t\t\t:" + this.attr + "\n");
        text.append("    Sum:\t\t\t" + this.sum + "\n");
        text.append("    Squared sum:\t\t" + this.sqrSum + "\n");
        text.append("    Stanard Deviation:\t\t" + this.sd + "\n");
        return text.toString();
    }
}

