/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.HYB;

import java.util.Arrays;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.BasicMethods.CNN;
import keel.Algorithms.Instance_Generation.HYB.SVMSEL;
import keel.Algorithms.Instance_Generation.LVQ.LVQ3;
import keel.Algorithms.Instance_Generation.PNN.PNNGenerator;
import keel.Algorithms.Instance_Generation.VQ.VQGenerator;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Pair;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class HYBGenerator
extends PrototypeGenerator {
    public static final String PNN = "PNN";
    public static final String SVM = "SVM";
    public static final String CNN = "CNN";
    public static final String VQ = "VQ";
    public static final String[] typesOfReduction = new String[]{"PNN", "SVM", "CNN", "VQ"};
    private String[] paramsOfInitialReducction = null;
    static final double[] E_BOUNDS = new double[]{0.0, 1.0};
    protected double deltaE = 0.1;
    double initE = E_BOUNDS[0];
    double endE = E_BOUNDS[1];
    static final double[] W_BOUNDS = new double[]{0.0, 1.0};
    protected double deltaW = 0.1;
    double initW = W_BOUNDS[0];
    double endW = W_BOUNDS[1];
    protected double partitionPercentTraining = 40.0;
    protected int desiredFinalSize = 100;
    protected int searchingIterations = 400;
    protected int iterations = 1000;
    protected double perOneGenerated = 0.1;
    protected double alpha_0 = 0.01;
    protected String typeOfInitialReduction = "PNN";

    private static boolean isCorrectHYBType(String t) {
        boolean found = false;
        for (int i = 0; i < typesOfReduction.length && !found; ++i) {
            found = typesOfReduction[i].equals(t);
        }
        return found;
    }

    public HYBGenerator(PrototypeSet _trainingDataSet, Parameters parameters) {
        super(_trainingDataSet, parameters);
        this.iterations = parameters.getNextAsInt();
        this.searchingIterations = parameters.getNextAsInt();
        this.perOneGenerated = parameters.getNextAsDouble() / 100.0;
        this.desiredFinalSize = (int)Math.ceil((double)this.trainingDataSet.size() * this.perOneGenerated);
        this.alpha_0 = parameters.getNextAsDouble();
        this.initE = parameters.getNextAsDouble();
        this.endE = parameters.getNextAsDouble();
        this.deltaE = parameters.getNextAsDouble();
        this.initW = parameters.getNextAsDouble();
        this.endW = parameters.getNextAsDouble();
        this.deltaW = parameters.getNextAsDouble();
        this.partitionPercentTraining = parameters.getNextAsDouble();
        this.typeOfInitialReduction = parameters.getNextAsString();
        this.paramsOfInitialReducction = parameters.getRemainingParameters();
        this.algorithmName = "HYB-" + this.typeOfInitialReduction;
    }

    public HYBGenerator(PrototypeSet tDataSet, int iterSearch, int iterEnd, double percentageGeneratedByOptimalLVQ3, double alpha, double initW, double endW, double deltaW, double initE, double endE, double deltaE, double percentPartition, String type, String[] paramsOfInitialReducction) {
        super(tDataSet);
        this.searchingIterations = iterSearch;
        this.iterations = iterEnd;
        this.perOneGenerated = percentageGeneratedByOptimalLVQ3 / 100.0;
        this.desiredFinalSize = (int)Math.ceil((double)tDataSet.size() * this.perOneGenerated);
        this.alpha_0 = alpha;
        this.initE = initE;
        this.endE = endE;
        this.deltaE = deltaE;
        this.initW = initW;
        this.endW = endW;
        this.deltaW = deltaW;
        this.partitionPercentTraining = percentPartition;
        this.typeOfInitialReduction = type;
        this.paramsOfInitialReducction = paramsOfInitialReducction;
        Debug.force(HYBGenerator.isCorrectHYBType(type), "Type of HYB " + type + " is not allowed");
        this.algorithmName = "HYB-" + type;
    }

    public HYBGenerator(PrototypeSet tDataSet, int iterSearch, int iterEnd, double percentageGeneratedByOptimalLVQ3, double alpha, double initW, double endW, double deltaW, double initE, double endE, double deltaE, double percentPartition, String type, String paramsOfInitialReducction) {
        super(tDataSet);
        this.iterations = iterEnd;
        this.searchingIterations = iterSearch;
        this.perOneGenerated = percentageGeneratedByOptimalLVQ3 / 100.0;
        this.desiredFinalSize = (int)Math.ceil((double)tDataSet.size() * this.perOneGenerated);
        this.alpha_0 = alpha;
        this.initE = initE;
        this.endE = endE;
        this.deltaE = deltaE;
        this.initW = initW;
        this.endW = endW;
        this.deltaW = deltaW;
        this.partitionPercentTraining = percentPartition;
        this.typeOfInitialReduction = type;
        this.paramsOfInitialReducction = paramsOfInitialReducction.split("\\,");
        Debug.force(HYBGenerator.isCorrectHYBType(type), "Type of HYB " + type + " is not allowed");
        this.algorithmName = "HYB-" + type;
    }

    private PrototypeSet makeLVQ3Reduction(PrototypeSet InitialSet, PrototypeSet training, double w, double e, int size, int iter) {
        if (InitialSet.size() <= 2) {
            PrototypeSet result = new PrototypeSet();
            result.add(InitialSet.avg());
            return result;
        }
        if (InitialSet.size() < size) {
            size = InitialSet.size();
        }
        LVQ3 lvq3 = new LVQ3(InitialSet, training, iter, size, this.alpha_0, w, e);
        PrototypeSet reducedByLVQ3 = lvq3.execute();
        return reducedByLVQ3;
    }

    private PrototypeSet searchingTypeLVQ3Reduction(PrototypeSet InitialSet, PrototypeSet training, double w, double e) {
        int size = (int)Math.ceil((double)InitialSet.size() * this.perOneGenerated);
        return this.makeLVQ3Reduction(InitialSet, this.trainingDataSet, w, e, size, this.searchingIterations);
    }

    private PrototypeSet optimalLVQ3Reduction(PrototypeSet InitialSet, PrototypeSet training, double w, double e) {
        return this.makeLVQ3Reduction(InitialSet, training, w, e, this.desiredFinalSize, this.iterations);
    }

    protected PrototypeSet initialReduction() {
        PrototypeSet reduced = null;
        String type = this.typeOfInitialReduction;
        int i = 0;
        int kCNN = Integer.parseInt(this.paramsOfInitialReducction[i++]);
        int iterVQ = Integer.parseInt(this.paramsOfInitialReducction[i++]);
        double redVQ = Double.parseDouble(this.paramsOfInitialReducction[i++]);
        int kVQ = Integer.parseInt(this.paramsOfInitialReducction[i++]);
        double alpha0VQ = Double.parseDouble(this.paramsOfInitialReducction[i++]);
        String kernelType = this.paramsOfInitialReducction[i++];
        double C = Double.parseDouble(this.paramsOfInitialReducction[i++]);
        double eps = Double.parseDouble(this.paramsOfInitialReducction[i++]);
        int degree = Integer.parseInt(this.paramsOfInitialReducction[i++]);
        double gamma = Double.parseDouble(this.paramsOfInitialReducction[i++]);
        double nu = Double.parseDouble(this.paramsOfInitialReducction[i++]);
        double p = Double.parseDouble(this.paramsOfInitialReducction[i++]);
        int shrinking = Integer.parseInt(this.paramsOfInitialReducction[i++]);
        int NpVQ = (int)Math.ceil((double)this.trainingDataSet.size() * redVQ / 100.0);
        if (type.equals(PNN)) {
            PNNGenerator generator = new PNNGenerator(this.trainingDataSet, this.desiredFinalSize);
            reduced = generator.reduceSet();
            Debug.println(PNN);
        } else if (type.equals(CNN)) {
            CNN cnn = new CNN(this.trainingDataSet, kCNN);
            reduced = cnn.reduceSet();
            Debug.errorln("CNN de " + reduced.size());
        } else if (type.equals(VQ)) {
            VQGenerator generator = new VQGenerator(this.trainingDataSet, iterVQ, NpVQ, alpha0VQ, kVQ);
            reduced = generator.reduceSet();
            Debug.println(VQ);
        } else if (type.equals(SVM)) {
            SVMSEL svm = new SVMSEL(this.trainingDataSet, kernelType, C, eps, degree, gamma, nu, p, shrinking);
            reduced = svm.reduceSet();
            System.out.println("Hemos seleccionado " + reduced.size() + " de " + this.trainingDataSet.size());
            Debug.println(SVM);
        } else {
            Debug.goout("Reduction must be SVM, CNN, PNN, or VQ");
        }
        return reduced;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet initialSet = this.initialReduction();
        Debug.errorln("Tama\u00ef\u00bf\u00bdo " + initialSet.size());
        Pair<PrototypeSet, PrototypeSet> Tglobal = this.trainingDataSet.makePartitionPerClass(this.partitionPercentTraining);
        PrototypeSet TpGlobal = Tglobal.first();
        PrototypeSet ToGlobal = Tglobal.second();
        double bestE = this.initE;
        double bestW = this.initW;
        double bestAcc = HYBGenerator.accuracy(TpGlobal, ToGlobal);
        System.out.println("InitialAcc =" + bestAcc);
        for (double w = this.initW; w <= this.endW; w += this.deltaW) {
            for (double e = this.initE; e <= this.endE; e += this.deltaE) {
                PrototypeSet reduced_i = this.searchingTypeLVQ3Reduction(initialSet, TpGlobal, w, e);
                double currentAcc = HYBGenerator.accuracy(reduced_i, ToGlobal);
                if (!(currentAcc >= bestAcc)) continue;
                initialSet = reduced_i.clone();
                bestAcc = currentAcc;
                bestE = e;
                bestW = w;
            }
        }
        PrototypeSet reduced = this.optimalLVQ3Reduction(initialSet, TpGlobal, bestW, bestE);
        System.err.println("\n% de acierto en training " + (double)KNN.classficationAccuracy(reduced, this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size());
        return reduced;
    }

    public static void main(String[] args) {
        Parameters.setUse("HYB", "<seed> <num. iterations>\n<num. prototypes>\n<alpha_0>\n<initW><endW><deltaW>\n<initE><endE><deltaE>\n<% init partition training>\n<type of init reduction> <params of init reduction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        HYBGenerator.setSeed(seed);
        int iterSearch = Parameters.assertExtendedArgAsInt(args, 3, "iterations of LVQ3 optimization process", 1.0, 2.147483647E9);
        int iterOptimal = Parameters.assertExtendedArgAsInt(args, 4, "iterations of optimal-LVQ3 reduction", 1.0, 2.147483647E9);
        double percentOptimalLVQ3Set = Parameters.assertExtendedArgAsDouble(args, 5, "% of prototypes used in optimal LVQ3", 1.0, 100.0);
        double alpha_0 = Parameters.assertExtendedArgAsDouble(args, 6, "alpha_0", 0.0, 1.0);
        double initW = Parameters.assertExtendedArgAsDouble(args, 7, "Initial W value", 0.0, 1.0);
        double endW = Parameters.assertExtendedArgAsDouble(args, 8, "End W value", 0.0, 1.0);
        double deltaW = Parameters.assertExtendedArgAsDouble(args, 9, "delta Window Width", 0.0, 1.0);
        double initE = Parameters.assertExtendedArgAsDouble(args, 10, "Initial E value", 0.0, 1.0);
        double endE = Parameters.assertExtendedArgAsDouble(args, 11, "End E value", 0.0, 1.0);
        double deltaE = Parameters.assertExtendedArgAsDouble(args, 12, "delta Epsilon", 0.0, 1.0);
        double percentPart = Parameters.assertExtendedArgAsDouble(args, 13, "% of training data set used as training in the search process", 5.0, 100.0);
        String type = Parameters.assertExtendedArgAsString(args, 14, "Type of algorithm used in initial reduction", typesOfReduction);
        String[] parametersOfInitialReduction = Arrays.copyOfRange(args, 15, args.length);
        HYBGenerator generator = new HYBGenerator(training, iterSearch, iterOptimal, percentOptimalLVQ3Set, alpha_0, initW, endW, deltaW, initE, endE, deltaE, percentPart, type, parametersOfInitialReduction);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

