/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Associative_Classification.ClassifierCMAR;

import javax.swing.JTextArea;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.AssocRuleMining;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.RuleList;
import keel.Algorithms.Associative_Classification.ClassifierCMAR.TtreeNode;

public class TotalSupportTree
extends AssocRuleMining {
    protected TtreeNode[] startTtreeRef;
    protected final int MAX_NUM_FREQUENT_SETS = 1000000;
    protected boolean nextLevelExists = true;
    protected RuleList currentRlist = null;
    protected int numFrequentsets = 0;
    protected long numUpdates = 0L;
    protected String duration = null;

    public TotalSupportTree(double minConf, double minSup, int delta) {
        super(minConf, minSup);
        this.currentRlist = new RuleList(delta);
    }

    protected void createTtreeTopLevel() {
        this.startTtreeRef = new TtreeNode[this.numOneItemSets + 1];
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            this.startTtreeRef[index] = new TtreeNode();
        }
        this.createTtreeTopLevel2();
        this.pruneLevelN(this.startTtreeRef, 1);
    }

    protected void createTtreeTopLevel2() {
    }

    protected boolean pruneLevelN(TtreeNode[] linkRef, int level) {
        int size = linkRef.length;
        if (level == 1) {
            boolean allUnsupported = true;
            for (int index1 = 1; index1 < size; ++index1) {
                if (linkRef[index1] == null) continue;
                if ((double)linkRef[index1].support < this.minSupport) {
                    linkRef[index1] = null;
                    continue;
                }
                ++this.numFrequentsets;
                allUnsupported = false;
            }
            return allUnsupported;
        }
        for (int index1 = level; index1 < size; ++index1) {
            if (linkRef[index1] == null || linkRef[index1].childRef == null || !this.pruneLevelN(linkRef[index1].childRef, level - 1)) continue;
            linkRef[index1].childRef = null;
        }
        return false;
    }

    protected void generateLevel2() {
        this.nextLevelExists = false;
        for (int index = 2; index < this.startTtreeRef.length; ++index) {
            if (this.startTtreeRef[index] == null) continue;
            this.generateNextLevel(this.startTtreeRef, index, this.realloc2(null, (short)index));
        }
    }

    protected void generateLevelN(TtreeNode[] linkRef, int level, short[] itemSet) {
        int localSize = linkRef.length;
        if (level == 1) {
            for (int index1 = 2; index1 < localSize; ++index1) {
                if (linkRef[index1] == null) continue;
                this.generateNextLevel(linkRef, index1, this.realloc2(itemSet, (short)index1));
            }
        } else {
            for (int index1 = level; index1 < localSize; ++index1) {
                if (linkRef[index1] == null || linkRef[index1].childRef == null) continue;
                this.generateLevelN(linkRef[index1].childRef, level - 1, this.realloc2(itemSet, (short)index1));
            }
        }
    }

    protected void generateNextLevel(TtreeNode[] parentRef, int endIndex, short[] itemSet) {
        parentRef[endIndex].childRef = new TtreeNode[endIndex];
        TtreeNode currentNode = parentRef[endIndex];
        for (int index = 1; index < endIndex; ++index) {
            if (parentRef[index] == null) continue;
            short[] newItemSet = this.realloc2(itemSet, (short)index);
            if (this.testCombinations(newItemSet)) {
                currentNode.childRef[index] = new TtreeNode();
                this.nextLevelExists = true;
                continue;
            }
            currentNode.childRef[index] = null;
        }
    }

    protected boolean testCombinations(short[] currentItemSet) {
        if (currentItemSet.length < 3) {
            return true;
        }
        short[] itemSet1 = new short[]{currentItemSet[1], currentItemSet[0]};
        int size = currentItemSet.length - 2;
        short[] itemSet2 = this.removeFirstNelements(currentItemSet, 2);
        return this.combinations(null, 0, 2, itemSet1, itemSet2);
    }

    private boolean combinations(short[] sofarSet, int startIndex, int endIndex, short[] itemSet1, short[] itemSet2) {
        if (endIndex > itemSet2.length) {
            short[] testSet = this.append(sofarSet, itemSet1);
            return this.findItemSetInTtree(testSet);
        }
        for (int index = startIndex; index < endIndex; ++index) {
            short[] tempSet = this.realloc2(sofarSet, itemSet2[index]);
            if (this.combinations(tempSet, index + 1, endIndex + 1, itemSet1, itemSet2)) continue;
            return false;
        }
        return true;
    }

    protected boolean findItemSetInTtree(short[] itemSet) {
        if (this.startTtreeRef[itemSet[0]] != null) {
            int lastIndex = itemSet.length - 1;
            if (lastIndex == 0) {
                return true;
            }
            if (this.startTtreeRef[itemSet[0]].childRef != null) {
                return this.findItemSetInTtree2(itemSet, 1, lastIndex, this.startTtreeRef[itemSet[0]].childRef);
            }
            return false;
        }
        return false;
    }

    private boolean findItemSetInTtree2(short[] itemSet, int index, int lastIndex, TtreeNode[] linkRef) {
        if (linkRef[itemSet[index]] != null) {
            if (index == lastIndex) {
                return true;
            }
            if (linkRef[itemSet[index]].childRef != null) {
                return this.findItemSetInTtree2(itemSet, index + 1, lastIndex, linkRef[itemSet[index]].childRef);
            }
            return false;
        }
        return false;
    }

    protected int getSupportForItemSetInTtree(short[] itemSet) {
        int lastIndex = itemSet.length - 1;
        if (this.startTtreeRef[itemSet[lastIndex]] != null) {
            if (lastIndex == 0) {
                return this.startTtreeRef[itemSet[0]].support;
            }
            return this.getSupportForItemSetInTtree2(itemSet, lastIndex - 1, this.startTtreeRef[itemSet[lastIndex]].childRef);
        }
        return 0;
    }

    private int getSupportForItemSetInTtree2(short[] itemSet, int index, TtreeNode[] linkRef) {
        if (linkRef[itemSet[index]] != null) {
            if (index == 0) {
                return linkRef[itemSet[0]].support;
            }
            return this.getSupportForItemSetInTtree2(itemSet, index - 1, linkRef[itemSet[index]].childRef);
        }
        return 0;
    }

    protected double getConfidence(short[] antecedent, double support) {
        double supportForAntecedent = this.getSupportForItemSetInTtree(antecedent);
        double confidenceForAR = support / supportForAntecedent * 10000.0;
        int tempConf = (int)confidenceForAR;
        confidenceForAR = (double)tempConf / 100.0;
        return confidenceForAR;
    }

    protected double getConfidence(double antecedentSupp, double totalSupp) {
        double confidenceForAR = totalSupp / antecedentSupp * 10000.0;
        int tempConf = (int)confidenceForAR;
        confidenceForAR = (double)tempConf / 100.0;
        return confidenceForAR;
    }

    public int getNumFreqSets() {
        if (this.startTtreeRef == null) {
            return 0;
        }
        int num = 0;
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] == null || !((double)this.startTtreeRef[index].support >= this.minSupport)) continue;
            num = this.countNumFreqSets(index, this.startTtreeRef[index].childRef, num + 1);
        }
        return num;
    }

    public double getMinSupport() {
        return this.minSupport;
    }

    public RuleList getCurrentRuleListObject() {
        return this.currentRlist;
    }

    public void setNumOneItemSets() {
        this.numOneItemSets = this.getNumSupOneItemSets();
    }

    public void outputTtree() {
        int number = 1;
        for (int index = 1; index < this.startTtreeRef.length; ++index) {
            if (this.startTtreeRef[index] == null) continue;
            System.out.print("[" + number + "] {" + index);
            System.out.println("} = " + this.startTtreeRef[index].support);
            this.outputTtree(new Integer(number).toString(), new Integer(index).toString(), this.startTtreeRef[index].childRef);
            ++number;
        }
    }

    private void outputTtree(String number, String itemSetSofar, TtreeNode[] linkRef) {
        int num = 1;
        number = number + ".";
        itemSetSofar = itemSetSofar + " ";
        if (linkRef == null) {
            return;
        }
        for (int index = 1; index < linkRef.length; ++index) {
            if (linkRef[index] == null) continue;
            System.out.print("[" + number + num + "] {" + itemSetSofar + index);
            System.out.println("} = " + linkRef[index].support);
            String newitemSet = itemSetSofar + new Integer(index).toString();
            this.outputTtree(number + num, newitemSet, linkRef[index].childRef);
            ++num;
        }
    }

    public void outputTtreeBranch(TtreeNode[] linkRef) {
        int number = 1;
        if (linkRef == null) {
            return;
        }
        for (int index = 1; index < linkRef.length; ++index) {
            if (linkRef[index] == null) continue;
            System.out.print("[" + number + "] {" + index);
            System.out.println("} = " + linkRef[index].support);
            this.outputTtree(new Integer(number).toString(), new Integer(index).toString(), linkRef[index].childRef);
            ++number;
        }
    }

    public void outputFrequentSets() {
        int number = 1;
        System.out.println("FREQUENT (LARGE) ITEM SETS:\n---------------------------");
        System.out.println("Format: [N] {I} = S, where N is a sequential number, I is the item set and N the support.");
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] == null || !((double)this.startTtreeRef[index].support >= this.minSupport)) continue;
            System.out.println("[" + number + "] {" + index + "} = " + this.startTtreeRef[index].support);
            number = this.outputFrequentSets(number + 1, new Integer(index).toString(), index, this.startTtreeRef[index].childRef);
        }
        System.out.println("\n");
    }

    private int outputFrequentSets(int number, String itemSetSofar, int size, TtreeNode[] linkRef) {
        if (linkRef == null) {
            return number;
        }
        itemSetSofar = itemSetSofar + " ";
        for (int index = 1; index < size; ++index) {
            if (linkRef[index] == null || !((double)linkRef[index].support >= this.minSupport)) continue;
            System.out.println("[" + number + "] {" + itemSetSofar + index + "} = " + linkRef[index].support);
            String newitemSet = itemSetSofar + new Integer(index).toString();
            number = this.outputFrequentSets(number + 1, newitemSet, index, linkRef[index].childRef);
        }
        return number;
    }

    public void outputFrequentSets(JTextArea textArea) {
        int number = 1;
        textArea.append("FREQUENT (LARGE) ITEM SETS:\n---------------------------\n");
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] == null || !((double)this.startTtreeRef[index].support >= this.minSupport)) continue;
            textArea.append("[" + number + "] {" + index + "} = " + this.startTtreeRef[index].support + "\n");
            number = this.outputFrequentSets(textArea, number + 1, new Integer(index).toString(), index, this.startTtreeRef[index].childRef);
        }
        textArea.append("\n");
    }

    private int outputFrequentSets(JTextArea textArea, int number, String itemSetSofar, int size, TtreeNode[] linkRef) {
        if (linkRef == null) {
            return number;
        }
        itemSetSofar = itemSetSofar + " ";
        for (int index = 1; index < size; ++index) {
            if (linkRef[index] == null || !((double)linkRef[index].support >= this.minSupport)) continue;
            textArea.append("[" + number + "] {" + itemSetSofar + index + "} = " + linkRef[index].support + "\n");
            String newitemSet = itemSetSofar + new Integer(index).toString();
            number = this.outputFrequentSets(textArea, number + 1, newitemSet, index, linkRef[index].childRef);
        }
        return number;
    }

    public void outputNumFreqSets() {
        if (this.startTtreeRef == null) {
            System.out.println("Number of frequent sets = 0");
        } else {
            System.out.println("Number of frequent sets = " + this.countNumFreqSets());
        }
    }

    protected int countNumFreqSets() {
        if (this.startTtreeRef == null) {
            return 0;
        }
        int num = 0;
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] == null || !((double)this.startTtreeRef[index].support >= this.minSupport)) continue;
            num = this.countNumFreqSets(index, this.startTtreeRef[index].childRef, num + 1);
        }
        return num;
    }

    protected int countNumFreqSets(int size, TtreeNode[] linkRef, int num) {
        if (linkRef == null) {
            return num;
        }
        for (int index = 1; index < size; ++index) {
            if (linkRef[index] == null || !((double)linkRef[index].support >= this.minSupport)) continue;
            num = this.countNumFreqSets(index, linkRef[index].childRef, num + 1);
        }
        return num;
    }

    public void outputNumFreqSetsPerBranch() {
        System.out.println("Number of frequent sets per branch");
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] == null) continue;
            System.out.println("(" + index + ")" + this.countNumFreqSets(index, this.startTtreeRef[index].childRef, 1));
        }
    }

    public void outputTtreeStats() {
        System.out.println("T-TREE STATISTICS\n-----------------");
        System.out.println(this.calculateStorage() + " (Bytes) storage");
        System.out.println(TtreeNode.getNumberOfNodes() + " nodess");
        System.out.println(this.countNumFreqSets() + " frequent sets");
        System.out.println(this.numUpdates + " support value increments");
        System.out.println(this.duration);
    }

    public void outputTtreeStats(JTextArea textArea) {
        textArea.append("T-TREE STATISTICS\n-----------------\n");
        textArea.append(this.calculateStorage() + " (Bytes) storage\n");
        textArea.append(TtreeNode.getNumberOfNodes() + " nodess\n");
        textArea.append(this.countNumFreqSets() + " frequent sets\n");
        textArea.append(this.numUpdates + " support value increments\n");
        textArea.append(this.duration + "\n");
    }

    public void outputNumUpdates() {
        System.out.println("Number of Nodes created = " + TtreeNode.getNumberOfNodes());
        System.out.println("Number of Updates       = " + this.numUpdates);
    }

    public void outputStorage() {
        if (this.startTtreeRef == null) {
            return;
        }
        System.out.println("T-tree Storage          = " + this.calculateStorage() + " (Bytes)");
    }

    protected int calculateStorage() {
        if (this.startTtreeRef == null) {
            return 0;
        }
        int storage = 4;
        for (int index = 1; index <= this.numOneItemSets; ++index) {
            if (this.startTtreeRef[index] != null) {
                storage = storage + 12 + this.calculateStorage(0, this.startTtreeRef[index].childRef);
                continue;
            }
            storage += 4;
        }
        return storage;
    }

    private int calculateStorage(int localStorage, TtreeNode[] linkRef) {
        if (linkRef == null) {
            return 0;
        }
        for (int index = 1; index < linkRef.length; ++index) {
            if (linkRef[index] != null) {
                localStorage = localStorage + 12 + this.calculateStorage(0, linkRef[index].childRef);
                continue;
            }
            localStorage += 4;
        }
        return localStorage + 4;
    }
}

