/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.PART;

import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.Rule_Learning.PART.IncrementalMask;
import keel.Algorithms.Rule_Learning.PART.Itemset;
import keel.Algorithms.Rule_Learning.PART.Mask;
import keel.Algorithms.Rule_Learning.PART.MyAttribute;
import keel.Algorithms.Rule_Learning.PART.Rule;
import keel.Algorithms.Rule_Learning.PART.Ruleset;
import keel.Algorithms.Rule_Learning.PART.SimpleRule;
import keel.Algorithms.Rule_Learning.PART.Utilities;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.DatasetException;
import keel.Dataset.HeaderFormatException;
import keel.Dataset.InstanceSet;

public class MyDataset {
    protected String name = "";
    protected Vector attributes;
    protected Vector itemsets;
    protected int classIndex;
    protected InstanceSet IS;

    public MyDataset(String name, boolean train) {
        try {
            this.IS = new InstanceSet();
            this.IS.readSet(name, train);
        }
        catch (DatasetException e) {
            System.out.println("Error loading dataset instances");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (HeaderFormatException e) {
            System.out.println("Error loading dataset instances");
            e.printStackTrace();
            System.exit(-1);
        }
        this.readHeader();
        this.itemsets = new Vector(this.IS.getNumInstances());
        this.getItemsetFull();
    }

    public MyDataset(MyDataset dataset) {
        this(dataset, dataset.numItemsets());
        dataset.copyItemsets(0, this, dataset.numItemsets());
    }

    public MyDataset(MyDataset dataset, int capacity) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.classIndex = dataset.classIndex;
        this.name = dataset.getName();
        this.attributes = dataset.attributes;
        this.itemsets = new Vector(capacity);
    }

    private void readHeader() {
        Vector<String> attributeValues;
        MyAttribute att;
        float max;
        float min;
        String attributeName;
        Attribute at;
        int j;
        this.name = Attributes.getRelationName();
        this.attributes = new Vector();
        for (j = 0; j < Attributes.getInputNumAttributes(); ++j) {
            at = Attributes.getInputAttribute(j);
            attributeName = at.getName();
            if (at.getType() == 2) {
                min = (float)at.getMinAttribute();
                max = (float)at.getMinAttribute();
                this.attributes.addElement(new MyAttribute(attributeName, j));
                att = (MyAttribute)this.attributes.elementAt(j);
                att.setRange(min, max);
                att.activate();
                continue;
            }
            if (at.getType() == 1) {
                int min2 = (int)at.getMinAttribute();
                int max2 = (int)at.getMinAttribute();
                this.attributes.addElement(new MyAttribute(attributeName, j));
                att = (MyAttribute)this.attributes.elementAt(j);
                att.setRange(min2, max2);
                att.activate();
                continue;
            }
            attributeValues = new Vector<String>();
            for (int k = 0; k < at.getNumNominalValues(); ++k) {
                attributeValues.addElement(at.getNominalValue(k));
            }
            this.attributes.addElement(new MyAttribute(attributeName, attributeValues, j));
            MyAttribute att2 = (MyAttribute)this.attributes.elementAt(j);
            att2.activate();
        }
        at = Attributes.getOutputAttribute(0);
        attributeName = at.getName();
        j = Attributes.getNumAttributes() - 1;
        if (at.getType() == 2) {
            min = (float)at.getMinAttribute();
            max = (float)at.getMinAttribute();
            this.attributes.addElement(new MyAttribute(attributeName, j));
            att = (MyAttribute)this.attributes.elementAt(j);
            att.setRange(min, max);
            att.activate();
        } else if (at.getType() == 1) {
            int min3 = (int)at.getMinAttribute();
            int max3 = (int)at.getMinAttribute();
            this.attributes.addElement(new MyAttribute(attributeName, j));
            att = (MyAttribute)this.attributes.elementAt(j);
            att.setRange(min3, max3);
            att.activate();
        } else {
            attributeValues = new Vector();
            for (int k = 0; k < at.getNumNominalValues(); ++k) {
                attributeValues.addElement(at.getNominalValue(k));
            }
            this.attributes.addElement(new MyAttribute(attributeName, attributeValues, j));
            MyAttribute att3 = (MyAttribute)this.attributes.elementAt(j);
            att3.activate();
        }
        this.classIndex = Attributes.getNumAttributes() - 1;
    }

    private boolean getItemsetFull() {
        for (int j = 0; j < this.IS.getNumInstances(); ++j) {
            int k;
            int i;
            double[] itemset = new double[Attributes.getNumAttributes()];
            for (i = 0; i < Attributes.getInputNumAttributes(); ++i) {
                if (this.IS.getInstance(j).getInputMissingValues(i)) {
                    itemset[i] = Itemset.getMissingValue();
                    continue;
                }
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    for (k = 0; k < Attributes.getInputAttribute(i).getNumNominalValues(); ++k) {
                        if (!Attributes.getInputAttribute(i).getNominalValue(k).equals(this.IS.getInstance(j).getInputNominalValues(i))) continue;
                        itemset[i] = k;
                    }
                    continue;
                }
                itemset[i] = this.IS.getInstance(j).getInputRealValues(i);
            }
            i = Attributes.getInputNumAttributes();
            if (this.IS.getInstance(j).getOutputMissingValues(0)) {
                itemset[i] = Itemset.getMissingValue();
            } else if (Attributes.getOutputAttribute(0).getType() == 0) {
                for (k = 0; k < Attributes.getOutputAttribute(0).getNumNominalValues(); ++k) {
                    if (!Attributes.getOutputAttribute(0).getNominalValue(k).equals(this.IS.getInstance(j).getOutputNominalValues(0))) continue;
                    itemset[i] = k;
                }
            } else {
                itemset[i] = this.IS.getInstance(j).getOutputRealValues(0);
            }
            this.addItemset(new Itemset(1.0, itemset));
        }
        return true;
    }

    public final void addItemset(Itemset itemset) {
        Itemset newItemset = (Itemset)itemset.copy();
        newItemset.setDataset(this);
        this.itemsets.addElement(newItemset);
    }

    public String getName() {
        return this.name;
    }

    public final MyAttribute getAttribute(int index) {
        return (MyAttribute)this.attributes.elementAt(index);
    }

    public final MyAttribute getAttribute(String name) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (!((MyAttribute)this.attributes.elementAt(i)).name().equalsIgnoreCase(name)) continue;
            return (MyAttribute)this.attributes.elementAt(i);
        }
        return null;
    }

    public final MyAttribute getClassAttribute() {
        if (this.classIndex < 0) {
            System.err.println("Class index wrong:" + this.classIndex);
            return null;
        }
        return this.getAttribute(this.classIndex);
    }

    public final int getClassIndex() {
        return this.classIndex;
    }

    public final int numAttributes() {
        return this.attributes.size();
    }

    public final int numClasses() {
        if (this.classIndex < 0) {
            System.err.println("Class index wrong:" + this.classIndex);
            return -1;
        }
        return this.getClassAttribute().numValues();
    }

    public final int numItemsets() {
        return this.itemsets.size();
    }

    public final void delete(int index) {
        this.itemsets.removeElementAt(index);
    }

    public final void deleteWithMissing(int attIndex) {
        Vector<Itemset> newItemsets = new Vector<Itemset>(this.numItemsets());
        for (int i = 0; i < this.numItemsets(); ++i) {
            if (this.itemset(i).isMissing(attIndex)) continue;
            newItemsets.addElement(this.itemset(i));
        }
        this.itemsets = newItemsets;
    }

    public Enumeration enumerateAttributes() {
        Vector help = new Vector(this.attributes.size() - 1);
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (i == this.classIndex) continue;
            help.addElement(this.attributes.elementAt(i));
        }
        return help.elements();
    }

    public final Enumeration enumerateItemsets() {
        return this.itemsets.elements();
    }

    public final Itemset itemset(int index) {
        return (Itemset)this.itemsets.elementAt(index);
    }

    public final Itemset lastItemset() {
        return (Itemset)this.itemsets.lastElement();
    }

    private void copyItemsets(int from, MyDataset dest, int num) {
        for (int i = 0; i < num; ++i) {
            dest.addItemset(this.itemset(from + i));
        }
    }

    public final double sumOfWeights() {
        double sum = 0.0;
        for (int i = 0; i < this.numItemsets(); ++i) {
            sum += this.itemset(i).getWeight();
        }
        return sum;
    }

    public final void sort(int attIndex) {
        int j = this.numItemsets() - 1;
        int i = 0;
        while (i <= j) {
            if (this.itemset(j).isMissing(attIndex)) {
                --j;
                continue;
            }
            if (this.itemset(i).isMissing(attIndex)) {
                this.swap(i, j);
                --j;
            }
            ++i;
        }
        this.quickSort(attIndex, 0, j);
    }

    private void quickSort(int attIndex, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            double mid = this.itemset((lo0 + hi0) / 2).getValue(attIndex);
            double midPlus = mid + 1.0E-6;
            double midMinus = mid - 1.0E-6;
            while (lo <= hi) {
                while (this.itemset(lo).getValue(attIndex) < midMinus && lo < hi0) {
                    ++lo;
                }
                while (this.itemset(hi).getValue(attIndex) > midPlus && hi > lo0) {
                    --hi;
                }
                if (lo > hi) continue;
                this.swap(lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(attIndex, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(attIndex, lo, hi0);
            }
        }
    }

    private void swap(int i, int j) {
        Object help = this.itemsets.elementAt(i);
        this.itemsets.insertElementAt(this.itemsets.elementAt(j), i);
        this.itemsets.removeElementAt(i + 1);
        this.itemsets.insertElementAt(help, j);
        this.itemsets.removeElementAt(j + 1);
    }

    public void filter(Mask mask, int A, double V, int operator) {
        mask.resetIndex();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) {
                mask.reset();
                continue;
            }
            if (operator == Rule.EQUAL && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) != V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V)) continue;
            mask.reset();
        }
    }

    public void filter(Mask mask, SimpleRule sr) {
        int A = sr.getAttribute();
        double V = sr.getValue();
        int operator = sr.getOperator();
        mask.resetIndex();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) {
                mask.reset();
                continue;
            }
            if (operator == Rule.EQUAL && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) != V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V)) continue;
            mask.reset();
        }
    }

    public void filter(Mask mask, Rule rule) {
        for (int i = 0; i < rule.size(); ++i) {
            this.filter(mask, rule.getSimpleRule(i));
        }
    }

    public void filter(Mask mask, Ruleset rules) {
        Mask previous = new Mask(this.itemsets.size(), false);
        for (int i = 0; i < rules.size(); ++i) {
            Mask current = mask.copy();
            this.filter(current, rules.getRule(i));
            previous = previous.or(current);
        }
        previous.copyTo(mask);
    }

    public void filter(Mask mask, Ruleset rules, int ignore) {
        Mask previous = new Mask(this.itemsets.size(), false);
        for (int i = 0; i < rules.size(); ++i) {
            if (i == ignore) continue;
            Mask current = mask.copy();
            this.filter(current, rules.getRule(i));
            previous = previous.or(current);
        }
        previous.copyTo(mask);
    }

    public void filterByClass(Mask mask, String class_name) {
        double class_id = this.getAttribute(this.classIndex).valueIndex(class_name);
        mask.resetIndex();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).getClassValue() == class_id) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, int A, double V, int operator) {
        mask.resetIndex();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) continue;
            if (operator == Rule.EQUAL && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) == V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V)) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, SimpleRule sr) {
        mask.resetIndex();
        int A = sr.getAttribute();
        double V = sr.getValue();
        int operator = sr.getOperator();
        while (mask.next()) {
            if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) continue;
            if (operator == Rule.EQUAL && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) == V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V)) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, Rule rule) {
        mask.resetIndex();
        while (mask.next()) {
            boolean seguir = true;
            for (int i = 0; i < rule.size() && seguir; ++i) {
                int A = rule.getSimpleRule(i).getAttribute();
                double V = rule.getSimpleRule(i).getValue();
                int operator = rule.getSimpleRule(i).getOperator();
                if (((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(A)) {
                    seguir = false;
                    continue;
                }
                if (operator == Rule.EQUAL) {
                    boolean bl = seguir = ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) == V;
                }
                if (operator == Rule.GREATER) {
                    boolean bl = seguir = ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) > V;
                }
                if (operator != Rule.LOWER) continue;
                seguir = ((Itemset)this.itemsets.elementAt(mask.getIndex())).getValue(A) <= V;
            }
            if (!seguir) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, Ruleset rules) {
        for (int i = 0; i < rules.size(); ++i) {
            this.substract(mask, rules.getRule(i));
        }
    }

    public void substract(Mask mask, Ruleset rules, int ignore) {
        for (int i = 0; i < rules.size(); ++i) {
            if (i == ignore) continue;
            this.substract(mask, rules.getRule(i));
        }
    }

    public MyDataset[] split(Rule r) {
        MyDataset[] split = new MyDataset[2];
        Mask rule_filter = new Mask(this.numItemsets());
        this.filter(rule_filter, r);
        split[0] = new MyDataset(this, rule_filter.getnActive());
        split[1] = new MyDataset(this, this.numItemsets() - split[0].numItemsets());
        for (int i = 0; i < this.numItemsets(); ++i) {
            if (rule_filter.isActive(i)) {
                split[0].addItemset(this.itemset(i));
                continue;
            }
            split[1].addItemset(this.itemset(i));
        }
        return split;
    }

    public String[] classify(Mask actives, Ruleset[] rulesets, int length) {
        int i;
        String[] classification = new String[this.itemsets.size()];
        for (i = 0; i < classification.length; ++i) {
            if (!actives.isActive(i)) continue;
            classification[i] = rulesets[length - 1].getType();
        }
        for (i = 0; i < length - 1; ++i) {
            Mask filtered = actives.copy();
            this.filter(filtered, rulesets[i]);
            filtered.resetIndex();
            while (filtered.next()) {
                int ind = filtered.getIndex();
                classification[ind] = rulesets[i].getType();
            }
            this.substract(actives, rulesets[i]);
        }
        return classification;
    }

    public String[] classify(Mask actives, Vector rules) {
        int i;
        String[] classification = new String[this.itemsets.size()];
        for (i = 0; i < classification.length; ++i) {
            if (!actives.isActive(i)) continue;
            classification[i] = ((Rule)rules.lastElement()).getType();
        }
        for (i = 0; i < rules.size() - 1; ++i) {
            Mask filtered = actives.copy();
            this.filter(filtered, (Rule)rules.elementAt(i));
            filtered.resetIndex();
            while (filtered.next()) {
                int ind = filtered.getIndex();
                classification[ind] = ((Rule)rules.elementAt(i)).getType();
            }
            this.substract(actives, (Rule)rules.elementAt(i));
        }
        return classification;
    }

    public boolean isMissing(int exemple, int attribute) {
        return ((Itemset)this.itemsets.elementAt(exemple)).isMissing(attribute);
    }

    public boolean isMissing(Mask mask, int attribute) {
        return ((Itemset)this.itemsets.elementAt(mask.getIndex())).isMissing(attribute);
    }

    public int size() {
        return this.itemsets.size();
    }

    public String[] classify(Ruleset[] rulesets, int length) {
        return this.classify(new Mask(this.itemsets.size()), rulesets, length);
    }

    public String[] classify(Vector rules) {
        return this.classify(new Mask(this.itemsets.size()), rules);
    }

    public double[] getExample(int pos) {
        return ((Itemset)this.itemsets.elementAt((int)pos)).values;
    }

    public double[] getExample(Mask mask) {
        return ((Itemset)this.itemsets.elementAt((int)mask.getIndex())).values;
    }

    public int[] getClassFequency() {
        int i;
        int[] frequency = new int[this.numClasses()];
        for (i = 0; i < frequency.length; ++i) {
            frequency[i] = 0;
        }
        for (i = 0; i < this.size(); ++i) {
            double class_value = ((Itemset)this.itemsets.elementAt(i)).getValue(this.getClassIndex());
            int n = (int)class_value;
            frequency[n] = frequency[n] + 1;
        }
        return frequency;
    }

    public String getMostFrequentClass() {
        int[] frequency = this.getClassFequency();
        int best_class = -1;
        int best_freq = -1;
        for (int i = 0; i < this.numClasses(); ++i) {
            if (frequency[i] <= best_freq) continue;
            best_class = i;
            best_freq = frequency[i];
        }
        return this.getClassAttribute().value(best_class);
    }

    public int[] getClassFequency(Mask filter) {
        int[] frequency = new int[this.numClasses()];
        for (int i = 0; i < frequency.length; ++i) {
            frequency[i] = 0;
        }
        filter.resetIndex();
        while (filter.next()) {
            double class_value = ((Itemset)this.itemsets.elementAt(filter.getIndex())).getValue(this.getClassIndex());
            int n = (int)class_value;
            frequency[n] = frequency[n] + 1;
        }
        return frequency;
    }

    public double getEntropy() {
        int[] frequency = this.getClassFequency();
        double entropy = 0.0;
        for (int i = 0; i < this.numClasses(); ++i) {
            entropy += Utilities.logFunc(frequency[i]);
        }
        return (Utilities.logFunc(this.numItemsets()) - entropy) / (double)this.numItemsets();
    }

    public double getEntropy(Mask filter) {
        int[] frequency = this.getClassFequency(filter);
        double entropy = 0.0;
        for (int i = 0; i < this.numClasses(); ++i) {
            entropy += Utilities.logFunc(frequency[i]);
        }
        return (Utilities.logFunc(filter.getnActive()) - entropy) / (double)filter.getnActive();
    }

    public String copyHeader() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public String toString() {
        String salida = "";
        for (int i = 0; i < this.itemsets.size(); ++i) {
            double V = ((Itemset)this.itemsets.elementAt(i)).getValue(0);
            salida = ((MyAttribute)this.attributes.elementAt(0)).isDiscret() ? salida + i + ".- (" + this.getAttribute(0).value((int)V) : salida + i + ".- (" + V;
            for (int j = 1; j < this.numAttributes(); ++j) {
                if (j == this.getClassIndex()) continue;
                V = ((Itemset)this.itemsets.elementAt(i)).getValue(j);
                salida = ((MyAttribute)this.attributes.elementAt(j)).isDiscret() ? salida + "," + this.getAttribute(j).value((int)V) : salida + "," + V;
            }
            V = ((Itemset)this.itemsets.elementAt(i)).getValue(this.getClassIndex());
            salida = ((MyAttribute)this.attributes.elementAt(this.getClassIndex())).isDiscret() ? salida + ")-> " + this.getClassAttribute().value((int)V) + "\n" : salida + ")-> " + V;
        }
        return salida;
    }

    public String toString(Mask mask) {
        String salida = "";
        mask.resetIndex();
        while (mask.next()) {
            int i = mask.getIndex();
            double V = ((Itemset)this.itemsets.elementAt(i)).getValue(0);
            salida = ((MyAttribute)this.attributes.elementAt(0)).isDiscret() ? salida + i + ".- (" + this.getAttribute(0).value((int)V) : salida + i + ".- (" + V;
            for (int j = 1; j < this.numAttributes(); ++j) {
                if (j == this.getClassIndex()) continue;
                V = ((Itemset)this.itemsets.elementAt(i)).getValue(j);
                salida = ((MyAttribute)this.attributes.elementAt(j)).isDiscret() ? salida + "," + this.getAttribute(j).value((int)V) : salida + "," + V;
            }
            V = ((Itemset)this.itemsets.elementAt(i)).getValue(this.getClassIndex());
            if (((MyAttribute)this.attributes.elementAt(this.getClassIndex())).isDiscret()) {
                salida = salida + ")-> " + this.getClassAttribute().value((int)V) + "\n";
                continue;
            }
            salida = salida + ")-> " + V;
        }
        return salida;
    }

    public String toString(IncrementalMask mask) {
        String salida = "";
        mask.resetIndex();
        while (mask.next()) {
            int i = mask.getIndex();
            double V = ((Itemset)this.itemsets.elementAt(i)).getValue(0);
            salida = ((MyAttribute)this.attributes.elementAt(0)).isDiscret() ? salida + i + ".- (" + this.getAttribute(0).value((int)V) : salida + i + ".- (" + V;
            for (int j = 1; j < this.numAttributes(); ++j) {
                if (j == this.getClassIndex()) continue;
                V = ((Itemset)this.itemsets.elementAt(i)).getValue(j);
                salida = ((MyAttribute)this.attributes.elementAt(j)).isDiscret() ? salida + "," + this.getAttribute(j).value((int)V) : salida + "," + V;
            }
            V = ((Itemset)this.itemsets.elementAt(i)).getValue(this.getClassIndex());
            if (((MyAttribute)this.attributes.elementAt(this.getClassIndex())).isDiscret()) {
                salida = salida + ")-> " + this.getClassAttribute().value((int)V) + "\n";
                continue;
            }
            salida = salida + ")-> " + V;
        }
        return salida;
    }
}

