/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.util.dataset;

import net.sourceforge.jclec.util.dataset.DatasetException;
import net.sourceforge.jclec.util.dataset.IAttribute;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.dataset.Metadata;

public abstract class AbstractDataset
implements IDataset {
    protected String name;
    protected Metadata metadata;
    protected int cursorPosition;
    protected Instance cursorInstance;

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public int numberOfInstances() throws DatasetException {
        int currCursorPosition = this.cursorPosition;
        this.reset();
        int numbVec = 0;
        while (this.next()) {
            ++numbVec;
        }
        this.reset();
        int i = 0;
        while (i < currCursorPosition) {
            this.next();
            ++i;
        }
        return numbVec;
    }

    @Override
    public boolean move(int index) throws DatasetException {
        this.reset();
        int i = 0;
        while (i < index) {
            if (!this.next()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public IDataset.IInstance read(int rowNumber) throws DatasetException {
        this.move(rowNumber);
        return this.read();
    }

    @Override
    public int read(IDataset.IInstance[] buffer) throws DatasetException {
        return this.read(buffer, 0, buffer.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(IDataset.IInstance[] b, int off, int len) throws DatasetException {
        i = 0;
        if (b == null) {
            throw new DatasetException("Array b can't be null.");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new DatasetException("Index out of bounds. Check offset and length.");
        }
        if (len != 0) ** GOTO lbl11
        return 0;
        while (this.next()) {
            b[off + i] = this.read();
            ++i;
lbl11:
            // 2 sources

            if (i < len) continue;
        }
        return i;
    }

    protected class Instance
    implements IDataset.IInstance {
        protected double[] values;
        protected double weight;

        public Instance() {
            this.values = new double[AbstractDataset.this.metadata.numberOfAttributes()];
        }

        public final void setValue(int index, double value) {
            this.values[index] = value;
        }

        public final void setWeight(double weight) {
            this.weight = weight;
        }

        @Override
        public double[] getValues() {
            return this.values;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public double getValue(int attributeIndex) {
            return this.values[attributeIndex];
        }

        @Override
        public double getValue(IAttribute attribute) {
            return this.values[AbstractDataset.this.metadata.getIndex(attribute)];
        }

        @Override
        public double getValue(String attributeName) {
            return this.values[AbstractDataset.this.metadata.getIndex(attributeName)];
        }

        @Override
        public Instance copy() {
            Instance result = new Instance();
            int i = 0;
            while (i < this.values.length) {
                result.setValue(i, this.values[i]);
                ++i;
            }
            return result;
        }
    }
}

