/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Discretizers.Basic;

import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.Globals.FileManagement;
import keel.Algorithms.Genetic_Rule_Learning.Globals.LogManager;
import keel.Algorithms.Genetic_Rule_Learning.Globals.Parameters;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public abstract class Discretizer {
    protected double[][] cutPoints;
    protected double[][] realValues;
    protected boolean[] realAttributes;
    protected int[] classOfInstances;
    protected int iClassIndex;

    public void buildCutPoints(InstanceSet is) {
        int i;
        Instance[] instances = is.getInstances();
        this.classOfInstances = new int[instances.length];
        for (i = 0; i < instances.length; ++i) {
            this.classOfInstances[i] = instances[i].getOutputNominalValuesInt(0);
        }
        this.cutPoints = new double[Parameters.numAttributes][];
        this.realAttributes = new boolean[Parameters.numAttributes];
        this.realValues = new double[Parameters.numAttributes][];
        i = 0;
        boolean bHit = false;
        int a = 0;
        while (i < Parameters.numAttributes) {
            Attribute at = Attributes.getAttribute(a);
            if (at.getDirectionAttribute() == 1) {
                if (at.getType() == 2 || at.getType() == 1) {
                    this.realAttributes[i] = true;
                    this.realValues[i] = new double[instances.length];
                    int[] points = new int[instances.length];
                    int numPoints = 0;
                    for (int j = 0; j < instances.length; ++j) {
                        if (instances[j].getInputMissingValues(i)) continue;
                        points[numPoints++] = j;
                        this.realValues[i][j] = instances[j].getInputRealValues(i);
                    }
                    this.sortValues(i, points, 0, numPoints - 1);
                    Vector cp = this.discretizeAttribute(i, points, 0, numPoints - 1);
                    if (cp.size() > 0) {
                        this.cutPoints[i] = new double[cp.size()];
                        for (int j = 0; j < this.cutPoints[i].length; ++j) {
                            this.cutPoints[i][j] = (Double)cp.elementAt(j);
                            LogManager.println("Cut point " + j + " of attribute " + i + " : " + this.cutPoints[i][j]);
                        }
                    } else {
                        this.cutPoints[i] = null;
                    }
                    LogManager.println("Number of cut points of attribute " + i + " : " + cp.size());
                } else {
                    this.realAttributes[i] = false;
                }
                ++i;
            } else {
                this.iClassIndex = a;
                bHit = true;
            }
            ++a;
        }
        if (!bHit) {
            this.iClassIndex = Parameters.numAttributes;
        }
    }

    public void applyDiscretization(String in, String out) {
        InstanceSet is = new InstanceSet();
        try {
            is.readSet(in, false);
        }
        catch (Exception e) {
            LogManager.printErr(e.toString());
            System.exit(1);
        }
        FileManagement fm = new FileManagement();
        Instance[] instances = is.getInstances();
        Attribute[] att = Attributes.getInputAttributes();
        try {
            int i;
            fm.initWrite(out);
            fm.writeLine("@relation " + Attributes.getRelationName() + "\n");
            boolean bHit = false;
            for (i = 0; i < Parameters.numAttributes; ++i) {
                if (i == this.iClassIndex) {
                    fm.writeLine(Attributes.getOutputAttributes()[0].toString() + "\n");
                    bHit = true;
                }
                if (this.realAttributes[i]) {
                    String def = "@attribute " + att[i].getName() + " {";
                    if (this.cutPoints[i] != null) {
                        for (int j = 0; j < this.cutPoints[i].length + 1; ++j) {
                            def = def + j;
                            if (j >= this.cutPoints[i].length) continue;
                            def = def + ",";
                        }
                    } else {
                        def = def + 0;
                    }
                    def = def + "}\n";
                    fm.writeLine(def);
                    continue;
                }
                fm.writeLine(att[i].toString() + "\n");
            }
            if (!bHit) {
                fm.writeLine(Attributes.getOutputAttributes()[0].toString() + "\n");
            }
            fm.writeLine("@inputs ");
            for (i = 0; i < Parameters.numAttributes - 1; ++i) {
                fm.writeLine(att[i].getName() + ",");
            }
            fm.writeLine(att[Parameters.numAttributes - 1].getName() + "\n");
            fm.writeLine("@outputs " + Attributes.getOutputAttributes()[0].getName() + "\n");
            fm.writeLine("@data\n");
            bHit = false;
            for (i = 0; i < instances.length; ++i) {
                boolean[] missing = instances[i].getInputMissingValues();
                String newInstance = "";
                for (int j = 0; j < Parameters.numAttributes; ++j) {
                    if (j == this.iClassIndex) {
                        String className = instances[i].getOutputNominalValues(0);
                        newInstance = newInstance + className + ",";
                        bHit = true;
                    }
                    if (missing[j]) {
                        newInstance = newInstance + "?";
                    } else if (this.realAttributes[j]) {
                        double val = instances[i].getInputRealValues(j);
                        int interv = this.discretize(j, val);
                        newInstance = newInstance + interv;
                    } else {
                        newInstance = newInstance + instances[i].getInputNominalValues(j);
                    }
                    newInstance = bHit && j == Parameters.numAttributes - 1 ? newInstance + "\n" : newInstance + ",";
                }
                if (!bHit) {
                    String className = instances[i].getOutputNominalValues(0);
                    newInstance = newInstance + className + "\n";
                }
                fm.writeLine(newInstance);
            }
            fm.closeWrite();
        }
        catch (Exception e) {
            LogManager.printErr("Exception in doDiscretize");
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void sortValues(int attribute, int[] values, int begin, int end) {
        int i = begin;
        int j = end;
        double pivot = this.realValues[attribute][values[(i + j) / 2]];
        while (true) {
            if (this.realValues[attribute][values[i]] < pivot) {
                ++i;
                continue;
            }
            while (this.realValues[attribute][values[j]] > pivot) {
                --j;
            }
            if (i <= j) {
                if (i < j) {
                    int temp = values[i];
                    values[i] = values[j];
                    values[j] = temp;
                }
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (begin < j) {
            this.sortValues(attribute, values, begin, j);
        }
        if (i < end) {
            this.sortValues(attribute, values, i, end);
        }
    }

    public int getNumIntervals(int attribute) {
        return this.cutPoints[attribute].length + 1;
    }

    public double getCutPoint(int attribute, int cp) {
        return this.cutPoints[attribute][cp];
    }

    protected abstract Vector discretizeAttribute(int var1, int[] var2, int var3, int var4);

    public int discretize(int attribute, double value) {
        if (this.cutPoints[attribute] == null) {
            return 0;
        }
        for (int i = 0; i < this.cutPoints[attribute].length; ++i) {
            if (!(value < this.cutPoints[attribute][i])) continue;
            return i;
        }
        return this.cutPoints[attribute].length;
    }
}

