/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA;

import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.Gene;

public class Chromosome
implements Comparable {
    private ArrayList<Gene> genes = new ArrayList();
    private int lengthAnt;
    private double fitness;
    private double supportAnt;
    private double supportCon;
    private double supportAll;
    private boolean[] use;
    private int nVars;

    public Chromosome(int lengthAnt, int nVars) {
        this.lengthAnt = lengthAnt;
        this.nVars = nVars;
        this.use = new boolean[this.nVars];
        for (int i = 0; i < this.nVars; ++i) {
            this.use[i] = false;
        }
    }

    public Chromosome(ArrayList<Gene> geneses, int lengthAnt, int nVars) {
        int i;
        this.lengthAnt = lengthAnt;
        this.nVars = nVars;
        this.use = new boolean[this.nVars];
        for (i = 0; i < this.nVars; ++i) {
            this.use[i] = false;
        }
        for (i = 0; i < geneses.size(); ++i) {
            this.genes.add(geneses.get(i).copy());
            this.use[geneses.get((int)i).getAttr()] = true;
        }
    }

    public Chromosome copy() {
        Chromosome chromo = new Chromosome(this.genes, this.lengthAnt, this.nVars);
        chromo.fitness = this.fitness;
        chromo.supportAnt = this.supportAnt;
        chromo.supportCon = this.supportCon;
        chromo.supportAll = this.supportAll;
        return chromo;
    }

    public void setLengthAnt(int length) {
        this.lengthAnt = length;
    }

    public int getLengthAnt() {
        return this.lengthAnt;
    }

    public void setSupportAnt(double value) {
        this.supportAnt = value;
    }

    public double getSupportAnt() {
        return this.supportAnt;
    }

    public void setSupportCon(double value) {
        this.supportCon = value;
    }

    public double getSupportCon() {
        return this.supportCon;
    }

    public void setSupportAll(double value) {
        this.supportAll = value;
    }

    public double getSupportAll() {
        return this.supportAll;
    }

    public void add(Gene gen) {
        this.genes.add(gen.copy());
        this.use[gen.getAttr()] = true;
    }

    public ArrayList<Gene> getGenes() {
        return this.genes;
    }

    public Gene getGen(int i) {
        return this.genes.get(i);
    }

    public int length() {
        return this.genes.size();
    }

    public double getFit() {
        return this.fitness;
    }

    public void setFit(double fitness) {
        this.fitness = fitness;
    }

    public boolean isUsed(int attr) {
        return this.use[attr];
    }

    public void onUsed(int attr) {
        this.use[attr] = true;
    }

    public void offUsed(int attr) {
        this.use[attr] = false;
    }

    public boolean isSub(Chromosome chromo) {
        int i;
        if (this.length() > chromo.length()) {
            return false;
        }
        for (i = 0; i < this.length(); ++i) {
            if (chromo.isUsed(this.getGen(i).getAttr())) continue;
            return false;
        }
        for (i = 0; i < this.length(); ++i) {
            boolean stop = false;
            for (int j = 0; j < chromo.length() && !stop; ++j) {
                if (this.getGen(i).getAttr() != chromo.getGen(j).getAttr()) continue;
                if (this.getGen(i).isSubValue(chromo.getGen(j))) {
                    stop = true;
                    continue;
                }
                j = chromo.length();
            }
            if (stop) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(Chromosome chromo) {
        int j;
        boolean found;
        int i;
        if (this.lengthAnt != chromo.lengthAnt) {
            return false;
        }
        for (i = 0; i < chromo.genes.size(); ++i) {
            if (this.isUsed(chromo.genes.get(i).getAttr())) continue;
            return false;
        }
        for (i = 0; i <= this.lengthAnt; ++i) {
            found = false;
            for (j = 0; j <= this.lengthAnt && !found; ++j) {
                if (chromo.genes.get(i).getAttr() != this.genes.get(j).getAttr()) continue;
                if (chromo.genes.get(i).isEqualValue(this.genes.get(j))) {
                    found = true;
                    continue;
                }
                j = this.lengthAnt;
            }
            if (found) continue;
            return false;
        }
        for (i = this.lengthAnt + 1; i < chromo.genes.size(); ++i) {
            found = false;
            for (j = this.lengthAnt + 1; j < this.genes.size() && !found; ++j) {
                if (chromo.genes.get(i).getAttr() != this.genes.get(j).getAttr()) continue;
                if (chromo.genes.get(i).isEqualValue(this.genes.get(j))) {
                    found = true;
                    continue;
                }
                j = this.genes.size();
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Object chr) {
        if (((Chromosome)chr).fitness < this.fitness) {
            return -1;
        }
        if (((Chromosome)chr).fitness > this.fitness) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String str = "Size: " + this.genes.size() + "; Fit: " + this.fitness + "\n";
        for (int i = 0; i < this.genes.size(); ++i) {
            str = str + this.genes.get(i) + "\n";
        }
        return str;
    }
}

