/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import keel.Algorithms.ImbalancedClassification.Auxiliar.AUC.PredPair;
import keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Basic.Metodo;
import keel.Algorithms.ImbalancedClassification.Ensembles.Preprocess.Instance_Selection.EUSCHCQstat.EUSCHCQstat;
import keel.Algorithms.ImbalancedClassification.Ensembles.SMOTE.MSMOTE;
import keel.Algorithms.ImbalancedClassification.Ensembles.SMOTE.SMOTE;
import keel.Algorithms.ImbalancedClassification.Ensembles.SPIDER.SPIDER;
import keel.Algorithms.ImbalancedClassification.Ensembles.multi_C45;
import keel.Algorithms.ImbalancedClassification.Ensembles.myDataset;
import org.core.Files;
import org.core.Randomize;

class Ensemble {
    String ensembleType;
    String trainMethod;
    int nClassifier;
    int t;
    String costType;
    double CostMaj;
    double CostMin;
    int lambda;
    myDataset originalDS;
    myDataset actualDS;
    double[] weights;
    double[] alfa;
    double[] penalization;
    double[] weightsBackup;
    int N;
    int nData;
    int nMaj;
    int nMin;
    int majC;
    int minC;
    int nBags;
    int nBoostIterations;
    double[] teta;
    int[] selected;
    int b;
    String spiderType;
    double e;
    ArrayList<boolean[]> trainingSetsOOB;
    boolean[] predictions;
    boolean prepareDSNeeded;
    boolean resampling;
    multi_C45 classifier;
    boolean[][] anteriores;
    boolean[][] salidasAnteriores;
    int nClassifierCounter;
    double[] pairwiseKappa;
    double[] errorMeanAUC;
    double[] errorAUC;
    int[][] outputs;
    int pos;

    public Ensemble(String ensembleType, myDataset originalDS, int nClassifier, int lambda, multi_C45 classifier) {
        this.ensembleType = ensembleType;
        this.originalDS = originalDS;
        this.nData = originalDS.getnData();
        this.majC = originalDS.claseNumerica(originalDS.claseMasFrecuente());
        this.nMaj = originalDS.numberInstances(this.majC);
        this.minC = this.majC == 0 ? 1 : 0;
        this.nMin = originalDS.numberInstances(this.minC);
        this.weights = new double[this.nData];
        this.penalization = new double[this.nData];
        originalDS.computeIR();
        double max = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            this.weights[i] = 1.0 / (double)this.nData;
        }
        this.actualDS = originalDS;
        this.nClassifier = nClassifier;
        this.t = 0;
        this.alfa = new double[nClassifier];
        this.classifier = classifier;
        this.prepareDSNeeded = false;
        this.pairwiseKappa = new double[nClassifier * (nClassifier - 1) / 2];
        this.errorMeanAUC = new double[nClassifier * (nClassifier - 1) / 2];
        this.errorAUC = new double[nClassifier];
        this.outputs = new int[nClassifier][this.classifier.test.getnData()];
        this.pos = 0;
        this.lambda = lambda;
        int nextParameter = 6;
        if (ensembleType.equalsIgnoreCase("IIVOTES")) {
            this.prepareDSNeeded = true;
            Randomize.setSeed(Long.parseLong(classifier.parameters.getParameter(0)));
            this.spiderType = classifier.parameters.getParameter(nextParameter++);
            this.e = 0.5;
            this.trainingSetsOOB = new ArrayList();
            this.predictions = new boolean[this.nData];
            return;
        }
        if (ensembleType.contains("BAG")) {
            Randomize.setSeed(Long.parseLong(classifier.parameters.getParameter(0)));
            this.b = 10;
            if (ensembleType.contains("EUNDER")) {
                this.anteriores = new boolean[this.nClassifier][];
                this.salidasAnteriores = new boolean[this.nClassifier][];
            }
        } else if (ensembleType.contains("ADA") || ensembleType.contains("BOOST") || ensembleType.equalsIgnoreCase("EASYENSEMBLE") || ensembleType.equalsIgnoreCase("BALANCECASCADE")) {
            this.trainMethod = classifier.parameters.getParameter(nextParameter++);
            if (this.trainMethod.equalsIgnoreCase("RESAMPLING")) {
                this.resampling = true;
                this.prepareDSNeeded = true;
                Randomize.setSeed(Long.parseLong(classifier.parameters.getParameter(0)));
            }
            if (ensembleType.equalsIgnoreCase("ADAC2")) {
                this.costType = classifier.parameters.getParameter(nextParameter++);
                if (this.costType.equalsIgnoreCase("ADAPTIVE")) {
                    this.CostMaj = (double)this.nMin / (double)this.nMaj;
                    this.CostMin = 1.0;
                } else {
                    this.CostMaj = Float.parseFloat(classifier.parameters.getParameter(nextParameter++));
                    this.CostMin = Float.parseFloat(classifier.parameters.getParameter(nextParameter++));
                }
            }
            if (ensembleType.contains("RUSBOOST") || ensembleType.contains("SMOTEBOOST")) {
                this.N = Integer.parseInt(classifier.parameters.getParameter(nextParameter++));
                this.prepareDSNeeded = true;
                Randomize.setSeed(Long.parseLong(classifier.parameters.getParameter(0)));
                if (ensembleType.contains("ERUS")) {
                    System.out.println(nextParameter);
                    this.anteriores = new boolean[this.nClassifier][];
                    this.salidasAnteriores = new boolean[this.nClassifier][];
                }
            } else if (ensembleType.equalsIgnoreCase("DATABOOST-IM")) {
                this.prepareDSNeeded = true;
            } else if (ensembleType.equalsIgnoreCase("EASYENSEMBLE") || ensembleType.equalsIgnoreCase("BALANCECASCADE")) {
                this.prepareDSNeeded = true;
                Randomize.setSeed(Long.parseLong(classifier.parameters.getParameter(0)));
                this.nBags = Integer.parseInt(classifier.parameters.getParameter(nextParameter++));
                this.nBoostIterations = nClassifier;
                this.nClassifier = nClassifier * this.nBags;
                this.alfa = new double[this.nClassifier];
                if (ensembleType.equalsIgnoreCase("BALANCECASCADE")) {
                    this.teta = new double[this.nClassifier];
                }
                this.pairwiseKappa = new double[this.nClassifier * (this.nClassifier - 1) / 2];
                this.errorMeanAUC = new double[this.nClassifier * (this.nClassifier - 1) / 2];
                this.errorAUC = new double[this.nClassifier];
                this.outputs = new int[this.nClassifier][this.classifier.test.getnData()];
            }
        }
    }

    PredPair computeClassScores(double[] example) {
        double sum = 0.0;
        double confidence = 1.0;
        for (int t = 0; t < this.nClassifier; ++t) {
            if (this.alfa[t] != 0.0) {
                if (!(this.ensembleType.equalsIgnoreCase("ADAC2") || this.ensembleType.equalsIgnoreCase("ADABOOST") || this.ensembleType.equalsIgnoreCase("EASYENSEMBLE") || this.ensembleType.equalsIgnoreCase("BALANCECASCADE") || this.ensembleType.equalsIgnoreCase("ADABOOST.M1") || this.ensembleType.equalsIgnoreCase("DATABOOST-IM"))) {
                    confidence = this.classifier.obtainConfidence(t, example);
                }
                sum = this.classifier.obtainClass(t, example) == 0 ? (sum += confidence * this.alfa[t]) : (sum -= confidence * this.alfa[t]);
            }
            if (this.teta == null) continue;
            sum -= this.teta[t];
        }
        if (sum >= 0.0) {
            return new PredPair(this.originalDS.getOutputValue(0), sum);
        }
        return new PredPair(this.originalDS.getOutputValue(1), sum);
    }

    boolean nextIteration() {
        boolean fin = false;
        if (this.ensembleType.contains("ADA") || this.ensembleType.contains("BOOST") || this.ensembleType.contains("EASYENSEMBLE") || this.ensembleType.contains("BALANCECASCADE")) {
            fin = this.modifyWeights();
        } else if (this.ensembleType.contains("BAG")) {
            this.alfa[this.t] = 1.0;
        }
        if (this.ensembleType.contains("IIVOTES")) {
            this.alfa[this.t] = 1.0;
            double e_i = this.outOfBagEstimation(this.originalDS, this.predictions);
            System.out.println("OOB error before = " + this.e);
            System.out.println("OOB error = " + e_i);
            e_i = 0.75 * this.e + 0.25 * e_i;
            System.out.println("OOB error = " + e_i);
            if (e_i < this.e) {
                this.e = e_i;
            } else {
                fin = true;
                this.alfa[this.t] = 0.0;
            }
        }
        ++this.t;
        double total = this.classifier.classify(this.actualDS);
        System.out.println("Train err = " + total);
        if (1.0 - total < 0.001) {
            fin = true;
        }
        total = this.classifier.classify(this.originalDS);
        System.out.println("Train original err = " + total);
        total = this.classifier.classify(this.classifier.test);
        System.out.println("Test err = " + total);
        return fin;
    }

    void writeAUCError(String outputTst) {
        String cadena = "";
        for (int i = 0; i < this.pairwiseKappa.length; ++i) {
            cadena = cadena + this.pairwiseKappa[i] + ", " + this.errorMeanAUC[i] + "\n";
        }
        String sal = outputTst;
        sal.lastIndexOf("5-1.tst");
        sal = sal.substring(0, sal.length() - 7);
        Files.addToFile(sal + "_KappaError.txt", cadena);
        Files.writeFile(outputTst + "_KappaError", cadena);
    }

    double computeKappa(int[] v1, int[] v2) {
        int i;
        int[][] confusion = new int[2][2];
        double[] Tr = new double[2];
        double[] Tc = new double[2];
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                confusion[i][j] = 0;
            }
            Tc[i] = 0.0;
            Tr[i] = 0.0;
        }
        for (i = 0; i < v1.length; ++i) {
            int[] nArray = confusion[v1[i]];
            int n = v2[i];
            nArray[n] = nArray[n] + 1;
            int n2 = v1[i];
            Tr[n2] = Tr[n2] + 1.0;
            int n3 = v2[i];
            Tc[n3] = Tc[n3] + 1.0;
        }
        double sumDiagonales = 0.0;
        double sumTrTc = 0.0;
        for (int i2 = 0; i2 < 2; ++i2) {
            sumDiagonales += (double)confusion[i2][i2];
            sumTrTc += Tr[i2] * Tc[i2];
        }
        double solucion = ((double)v1.length * sumDiagonales - sumTrTc) / ((double)(v1.length * v1.length) - sumTrTc);
        if (Double.isNaN(solucion)) {
            solucion = 1.0;
        }
        return solucion;
    }

    private boolean[] adjustTheta(int bagNumber) {
        boolean[] aciertos = new boolean[this.originalDS.getnData()];
        double f = Math.pow((double)this.originalDS.numberInstances(this.minC) / (double)this.originalDS.numberInstances(this.majC), 1.0 / ((double)this.nBoostIterations - 1.0));
        Integer[] indexes = new Integer[this.originalDS.getnData()];
        final double[] outputs = new double[this.originalDS.getnData()];
        for (int i = 0; i < this.originalDS.getnData(); ++i) {
            double[] example = this.originalDS.getExample(i);
            double sum = 0.0;
            double confidence = 1.0;
            for (int t = bagNumber * this.nBoostIterations; t < (bagNumber + 1) * this.nBoostIterations; ++t) {
                if (this.alfa[t] == 0.0) continue;
                if (this.classifier.obtainClass(t, example) == 0) {
                    sum += confidence * this.alfa[t];
                    continue;
                }
                sum -= confidence * this.alfa[t];
            }
            outputs[i] = sum;
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(outputs[o2], outputs[o1]);
            }
        });
        double FPrate = this.fprate(outputs, 0.0, aciertos);
        System.out.println(f + " == " + FPrate);
        return aciertos;
    }

    double fprate(double[] outputs, double teta, boolean[] corrects) {
        double TP = 0.0;
        double FP = 0.0;
        double FN = 0.0;
        double TN = 0.0;
        for (int i = 0; i < this.originalDS.getnData(); ++i) {
            int c = outputs[i] - teta >= 0.0 ? 0 : 1;
            int cReal = this.originalDS.getOutputAsInteger(i);
            corrects[i] = c == cReal;
            if (c == cReal && cReal == this.majC) {
                TN += 1.0;
                continue;
            }
            if (c == cReal && cReal != this.majC) {
                TP += 1.0;
                continue;
            }
            if (c != cReal && cReal == this.majC) {
                FP += 1.0;
                continue;
            }
            FN += 1.0;
        }
        return FP / (FP + TN);
    }

    private void prepareDatasetEasyEnsembleBalanceCascade() {
        if (this.t % this.nBoostIterations == 0) {
            if (this.ensembleType.equalsIgnoreCase("BALANCECASCADE") && this.t > 0) {
                boolean[] correct = this.adjustTheta(this.t / this.nBoostIterations - 1);
                this.originalDS.deleteExamples(correct, this.selected, this.minC);
                this.nData = this.originalDS.getnData();
            }
            this.actualDS = new myDataset(this.originalDS);
            this.selected = this.actualDS.randomUnderSampling(this.originalDS, this.majC, 50);
            this.weights = new double[this.actualDS.size()];
            for (int i = 0; i < this.actualDS.size(); ++i) {
                this.weights[i] = 1.0 / (double)this.actualDS.size();
            }
        }
    }

    private void createConf(String filename) {
        String output = new String("algorithm = IS Methods\n");
        output = output + "inputData = \"training2.txt\" \"training2.txt\" \"tst.dat\"\noutputData = \"training.txt\" \"tstOutput.dat\"\n\nSeed = 564545456\nPopulation Size = 50\nNumber of Evaluations = 10000\nPercentage of Change in restart = 0.35\n0-1 in restart = 0.25\n0-1 in diverge = 0.25\nwrapper = k-NN\nNumber of Neighbors = 1\nDistance Function = Euclidean\nevMeasure = geometric mean\nmajSelection = majority_selection\nEBUS = EBUS\nP = 0.2\nhybrid = NO smote + eus\nkSMOTE = 5\nASMO = both\nbalance = YES\nsmoting = 1\n";
        Files.writeFile(filename, output);
    }

    private void prepareDatasetRUSBoost() {
        int i;
        if (this.ensembleType.equalsIgnoreCase("ERUSBOOST")) {
            Files.writeFile(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "training2.txt", this.originalDS.printDataSet());
            EUSCHCQstat m = null;
            this.createConf("EUB_M_GMConf.txt");
            EUSCHCQstat m2 = m = new EUSCHCQstat("EUB_M_GMConf.txt");
            m2.setAnteriores(this.anteriores);
            m2.setSalidasAnteriores(this.salidasAnteriores);
            ((Metodo)m).runAlgorithm();
            m.run();
            try {
                this.actualDS = new myDataset();
                this.actualDS.readClassificationSet(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "training.txt", false);
            }
            catch (IOException e) {
                System.err.println("There was a problem while reading the input preprocessed data-sets: " + e);
            }
            File f = new File(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "training.txt");
            File f2 = new File(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "training2.txt");
            f.delete();
            f2.delete();
            m2 = m;
            this.anteriores[this.t] = (boolean[])m2.getBest().clone();
            this.salidasAnteriores[this.t] = (boolean[])m2.getBestOutputs().clone();
            m = null;
            this.selected = new int[this.actualDS.getnData()];
            Arrays.fill(this.selected, -1);
            boolean[] aux = new boolean[this.originalDS.getnData()];
            Arrays.fill(aux, false);
            for (int i2 = 0; i2 < this.actualDS.getnData(); ++i2) {
                double[] ej1 = this.actualDS.getExample(i2);
                for (int j = 0; j < this.originalDS.getnData(); ++j) {
                    if (aux[j]) continue;
                    double[] ej2 = this.originalDS.getExample(j);
                    boolean fin = false;
                    for (int k = 0; k < ej1.length && !fin; ++k) {
                        if (ej1[k] == ej2[k]) continue;
                        fin = true;
                    }
                    if (fin) continue;
                    this.selected[i2] = j;
                    aux[j] = true;
                }
            }
        } else {
            this.actualDS = new myDataset(this.originalDS);
            this.selected = this.actualDS.randomUnderSampling(this.originalDS, this.majC, this.N);
        }
        this.weightsBackup = (double[])this.weights.clone();
        this.weights = new double[this.selected.length];
        double Z = 0.0;
        for (i = 0; i < this.selected.length; ++i) {
            this.weights[i] = this.selected[i] != -1 ? this.weightsBackup[this.selected[i]] : 1.0 / (double)this.actualDS.getnData();
            Z += this.weights[i];
        }
        i = 0;
        while (i < this.selected.length) {
            int n = i++;
            this.weights[n] = this.weights[n] / Z;
        }
    }

    private void prepareDatasetSMOTEBoost() {
        keel.Algorithms.ImbalancedClassification.Ensembles.Basic.Metodo preprocess;
        System.out.println("Applying Preprocessing...[" + this.t + "]");
        this.actualDS = null;
        if (this.ensembleType.contains("MSMOTE")) {
            this.originalDS.getIS().setAttributesAsNonStatic();
            preprocess = new MSMOTE(this.originalDS.getIS(), Math.round(Randomize.Randdouble(0.0, 1.2345678E7)), 3, this.nMin > 5 ? 5 : this.nMin, 0, true, this.N < 100 ? 1.0 : (double)this.N / 100.0, "HVDM");
            ((MSMOTE)preprocess).ejecutar();
            preprocess = null;
        } else {
            preprocess = new SMOTE(this.originalDS.getIS(), Math.round(Randomize.Randdouble(0.0, 1.2345678E7)), this.nMin > 5 ? 5 : this.nMin, 0, true, this.N < 100 ? 1.0 : (double)this.N / 100.0, "HVDM");
            ((SMOTE)preprocess).ejecutar();
            preprocess = null;
        }
        try {
            this.actualDS = new myDataset();
            this.actualDS.readClassificationSet(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra", false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input preprocessed data-sets: " + e);
        }
        File f = new File(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra");
        f.delete();
        this.weightsBackup = (double[])this.weights.clone();
        this.weights = new double[this.actualDS.getnData()];
        for (int i = 0; i < this.actualDS.getnData(); ++i) {
            this.weights[i] = i < this.nData ? this.weightsBackup[i] * (double)this.nData / (double)this.actualDS.getnData() : 1.0 / (double)this.actualDS.getnData();
        }
    }

    private void prepareDatasetSPIDER() {
        System.out.println("Applying Preprocessing...[" + this.t + "]");
        this.actualDS = null;
        boolean[] used = null;
        do {
            this.actualDS = new myDataset(this.originalDS);
            used = this.actualDS.importanceSampling(this.originalDS, this.originalDS.getnData() / 2, this.predictions, this.e);
        } while (this.actualDS.vacio());
        this.trainingSetsOOB.add((boolean[])used.clone());
        SPIDER preprocess = new SPIDER(this.actualDS.getIS(), 3, this.spiderType, "HVDM");
        preprocess.ejecutar();
        preprocess = null;
        this.actualDS.getIS().clearInstances();
        this.actualDS = null;
        try {
            this.actualDS = new myDataset();
            this.actualDS.readClassificationSet(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra", false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input preprocessed data-sets: " + e);
        }
        File f = new File(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra");
        f.delete();
    }

    private void prepareDatasetDataBoostIM() {
        int i;
        int i2;
        int j;
        System.out.println("Preparing Data-set for DataBoost-IM...");
        this.weightsBackup = (double[])this.weights.clone();
        if (this.t < 1) {
            return;
        }
        int Ns = 0;
        Integer[] indexes = new Integer[this.nData];
        for (int i3 = 0; i3 < this.nData; ++i3) {
            if (this.classifier.obtainClass(this.t - 1, this.originalDS.getExample(i3)) != this.originalDS.getOutputAsInteger(i3)) {
                ++Ns;
            }
            indexes[i3] = i3;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (Double.compare(Ensemble.this.weights[o2], Ensemble.this.weights[o1]) == 0) {
                    if (Ensemble.this.originalDS.getOutputAsInteger(o2) == Ensemble.this.minC) {
                        return 1;
                    }
                    if (Ensemble.this.originalDS.getOutputAsInteger(o1) == Ensemble.this.minC) {
                        return -1;
                    }
                    return 0;
                }
                return Double.compare(Ensemble.this.weights[o2], Ensemble.this.weights[o1]);
            }
        });
        int Nsmaj = 0;
        int Nsmin = 0;
        for (int i4 = 0; i4 < Ns; ++i4) {
            if (this.originalDS.getOutputAsInteger(indexes[i4]) == this.majC) {
                ++Nsmaj;
                continue;
            }
            ++Nsmin;
        }
        int Ml = Math.min(this.nMaj / this.nMin, Nsmaj);
        int Ms = Math.min(this.nMaj * Ml / this.nMin, Nsmin);
        this.originalDS.computeStatisticsPerClass();
        double[][] Xmaj = this.createSynteticData(this.majC, Ml, this.nMaj);
        double[][] Xmin = this.createSynteticData(this.minC, Ms, this.nMin);
        double[] weightsSeedsMaj = new double[Ml];
        double[] weightsSeedsMin = new double[Ms];
        int auxMl = 0;
        int auxMs = 0;
        for (int i5 = 0; i5 < Ns; ++i5) {
            if (this.originalDS.getOutputAsInteger(i5) == this.majC && auxMl < Ml) {
                weightsSeedsMaj[auxMl] = this.weights[indexes[i5]];
                ++auxMl;
                continue;
            }
            if (auxMs >= Ms) continue;
            weightsSeedsMin[auxMs] = this.weights[indexes[i5]];
            ++auxMs;
        }
        this.actualDS = new myDataset(this.originalDS, this.majC, Xmaj, this.minC, Xmin);
        int newNData = this.nData + Ml * this.nMaj + Ms * this.nMin;
        this.weightsBackup = (double[])this.weights.clone();
        this.weights = new double[newNData];
        int iAux = 0;
        int i6 = 0;
        while (i6 < this.nData) {
            this.weights[iAux] = this.weightsBackup[i6];
            ++i6;
            ++iAux;
        }
        for (i6 = this.nData; i6 < this.nData + Ml; ++i6) {
            j = 0;
            while (j < this.nMaj) {
                this.weights[iAux] = weightsSeedsMaj[i6 - this.nData] / (double)this.nMaj;
                ++j;
                ++iAux;
            }
        }
        for (i6 = this.nData + Ml; i6 < this.nData + Ml + Ms; ++i6) {
            j = 0;
            while (j < this.nMin) {
                this.weights[iAux] = weightsSeedsMin[i6 - this.nData - Ml] / (double)this.nMin;
                ++j;
                ++iAux;
            }
        }
        double Wmaj = 0.0;
        double Wmin = 0.0;
        for (i2 = 0; i2 < newNData; ++i2) {
            if (this.actualDS.getOutputAsInteger(i2) == this.majC) {
                Wmaj += this.weights[i2];
                continue;
            }
            Wmin += this.weights[i2];
        }
        if (Wmaj > Wmin) {
            for (i2 = 0; i2 < newNData; ++i2) {
                if (this.actualDS.getOutputAsInteger(i2) != this.minC) continue;
                int n = i2;
                this.weights[n] = this.weights[n] * (Wmaj / Wmin);
            }
        } else {
            for (i2 = 0; i2 < newNData; ++i2) {
                if (this.actualDS.getOutputAsInteger(i2) != this.majC) continue;
                int n = i2;
                this.weights[n] = this.weights[n] * (Wmin / Wmaj);
            }
        }
        double Z = 0.0;
        for (i = 0; i < newNData; ++i) {
            Z += this.weights[i];
        }
        i = 0;
        while (i < newNData) {
            int n = i++;
            this.weights[n] = this.weights[n] / Z;
        }
        System.out.println("Preparartion finished!");
    }

    private double[][] createSynteticData(int c, int nSets, int nExamples) {
        int i;
        int nInputs = this.originalDS.getnInputs();
        double[][] X = new double[nSets * nExamples][nInputs];
        if (nSets == 0) {
            return X;
        }
        int nNominal = 0;
        int nNumeric = 0;
        double[][] numeric = new double[nInputs][2];
        for (int i2 = 0; i2 < nInputs; ++i2) {
            if (this.originalDS.getTipo(i2) == 2 || this.originalDS.getTipo(i2) == 1) {
                ++nNominal;
                numeric[i2][0] = -1.0;
                numeric[i2][1] = -1.0;
                continue;
            }
            ++nNumeric;
            numeric[i2][0] = this.originalDS.getAveragePerClass()[c][i2];
            numeric[i2][1] = this.originalDS.getStdPerClass()[c][i2];
        }
        double[][] nominal = new double[nInputs][nExamples];
        int nAux = 0;
        for (i = 0; i < this.nData; ++i) {
            if (this.originalDS.getOutputAsInteger(i) != c) continue;
            for (int j = 0; j < nInputs; ++j) {
                if (numeric[j][0] != -1.0) continue;
                nominal[j][nAux] = this.originalDS.getExample(i)[j];
            }
            ++nAux;
        }
        for (i = 0; i < nSets; ++i) {
            for (int k = 0; k < nInputs; ++k) {
                if (numeric[k][0] == -1.0) {
                    int j;
                    double[] auxNominal = (double[])nominal[k].clone();
                    for (j = 0; j < nExamples; ++j) {
                        int r = Randomize.RandintClosed(j, nExamples - 1);
                        double aux = auxNominal[r];
                        auxNominal[r] = auxNominal[j];
                        auxNominal[j] = aux;
                    }
                    for (j = 0; j < nExamples; ++j) {
                        X[i * nExamples + j][k] = auxNominal[j];
                    }
                    continue;
                }
                for (int j = 0; j < nExamples; ++j) {
                    X[i * nExamples + j][k] = Randomize.RandGaussian() * numeric[k][1] + numeric[k][0];
                }
            }
        }
        return X;
    }

    private void nextBag() {
        File f;
        keel.Algorithms.ImbalancedClassification.Ensembles.Basic.Metodo preprocess;
        if (this.ensembleType.equalsIgnoreCase("BAGGING")) {
            this.actualDS = new myDataset(this.originalDS);
            this.actualDS.randomSampling(this.originalDS, this.majC, this.minC, this.nMaj, this.nMin);
        } else if (this.ensembleType.equalsIgnoreCase("UNDERBAGGING")) {
            this.actualDS = new myDataset(this.originalDS);
            this.actualDS.randomUnderSampling(this.originalDS, this.majC, 50);
        } else if (this.ensembleType.equalsIgnoreCase("UNDERBAGGING2")) {
            this.actualDS = new myDataset(this.originalDS);
            this.actualDS.randomSampling(this.originalDS, this.majC, this.minC, this.nMin, this.nMin);
        } else if (this.ensembleType.equalsIgnoreCase("OVERBAGGING")) {
            this.actualDS = new myDataset(this.originalDS);
            this.actualDS.randomUnderSampling(this.originalDS, this.minC, 50);
        } else if (this.ensembleType.equalsIgnoreCase("OVERBAGGING2")) {
            this.actualDS = new myDataset(this.originalDS);
            this.actualDS.randomSampling(this.originalDS, this.majC, this.minC, this.nMaj, this.nMaj);
        } else if (this.ensembleType.equalsIgnoreCase("UNDEROVERBAGGING")) {
            this.actualDS = new myDataset(this.originalDS);
            if (this.t + 1 > this.nClassifier / 10) {
                this.b += 10;
            }
            this.actualDS.randomSampling(this.originalDS, this.majC, this.minC, this.b);
        } else if (this.ensembleType.equalsIgnoreCase("SMOTEBAGGING")) {
            this.actualDS = new myDataset(this.originalDS);
            if (this.t + 1 > this.nClassifier / 10) {
                this.b += 10;
            }
            this.actualDS.randomSampling(this.originalDS, this.majC, this.minC, this.nMaj, this.b * this.nMaj / this.nMin);
            this.N = 50;
            System.out.println("Applying Preprocessing...[" + this.t + "]");
            preprocess = new SMOTE(this.actualDS.getIS(), Math.round(Randomize.Randdouble(0.0, 1.2345678E7)), this.nMin > 5 ? 5 : this.nMin, 0, true, this.N < 100 ? 1.0 : (double)this.N / 100.0, "HVDM");
            ((SMOTE)preprocess).ejecutar();
            try {
                this.actualDS = new myDataset();
                this.actualDS.readClassificationSet(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra", false);
            }
            catch (IOException e) {
                System.err.println("There was a problem while reading the input preprocessed data-sets: " + e);
            }
            f = new File(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra");
            f.delete();
        } else if (this.ensembleType.equalsIgnoreCase("MSMOTEBAGGING")) {
            this.actualDS = new myDataset(this.originalDS);
            if (this.t + 1 > this.nClassifier / 10) {
                this.b += 10;
            }
            this.actualDS.randomSampling(this.originalDS, this.majC, this.minC, this.nMaj, this.b * this.nMaj / this.nMin);
            this.N = 50;
            System.out.println("Applying Preprocessing...[" + this.t + "]");
            preprocess = new MSMOTE(this.actualDS.getIS(), Math.round(Randomize.Randdouble(0.0, 1.2345678E7)), 3, this.nMin > 5 ? 5 : this.nMin, 0, true, this.N < 100 ? 1.0 : (double)this.N / 100.0, "HVDM");
            ((MSMOTE)preprocess).ejecutar();
            preprocess = null;
            try {
                this.actualDS = new myDataset();
                this.actualDS.readClassificationSet(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra", false);
            }
            catch (IOException e) {
                System.err.println("There was a problem while reading the input preprocessed data-sets: " + e);
            }
            f = new File(multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra");
            f.delete();
        }
        this.weights = new double[this.actualDS.getnData()];
        for (int i = 0; i < this.actualDS.getnData(); ++i) {
            this.weights[i] = 1.0 / (double)this.actualDS.getnData();
        }
    }

    double[] getWeights() {
        if ((this.ensembleType.contains("ADA") || this.ensembleType.contains("BOOST") || this.ensembleType.contains("EASYENSEMBLE") || this.ensembleType.contains("BALANCECASCADE")) && !this.trainMethod.equalsIgnoreCase("RESAMPLING")) {
            return this.weights;
        }
        double[] uniformWeights = new double[this.actualDS.getnData()];
        for (int i = 0; i < uniformWeights.length; ++i) {
            uniformWeights[i] = 1.0 / (double)uniformWeights.length;
        }
        return uniformWeights;
    }

    void setCosts(double Cmaj, double Cmin) {
        this.CostMaj = Cmaj;
        this.CostMin = Cmin;
    }

    myDataset getDS() {
        if (this.prepareDSNeeded) {
            this.prepareDataset();
        }
        if (this.ensembleType.contains("BAG")) {
            this.nextBag();
        }
        return this.actualDS;
    }

    public void prepareDataset() {
        if (this.ensembleType.contains("RUSBOOST")) {
            this.prepareDatasetRUSBoost();
        } else if (this.ensembleType.contains("SMOTEBOOST")) {
            this.prepareDatasetSMOTEBoost();
        } else if (this.ensembleType.contains("IIVOTES")) {
            this.prepareDatasetSPIDER();
        } else if (this.ensembleType.contains("DATABOOST-IM")) {
            this.prepareDatasetDataBoostIM();
        } else if (this.ensembleType.contains("EASYENSEMBLE") || this.ensembleType.contains("BALANCECASCADE")) {
            this.prepareDatasetEasyEnsembleBalanceCascade();
        }
        if (this.resampling) {
            myDataset auxDS;
            this.actualDS = auxDS = new myDataset(this.actualDS, this.weights);
        }
    }

    private boolean modifyWeights() {
        if (this.ensembleType.equalsIgnoreCase("ADABOOST")) {
            return this.modifyWeightsAdaBoost();
        }
        if (this.ensembleType.equalsIgnoreCase("ADABOOST.M1")) {
            return this.modifyWeightsAdaBoostM1();
        }
        if (this.ensembleType.equalsIgnoreCase("ADABOOST.M2")) {
            return this.modifyWeightsAdaBoostM2();
        }
        if (this.ensembleType.equalsIgnoreCase("ADAC2")) {
            return this.modifyWeightsAdaC2();
        }
        if (this.ensembleType.contains("RUSBOOST") || this.ensembleType.contains("SMOTEBOOST")) {
            this.weights = (double[])this.weightsBackup.clone();
            return this.modifyWeightsAdaBoostM2();
        }
        if (this.ensembleType.equalsIgnoreCase("DATABOOST-IM")) {
            this.weights = (double[])this.weightsBackup.clone();
            return this.modifyWeightsAdaBoostM1();
        }
        if (this.ensembleType.equalsIgnoreCase("EASYENSEMBLE") || this.ensembleType.equalsIgnoreCase("BALANCECASCADE")) {
            return this.modifyWeightsAdaBoostActualDS();
        }
        if (this.ensembleType.equalsIgnoreCase("ADABOOST.NC")) {
            return this.modifyWeightsAdaBoostNC();
        }
        return false;
    }

    private boolean modifyWeightsAdaBoost() {
        int i;
        double[] corrects = new double[this.nData];
        double r = 0.0;
        double Z = 0.0;
        for (int i2 = 0; i2 < this.nData; ++i2) {
            corrects[i2] = this.classifier.obtainClass(this.t, this.originalDS.getExample(i2)) == this.originalDS.getOutputAsInteger(i2) ? 1.0 : -1.0;
            r += this.weights[i2] * corrects[i2];
        }
        double err = (1.0 - r) / 2.0;
        if (err < 0.001 || err >= 0.5) {
            if (this.t > 0 && err >= 0.5) {
                this.nClassifier = this.t--;
            } else {
                this.alfa[this.t] = 1.0;
            }
            return true;
        }
        this.alfa[this.t] = 0.5 * Math.log((1.0 + r) / (1.0 - r));
        for (i = 0; i < this.nData; ++i) {
            int n = i;
            this.weights[n] = this.weights[n] * Math.exp(-1.0 * this.alfa[this.t] * corrects[i]);
            Z += this.weights[i];
        }
        i = 0;
        while (i < this.nData) {
            int n = i++;
            this.weights[n] = this.weights[n] / Z;
        }
        return false;
    }

    private boolean modifyWeightsAdaBoostNC() {
        int i;
        int i2;
        double[] amb_t = new double[this.originalDS.getnData()];
        int[] Hts = new int[this.originalDS.getnData()];
        for (int j = 0; j < this.originalDS.getnData(); ++j) {
            Hts[j] = 0;
            double[] example = (double[])this.originalDS.getExample(j).clone();
            if (this.salidaEnsemble(example) != this.originalDS.getOutputAsInteger(j)) continue;
            Hts[j] = 1;
        }
        for (i2 = 0; i2 < this.t; ++i2) {
            for (int j = 0; j < this.originalDS.getnData(); ++j) {
                double[] example = (double[])this.originalDS.getExample(j).clone();
                int ht = 0;
                if (this.classifier.obtainClass(i2, example) == this.originalDS.getOutputAsInteger(j)) {
                    ht = 1;
                }
                int n = j;
                amb_t[n] = amb_t[n] + (double)Math.abs(Hts[j] - ht);
            }
        }
        if (this.t > 0) {
            i2 = 0;
            while (i2 < this.originalDS.getnData()) {
                int n = i2++;
                amb_t[n] = amb_t[n] / (double)this.t;
            }
        }
        double[] pow = new double[this.originalDS.getnData()];
        for (int i3 = 0; i3 < this.originalDS.getnData(); ++i3) {
            this.penalization[i3] = 1.0 - Math.abs(amb_t[i3]);
            pow[i3] = Math.pow(this.penalization[i3], this.lambda);
        }
        double sumatoriaPos = 0.0;
        double sumatoriaNeg = 0.0;
        for (int i4 = 0; i4 < this.originalDS.getnData(); ++i4) {
            double[] example = (double[])this.originalDS.getExample(i4).clone();
            if (this.classifier.obtainClass(this.t, example) == this.originalDS.getOutputAsInteger(i4)) {
                sumatoriaPos += this.weights[i4] * pow[i4];
                continue;
            }
            sumatoriaNeg += this.weights[i4] * pow[i4];
        }
        this.alfa[this.t] = 1.0;
        if (!(sumatoriaNeg > 0.0)) {
            return true;
        }
        this.alfa[this.t] = 0.5 * Math.log(sumatoriaPos / sumatoriaNeg);
        double max = 0.0;
        for (i = 0; i < this.originalDS.getnData(); ++i) {
            double[] example = (double[])this.originalDS.getExample(i).clone();
            double aux = this.weights[i];
            this.weights[i] = this.classifier.obtainClass(this.t, example) == this.originalDS.getOutputAsInteger(i) ? pow[i] * this.weights[i] * 1.0 / Math.pow(Math.E, this.alfa[this.t]) : Math.E * pow[i] * this.weights[i];
            if (!(this.weights[i] > max)) continue;
            max = this.weights[i];
        }
        i = 0;
        while (i < this.originalDS.getnData()) {
            int n = i++;
            this.weights[n] = this.weights[n] / max;
        }
        return false;
    }

    public int salidaEnsemble(double[] example) {
        int i;
        int clase = 0;
        double[] scores = new double[this.originalDS.getnClasses()];
        for (i = 0; i < this.t; ++i) {
            int n = this.classifier.obtainClass(i, example);
            scores[n] = scores[n] + this.alfa[i];
        }
        for (i = 1; i < this.originalDS.getnClasses(); ++i) {
            if (!(scores[i] > scores[clase])) continue;
            clase = i;
        }
        return clase;
    }

    private boolean modifyWeightsAdaBoostActualDS() {
        int i;
        double[] corrects = new double[this.actualDS.getnData()];
        double r = 0.0;
        double Z = 0.0;
        double sumFail = 0.0;
        for (i = 0; i < this.actualDS.getnData(); ++i) {
            if (this.classifier.obtainClass(this.t, this.actualDS.getExample(i)) == this.actualDS.getOutputAsInteger(i)) {
                corrects[i] = 1.0;
            } else {
                corrects[i] = -1.0;
                sumFail += this.weights[i];
            }
            r += this.weights[i] * corrects[i];
        }
        if (sumFail < 0.001 || sumFail >= 0.5) {
            if (sumFail < 0.5) {
                this.alfa[this.t] = 1.0;
            }
            this.t = (this.t / this.nBoostIterations + 1) * this.nBoostIterations - 1;
            return this.t / this.nBoostIterations >= this.nBags - 1;
        }
        this.alfa[this.t] = 0.5 * Math.log((1.0 - sumFail) / sumFail);
        for (i = 0; i < this.actualDS.getnData(); ++i) {
            int n = i;
            this.weights[n] = this.weights[n] * Math.exp(-1.0 * this.alfa[this.t] * corrects[i]);
            Z += this.weights[i];
        }
        i = 0;
        while (i < this.actualDS.getnData()) {
            int n = i++;
            this.weights[n] = this.weights[n] / Z;
        }
        return false;
    }

    private boolean modifyWeightsAdaBoostM1() {
        int i;
        double[] corrects = new double[this.nData];
        double Z = 0.0;
        double sumFail = 0.0;
        for (int i2 = 0; i2 < this.nData; ++i2) {
            if (this.classifier.obtainClass(this.t, this.originalDS.getExample(i2)) != this.originalDS.getOutputAsInteger(i2)) {
                corrects[i2] = -1.0;
                sumFail += this.weights[i2];
                continue;
            }
            corrects[i2] = 1.0;
        }
        if (sumFail < 0.001 || sumFail >= 0.5) {
            if (this.t > 0 && sumFail > 0.5) {
                this.nClassifier = this.t--;
            } else {
                this.alfa[this.t] = 1.0;
            }
            return true;
        }
        double beta = sumFail / (1.0 - sumFail);
        for (i = 0; i < this.nData; ++i) {
            if (corrects[i] == 1.0) {
                int n = i;
                this.weights[n] = this.weights[n] * beta;
            }
            Z += this.weights[i];
        }
        i = 0;
        while (i < this.nData) {
            int n = i++;
            this.weights[n] = this.weights[n] / Z;
        }
        this.alfa[this.t] = Math.log(1.0 / beta);
        return false;
    }

    private boolean modifyWeightsAdaBoostM2() {
        int i;
        double[] corrects = new double[this.nData];
        double[] confianza = new double[this.nData];
        double Z = 0.0;
        double sumFail = 0.0;
        for (int i2 = 0; i2 < this.nData; ++i2) {
            confianza[i2] = this.classifier.obtainConfidence(this.t, this.originalDS.getExample(i2));
            if (this.classifier.obtainClass(this.t, this.originalDS.getExample(i2)) != this.originalDS.getOutputAsInteger(i2)) {
                corrects[i2] = -1.0;
                sumFail += 2.0 * this.weights[i2] * confianza[i2];
                continue;
            }
            corrects[i2] = 1.0;
            sumFail += this.weights[i2] * (2.0 - 2.0 * confianza[i2]);
        }
        double beta = (sumFail *= 0.5) / (1.0 - sumFail);
        for (i = 0; i < this.nData; ++i) {
            if (corrects[i] == 1.0) {
                int n = i;
                this.weights[n] = this.weights[n] * Math.pow(beta, confianza[i]);
            } else {
                int n = i;
                this.weights[n] = this.weights[n] * Math.pow(beta, 1.0 - confianza[i]);
            }
            Z += this.weights[i];
        }
        i = 0;
        while (i < this.nData) {
            int n = i++;
            this.weights[n] = this.weights[n] / Z;
        }
        this.alfa[this.t] = Math.log(1.0 / beta);
        return false;
    }

    private boolean modifyWeightsAdaC2() {
        int i;
        double[] corrects = new double[this.nData];
        double[] C = new double[this.nData];
        double sumFail = 0.0;
        double sumCorrect = 0.0;
        double Z = 0.0;
        for (i = 0; i < this.nData; ++i) {
            double d = C[i] = this.majC == this.actualDS.getOutputAsInteger(i) ? this.CostMaj : this.CostMin;
            if (this.classifier.obtainClass(this.t, this.originalDS.getExample(i)) == this.originalDS.getOutputAsInteger(i)) {
                corrects[i] = 1.0;
                sumCorrect += C[i] * this.weights[i];
                continue;
            }
            corrects[i] = -1.0;
            sumFail += C[i] * this.weights[i];
        }
        if (sumFail < 0.001 || sumFail >= sumCorrect) {
            if (this.t > 0 && sumFail >= sumCorrect) {
                --this.t;
                this.nClassifier = this.t;
            } else {
                this.alfa[this.t] = 1.0;
            }
            return true;
        }
        this.alfa[this.t] = 0.5 * Math.log(sumCorrect / sumFail);
        for (i = 0; i < this.nData; ++i) {
            int n = i;
            this.weights[n] = this.weights[n] * (Math.exp(-1.0 * this.alfa[this.t] * corrects[i]) * C[i]);
            Z += this.weights[i];
        }
        i = 0;
        while (i < this.nData) {
            int n = i++;
            this.weights[n] = this.weights[n] / Z;
        }
        return false;
    }

    private double outOfBagEstimation(myDataset originalDS, boolean[] predictions) {
        double total = 0.0;
        double TP = 0.0;
        double FP = 0.0;
        double FN = 0.0;
        double TN = 0.0;
        for (int i = 0; i < originalDS.getnData(); ++i) {
            boolean counted = false;
            double[] example = originalDS.getExample(i);
            double sum = 0.0;
            double confidence = 1.0;
            for (int t = 0; t < this.nClassifier; ++t) {
                if (this.alfa[t] == 0.0 || this.trainingSetsOOB.get(t)[i]) continue;
                if (!counted) {
                    total += 1.0;
                    counted = true;
                }
                confidence = this.classifier.obtainConfidence(t, example);
                if (this.classifier.obtainClass(t, example) == 0) {
                    sum += confidence * this.alfa[t];
                    continue;
                }
                sum -= confidence * this.alfa[t];
            }
            int output = -1;
            if (sum >= 0.0) {
                output = 0;
            } else if (sum < 0.0) {
                output = 1;
            }
            int claseReal = originalDS.getOutputAsInteger(i);
            predictions[i] = output == claseReal && counted;
            if (!counted) continue;
            if (claseReal == output && this.majC == output) {
                TN += 1.0;
                continue;
            }
            if (claseReal == output && this.majC != output) {
                TP += 1.0;
                continue;
            }
            if (claseReal != output && this.majC == output) {
                FP += 1.0;
                continue;
            }
            FN += 1.0;
        }
        double TPrate = TP / (TP + FN);
        double TNrate = TN / (TN + FP);
        double gmean = Math.sqrt(TPrate * TNrate);
        double acc = (TN + TP) / (TN + TP + FN + FP);
        return 1.0 - acc;
    }
}

