/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.realarray;

import net.sf.jclec.IConfigure;
import net.sf.jclec.realarray.RealArrayIndividual;
import net.sf.jclec.realarray.RealArrayMutator;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniformMutator<I extends RealArrayIndividual>
extends RealArrayMutator<I>
implements IConfigure {
    protected double locusMutProb;

    public double getLocusMutProb() {
        return this.locusMutProb;
    }

    public void setLocusMutProb(double locusMutProb) {
        this.locusMutProb = locusMutProb;
    }

    @Override
    public void configure(Configuration settings) {
        double locusMutProb = settings.getDouble("[@locus-mut-prob]", this.defaultLocusMutProb());
        this.setLocusMutProb(locusMutProb);
    }

    @Override
    protected void mutateNext() {
        RealArrayIndividual ind = (RealArrayIndividual)this.parentsBuffer.get(this.parentsCounter);
        double[] parentChromosome = (double[])ind.getGenotype();
        double[] mutantChromosome = new double[this.genotypeLength];
        int i = 0;
        while (i < this.genotypeLength) {
            if (this.randgen.coin(this.locusMutProb)) {
                this.doLocusMutation(parentChromosome, mutantChromosome, i);
            } else {
                mutantChromosome[i] = parentChromosome[i];
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(mutantChromosome));
    }

    protected abstract void doLocusMutation(double[] var1, double[] var2, int var3);

    protected abstract double defaultLocusMutProb();
}

