## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ------------------------------------------------------------------------
library(SAFEPG)
set.seed(1)
n <- 100  # Number of observations
p <- 5    # Number of predictors

# Simulating data
x <- matrix(rnorm(n * p), nrow = n, ncol = p)
beta_true <- rep(0.1, 5)
gamma_true <- c(rep(1, 3), -1, -1)
mu <- x %*% beta_true
k <- rpois(n, lambda = exp(mu))
alpha_val <- 1
theta <- exp(x %*% gamma_true) / alpha_val
y <- rgamma(n, shape = alpha_val, scale = theta)

# Fit the model
lambda_val <- 1
fit <- safe(x, y, k, lambda = lambda_val, ind_p = c(1, 1, 1, 0, 0))

## ------------------------------------------------------------------------
lambda_seq <- 10^seq(2, -8, length.out = 5)  # Lambda sequence
cv.fit <- eccv.safe(x, y, k, lambda = lambda_seq, ind_p = c(1, 1, 1, 0, 0))

## ------------------------------------------------------------------------
# Extract coefficients from the fitted model
coef(fit)

# Make predictions on new data
set.seed(234)
newx <- matrix(rnorm(n * p), nrow = n, ncol = p)
predictions <- predict(fit, newx)

