/*
 * Decompiled with CFR 0.152.
 */
package AlgorithmTesting;

import AlgorithmTesting.DataSetupForCSVFile;
import bartMachine.Classifier;
import bartMachine.bartMachineClassificationMultThread;
import bartMachine.bartMachineRegressionMultThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DataAnalysis {
    private static final String DataSetFilename = "r_simple";

    public static void main(String[] stringArray) throws IOException {
        Object object;
        long l;
        System.out.println("java ver: " + System.getProperty("java.version"));
        DataSetupForCSVFile dataSetupForCSVFile = new DataSetupForCSVFile(new File("datasets", "r_simple.csv"), true);
        bartMachineRegressionMultThread bartMachineRegressionMultThread2 = null;
        if (DataSetFilename.charAt(0) == 'c') {
            bartMachineRegressionMultThread2 = new bartMachineClassificationMultThread();
            l = System.currentTimeMillis();
            ((Classifier)bartMachineRegressionMultThread2).setData(dataSetupForCSVFile.getX_y());
            ((Classifier)bartMachineRegressionMultThread2).Build();
            System.out.println("errors: " + (int)bartMachineRegressionMultThread2.calculateInSampleLoss(Classifier.ErrorTypes.MISCLASSIFICATION, 4) + "/" + bartMachineRegressionMultThread2.getN() + "  (" + bartMachineRegressionMultThread2.calculateInSampleLoss(Classifier.ErrorTypes.MISCLASSIFICATION, 4) / (double)bartMachineRegressionMultThread2.getN() * 100.0 + "%)");
            long l2 = System.currentTimeMillis();
            System.out.println("Current Time:" + (l2 - l) / 1000L);
        } else {
            bartMachineRegressionMultThread2 = new bartMachineRegressionMultThread();
            ((Classifier)bartMachineRegressionMultThread2).setData(dataSetupForCSVFile.getX_y());
            ((Classifier)bartMachineRegressionMultThread2).Build();
            l = Math.round(bartMachineRegressionMultThread2.calculateInSampleLoss(Classifier.ErrorTypes.L2, 4));
            System.out.println("(in sample) L1 error: " + Math.round(bartMachineRegressionMultThread2.calculateInSampleLoss(Classifier.ErrorTypes.L1, 4)) + " L2 error: " + l + " rmse: " + Math.sqrt((double)l / (double)bartMachineRegressionMultThread2.getN()));
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream("bartMachine.bin"));
        objectOutputStream.writeObject(bartMachineRegressionMultThread2);
        objectOutputStream.close();
        bartMachineRegressionMultThread2 = null;
        System.out.println("serialized and now reopening bartmachine");
        try {
            object = new ObjectInputStream(new FileInputStream("bartMachine.bin"));
            bartMachineRegressionMultThread2 = new bartMachineRegressionMultThread();
            try {
                bartMachineRegressionMultThread2 = (bartMachineRegressionMultThread)((ObjectInputStream)object).readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            ((ObjectInputStream)object).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = new double[]{1.0};
        System.out.println(((Classifier)bartMachineRegressionMultThread2).Evaluate((double[])object));
    }
}

