/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import bartMachine.bartMachineTreeNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class TreeIllustration {
    private static final Color line_color = Color.WHITE;
    private static final int font_size = 12;
    private static final String font_family = "Arial";
    private static final int margin_in_px = 70;
    private static final double character_width_in_px = 4.2;
    private static final int length_in_px_per_half_split = 20;
    private static final int depth_in_px_per_split = 100;
    public static NumberFormat one_digit_format = NumberFormat.getInstance();
    public static NumberFormat two_digit_format = NumberFormat.getInstance();
    private bartMachineTreeNode root;
    private transient BufferedImage canvas;
    private int depth_in_num_splits;
    private transient HashMap<String, String> info;
    private static final int border_width = 1;

    public TreeIllustration(bartMachineTreeNode bartMachineTreeNode2, HashMap<String, String> hashMap) {
        this.root = bartMachineTreeNode2;
        this.info = hashMap;
        this.calculateBreadthAndDepthAndThickness();
        this.initializeCanvas();
        this.drawSplit(bartMachineTreeNode2, this.canvas.getWidth() / 2, 70);
        this.drawTitle(hashMap);
    }

    private BufferedImage cropCanvas() {
        int n;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (n = 0; n < this.canvas.getWidth(); ++n) {
            for (int i = 0; i < this.canvas.getHeight(); ++i) {
                if (this.canvas.getRGB(n, i) != line_color.getRGB()) continue;
                if (n > n3) {
                    n3 = n;
                }
                if (n >= n2) continue;
                n2 = n;
            }
        }
        n = n3 - n2 + 140;
        BufferedImage bufferedImage = new BufferedImage(n, this.canvas.getHeight(), 12);
        for (int i = n2; i <= n3; ++i) {
            for (int j = 0; j < this.canvas.getHeight(); ++j) {
                bufferedImage.setRGB(i - n2 + 70, j, this.canvas.getRGB(i, j));
            }
        }
        return bufferedImage;
    }

    private void drawTitle(HashMap<String, String> hashMap) {
        String string;
        int n;
        if (hashMap.get("num_iteration") == null) {
            n = (int)Math.round((double)this.canvas.getWidth() / 2.0 - (double)("prior".length() / 2) * 4.2);
            this.canvas.getGraphics().drawString("prior", n, 15);
        } else if (hashMap.get("num_acceptances") != null && hashMap.get("num_iteration") != null) {
            n = Integer.parseInt(hashMap.get("num_acceptances"));
            int n2 = Integer.parseInt(hashMap.get("num_iteration"));
            string = "acc: " + n + " iter: " + n2 + "  (" + Math.round((double)n / (double)n2 * 100.0) + "%)";
            int n3 = (int)Math.round((double)this.canvas.getWidth() / 2.0 - (double)(string.length() / 2) * 4.2);
            this.canvas.getGraphics().drawString(string, n3, 15);
            String string2 = hashMap.get("change_step") + " (" + hashMap.get("changed_node") + ")";
            n3 = (int)Math.round((double)this.canvas.getWidth() / 2.0 - (double)(string2.length() / 2) * 4.2);
            this.canvas.getGraphics().drawString(string2, n3, 30);
        }
        if (hashMap.get("tree_num") != null && hashMap.get("num_iteration") != null) {
            n = (int)Math.round((double)this.canvas.getWidth() / 2.0 - (double)("prior".length() / 2) * 4.2);
            String string3 = hashMap.get("num_iteration") == "0" ? "prior" : "i: " + hashMap.get("num_iteration");
            string = " t: " + hashMap.get("tree_num");
            String string4 = " lik: " + hashMap.get("likelihood");
            this.canvas.getGraphics().drawString(string3 + string + string4, n, 15);
        }
    }

    public static void DeletePreviousTreeIllustrations() {
        String[] stringArray;
        for (String string : stringArray = new File("/").list(new ImageFileFilter())) {
            new File(string).delete();
        }
    }

    private void saveImageFile(BufferedImage bufferedImage, HashMap<String, String> hashMap) {
        String string = "r" + hashMap.get("num_restart") + "_a" + (hashMap.get("num_acceptances") == null ? 0 : Integer.parseInt(hashMap.get("num_acceptances")));
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string + ".png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void initializeCanvas() {
        int n = 140 + 40 * (int)Math.pow(2.0, this.depth_in_num_splits) * 2;
        int n2 = 140 + this.depth_in_num_splits * 100;
        this.initializeCanvas(n, n2);
    }

    private void initializeCanvas(int n, int n2) {
        this.canvas = new BufferedImage(n, n2, 12);
        this.canvas.getGraphics().setFont(new Font(font_family, 0, 12));
        this.canvas.getGraphics().setColor(line_color);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (i >= 1 && j >= 1 && i < n - 1 && j < n2 - 1) continue;
                this.canvas.setRGB(i, j, Color.WHITE.getRGB());
            }
        }
    }

    private void drawSplit(bartMachineTreeNode bartMachineTreeNode2, int n, int n2) {
        Graphics graphics = this.canvas.getGraphics();
        if (bartMachineTreeNode2.isLeaf && bartMachineTreeNode2.y_pred != -1.7976931348623157E308) {
            String string = two_digit_format.format(bartMachineTreeNode2.prediction_untransformed());
            int n3 = (int)Math.round((double)n - (double)string.length() / 2.0 * 4.2);
            graphics.drawString(string + " (" + bartMachineTreeNode2.n_eta + ") ", n3, n2 + 16);
        } else if (bartMachineTreeNode2.splitAttributeM != -2147483647 && bartMachineTreeNode2.splitValue != -1.7976931348623157E308) {
            int n4 = bartMachineTreeNode2.splitAttributeM;
            double d = bartMachineTreeNode2.splitValue;
            String string = "X_" + (n4 + 1) + " < " + two_digit_format.format(d) + " (" + bartMachineTreeNode2.n_eta + ") " + two_digit_format.format(bartMachineTreeNode2.avg_response_untransformed());
            int n5 = (int)Math.round((double)n - (double)string.length() / 2.0 * 4.2);
            graphics.drawString(string, n5, n2 - 5);
            n5 = (int)Math.round((double)n - (double)bartMachineTreeNode2.stringID().length() / 2.0 * 4.2);
            graphics.drawString(bartMachineTreeNode2.stringID(), n5, n2 + 15);
            int n6 = 20 * (int)Math.pow(2.0, this.depth_in_num_splits - bartMachineTreeNode2.depth);
            graphics.drawLine(n, n2, n - n6, n2);
            graphics.drawLine(n - n6, n2, n - n6, n2 + 100);
            this.drawSplit(bartMachineTreeNode2.left, n - n6, n2 + 100);
            graphics.drawLine(n, n2, n + n6, n2);
            graphics.drawLine(n + n6, n2, n + n6, n2 + 100);
            this.drawSplit(bartMachineTreeNode2.right, n + n6, n2 + 100);
        }
    }

    private void calculateBreadthAndDepthAndThickness() {
        this.depth_in_num_splits = this.root.deepestNode();
    }

    public void WriteTitleAndSaveImage() {
        this.saveImageFile(this.cropCanvas(), this.info);
    }

    public BufferedImage getCanvas() {
        return this.canvas;
    }

    static {
        one_digit_format.setMaximumFractionDigits(1);
        one_digit_format.setGroupingUsed(false);
        two_digit_format.setMaximumFractionDigits(2);
        two_digit_format.setGroupingUsed(false);
    }

    public static class ImageFileFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File file, String string) {
            String[] stringArray = string.split("\\.");
            if (stringArray.length >= 2) {
                String string2 = stringArray[stringArray.length - 1].toLowerCase();
                return string2.equals("jpg") || string2.equals("tif") || string2.equals("tiff") || string2.equals("TIFF") || string2.equals("bmp") || string2.equals("png");
            }
            return false;
        }
    }
}

