/*
 * Decompiled with CFR 0.152.
 */
package org.jamesframework.core.search.algo;

import org.jamesframework.core.problems.Problem;
import org.jamesframework.core.problems.sol.Solution;
import org.jamesframework.core.search.SingleNeighbourhoodSearch;
import org.jamesframework.core.search.neigh.Move;
import org.jamesframework.core.search.neigh.Neighbourhood;

public class MetropolisSearch<SolutionType extends Solution>
extends SingleNeighbourhoodSearch<SolutionType> {
    private double temperature;

    public MetropolisSearch(Problem<SolutionType> problem, Neighbourhood<? super SolutionType> neighbourhood, double temperature) {
        this(null, problem, neighbourhood, temperature);
    }

    public MetropolisSearch(String name, Problem<SolutionType> problem, Neighbourhood<? super SolutionType> neighbourhood, double temperature) {
        super(name != null ? name : "MetropolisSearch", problem, neighbourhood);
        if (temperature <= 0.0) {
            throw new IllegalArgumentException("Temperature of Metropolis search should be strictly positive.");
        }
        this.temperature = temperature;
    }

    public void setTemperature(double temperature) {
        if (temperature <= 0.0) {
            throw new IllegalArgumentException("Temperature of Metropolis search should be strictly positive.");
        }
        this.temperature = temperature;
    }

    public double getTemperature() {
        return this.temperature;
    }

    @Override
    protected void searchStep() {
        Move move = this.getNeighbourhood().getRandomMove(this.getCurrentSolution(), this.getRandom());
        if (move != null) {
            if (this.validate(move).passed()) {
                if (this.isImprovement(move)) {
                    this.accept(move);
                } else {
                    double delta = this.computeDelta(this.evaluate(move), this.getCurrentSolutionEvaluation());
                    double r = this.getRandom().nextDouble();
                    if (Math.exp(delta / this.temperature) > r) {
                        this.accept(move);
                    } else {
                        this.reject(move);
                    }
                }
            } else {
                this.reject(move);
            }
        } else {
            this.stop();
        }
    }
}

