### Sub-options 1–3: Tests for each locus in each population

Three distinct tests are available, all concerned with the same null hypothesis (random union of gametes). The difference between them is the construction of the rejection zone. For the Probability test (sub-option 3), the probability of the observed sample is used to define the rejection zone, and the $P$-value of the test corresponds to the sum of the probabilities of all tables (with the same allelic counts) with the same or lower probability. This is the “exact HW test” of @Haldane54, @WeirbkII, @GuoT92 and others. When the alternative hypothesis of interest is heterozygote excess or deficiency, more powerful tests than the probability test can be used [@RoussetR95]. One of them, the score test\index{Hardy-Wein\-berg tests!score test} or $U$ test, is available here, either for heterozygote deficiency (sub-option 1) or heterozygote excess (sub-option 2). The multi-samples versions of these two tests are accessible through sub-options 4 or 5.

Two distinct algorithms are available: first, the complete enumeration method, as described by @LouisD87. This algorithm works for less than five alleles. As an exact $P$-value is calculated by complete enumeration, no standard error is computed. Second, a Markov chain (MC) algorithm to estimate without bias the exact $P$-value of this test [@GuoT92], and three parameters are needed to control this algorithm (see Section \@ref(algorithms-for-exact-tests)). These different values may be provided either at Genepop’s request, or through the `Dememorisation`, `BatchLength` and `BatchNumber` settings. Two results are provided for each test by the MC algorithm: the estimated $P$-value associated with the null hypothesis of HW equilibrium, and the standard error (S.E.) of this estimate.

For all tests concerned with sub-options 1-3, there are three possible cases. The number of distinct alleles at each locus in each sample is

- **no more than 4:** Genepop will give you the choice between the complete
    enumeration and the MC method. If you have less than 1000
    individuals per sample, the complete enumeration is recommended.
    Otherwise, the MC method could be much faster. But there are no
    general rules, results are highly variable, depending also on allele
    frequencies.

- **always 5 or more:** Genepop will automatically perform only the MC method.

- **sometimes higher than 4, sometimes not:** For cases where the number of alleles is 4 or lower,
    Genepop will give you the choice between both methods.
    For the other situations (5 alleles or more in some samples), the MC
    method will be automatically performed.

Whether one wants enumeration or MC methods to be performed can be specified at runtime, or otherwise by the `HWtests` setting\index{HWtests setting}, with options `HWtests=enumeration` and `HWtests=MCMC`. The default in the batch mode is `enumeration`.\index{Hardy-Wein\-berg tests}

### Output
Results are stored in a file named as follows


| sub-option   | Extension        |
| ------------ | -----------------|
| 1            | *yourdata*`.D`   |
| 2            | *yourdata*`.E`   |
| 3            | *yourdata*`.P`   |
| 4            | *yourdata*`.DG`  |
| 5            | *yourdata*`.EG`  |


where *yourdata* is (throughout this document) the name of the input file.

For each test, several values are indicated on the same line: (i) the $P$-value of the test (or “-” if no data were available, or only one allele was present, or two alleles were detected but one was represented by only one copy); (ii) the standard error (only if a MC method was used); (iii) two estimates of $F_\mathrm{IS}$, @WeirC84’s (1984) estimate (W&C), and @RobertsonH84’s (1984) estimate (R&H). The latter has a lower variance under the null hypothesis. Finally, the number of “steps” is given: for the complete enumeration algorithm this is the number of different genotypic matrices considered, and for the Markov chain algorithm the number of switches\index{Markov chain algorithms!switches} (change of genotypic matrice) performed.[^11]
