## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(dplyr)
library(meantables)

## -----------------------------------------------------------------------------
mtcars %>% 
  mean_table(mpg)

## -----------------------------------------------------------------------------
alpha <- 1 - .99
t <- 1 - alpha / 2

mtcars %>% 
  mean_table(mpg, t_prob = t)

## -----------------------------------------------------------------------------
mtcars %>% 
  mean_table(mpg, output = "all", digits = 5)

## -----------------------------------------------------------------------------
mtcars %>% 
  group_by(cyl) %>% 
  mean_table(mpg, output = "all", digits = 5)

