/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.proxy.client;

import com.qarks.util.proxy.common.InvocationResult;
import com.qarks.util.stream.CommunicationUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpInvocationHandler
implements InvocationHandler {
    private String server = null;
    private String mImplClassName = null;
    private boolean secure = false;
    private static SSLSocketFactory sslSocketFactory = null;

    private HttpInvocationHandler(Class clazz, String string, boolean bl) {
        this(HttpInvocationHandler.getClassName(clazz), string, bl);
    }

    private HttpInvocationHandler(String string, String string2, boolean bl) {
        this.server = string2;
        this.secure = bl;
        this.mImplClassName = string;
    }

    public static void setSSLFactory(SSLSocketFactory sSLSocketFactory) {
        sslSocketFactory = sSLSocketFactory;
    }

    public static <T> T getProxy(Class<T> clazz, String string, boolean bl) {
        HttpInvocationHandler httpInvocationHandler = new HttpInvocationHandler(clazz, string, bl);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)httpInvocationHandler);
    }

    public static <T> T getProxy(Class<T> clazz, String string, String string2, boolean bl) {
        HttpInvocationHandler httpInvocationHandler = new HttpInvocationHandler(string, string2, bl);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)httpInvocationHandler);
    }

    private static String getClassName(Class clazz) {
        String string = clazz.getName();
        int n = 0;
        n = string.lastIndexOf(".");
        if (n > -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        return this.remoteCall(this.mImplClassName, method, objectArray);
    }

    public static void applySSLSocketFactory(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpsURLConnection && sslSocketFactory != null) {
            ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(sslSocketFactory);
        }
    }

    public Object remoteCall(String string, Method method, Object[] objectArray) throws Throwable {
        Object object;
        block8: {
            object = null;
            Vector<Object[]> vector = new Vector<Object[]>();
            Class<?>[] classArray = method.getParameterTypes();
            vector.addElement(classArray);
            vector.addElement(objectArray);
            String string2 = this.secure ? "https://" : "http://";
            String string3 = string2 + this.server + "?" + "class" + "=" + string + "&" + "method" + "=" + method.getName();
            URL uRL = new URL(string3);
            URLConnection uRLConnection = CommunicationUtilities.connectToServer(uRL);
            int n = Integer.parseInt(System.getProperty("http.timeout.connect", "10000"));
            int n2 = Integer.parseInt(System.getProperty("http.timeout.read", "1800000"));
            uRLConnection.setConnectTimeout(n);
            uRLConnection.setReadTimeout(n2);
            HttpInvocationHandler.applySSLSocketFactory(uRLConnection);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
            objectOutputStream.writeObject(vector);
            ObjectInputStream objectInputStream = new ObjectInputStream(uRLConnection.getInputStream());
            try {
                object = objectInputStream.readObject();
                if (object instanceof InvocationResult) {
                    InvocationResult invocationResult = (InvocationResult)object;
                    switch (invocationResult.getType()) {
                        case EXCEPTION: {
                            throw invocationResult.getExceptionThrown();
                        }
                        case RETURN_PARAMETERS: {
                            Object[] objectArray2 = invocationResult.getReturnedParameters();
                            this.applyFieldsReturned(objectArray, objectArray2);
                        }
                        case CLASSIC_REMOTE_CALL: {
                            object = invocationResult.getReturnedResult();
                        }
                    }
                    break block8;
                }
                throw new IOException("unexpected invocation returned type");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
        }
        return object;
    }

    private void applyFieldsReturned(Object[] objectArray, Object[] objectArray2) throws IllegalArgumentException, IllegalAccessException {
        if (objectArray2 != null) {
            for (int i = 0; i < objectArray2.length; ++i) {
                if (objectArray2[i] == null) continue;
                Field[] fieldArray = objectArray[i].getClass().getDeclaredFields();
                Field[] fieldArray2 = objectArray2[i].getClass().getDeclaredFields();
                if (fieldArray == null) continue;
                for (int j = 0; j < fieldArray.length; ++j) {
                    int n;
                    Field field = fieldArray[j];
                    if (field.isEnumConstant() || ((n = field.getModifiers()) & 0x10) != 0) continue;
                    Field field2 = fieldArray2[j];
                    field.setAccessible(true);
                    field2.setAccessible(true);
                    field.set(objectArray[i], field2.get(objectArray2[i]));
                }
            }
        }
    }
}

