/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.association;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.association.PMMLAttributes;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="AssociationRule", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="AssociationRule")
@JsonPropertyOrder(value={"antecedent", "consequent", "support", "confidence", "lift", "leverage", "affinity", "id", "extensions"})
public class AssociationRule
extends Entity<String>
implements HasExtensions<AssociationRule> {
    @XmlAttribute(name="antecedent", required=true)
    @JsonProperty(value="antecedent")
    private String antecedent;
    @XmlAttribute(name="consequent", required=true)
    @JsonProperty(value="consequent")
    private String consequent;
    @XmlAttribute(name="support", required=true)
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @JsonProperty(value="support")
    private Number support;
    @XmlAttribute(name="confidence", required=true)
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @JsonProperty(value="confidence")
    private Number confidence;
    @XmlAttribute(name="lift")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="lift")
    private Number lift;
    @XmlAttribute(name="leverage")
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="leverage")
    @Added(value=Version.PMML_4_1)
    private Number leverage;
    @XmlAttribute(name="affinity")
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @JsonProperty(value="affinity")
    @Added(value=Version.PMML_4_1)
    private Number affinity;
    @XmlAttribute(name="id")
    @JsonProperty(value="id")
    private String id;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public AssociationRule() {
    }

    @ValueConstructor
    public AssociationRule(@Property(value="antecedent") String antecedent, @Property(value="consequent") String consequent, @Property(value="support") Number support, @Property(value="confidence") Number confidence) {
        this.antecedent = antecedent;
        this.consequent = consequent;
        this.support = support;
        this.confidence = confidence;
    }

    public String requireAntecedent() {
        if (this.antecedent == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ASSOCIATIONRULE_ANTECEDENT);
        }
        return this.antecedent;
    }

    public String getAntecedent() {
        return this.antecedent;
    }

    public AssociationRule setAntecedent(@Property(value="antecedent") String antecedent) {
        this.antecedent = antecedent;
        return this;
    }

    public String requireConsequent() {
        if (this.consequent == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ASSOCIATIONRULE_CONSEQUENT);
        }
        return this.consequent;
    }

    public String getConsequent() {
        return this.consequent;
    }

    public AssociationRule setConsequent(@Property(value="consequent") String consequent) {
        this.consequent = consequent;
        return this;
    }

    public Number requireSupport() {
        if (this.support == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ASSOCIATIONRULE_SUPPORT);
        }
        return this.support;
    }

    public Number getSupport() {
        return this.support;
    }

    public AssociationRule setSupport(@Property(value="support") Number support) {
        this.support = support;
        return this;
    }

    public Number requireConfidence() {
        if (this.confidence == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ASSOCIATIONRULE_CONFIDENCE);
        }
        return this.confidence;
    }

    public Number getConfidence() {
        return this.confidence;
    }

    public AssociationRule setConfidence(@Property(value="confidence") Number confidence) {
        this.confidence = confidence;
        return this;
    }

    public Number requireLift() {
        if (this.lift == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ASSOCIATIONRULE_LIFT);
        }
        return this.lift;
    }

    public Number getLift() {
        return this.lift;
    }

    public AssociationRule setLift(@Property(value="lift") Number lift) {
        this.lift = lift;
        return this;
    }

    public Number requireLeverage() {
        if (this.leverage == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ASSOCIATIONRULE_LEVERAGE);
        }
        return this.leverage;
    }

    public Number getLeverage() {
        return this.leverage;
    }

    public AssociationRule setLeverage(@Property(value="leverage") Number leverage) {
        this.leverage = leverage;
        return this;
    }

    public Number requireAffinity() {
        if (this.affinity == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ASSOCIATIONRULE_AFFINITY);
        }
        return this.affinity;
    }

    public Number getAffinity() {
        return this.affinity;
    }

    public AssociationRule setAffinity(@Property(value="affinity") Number affinity) {
        this.affinity = affinity;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public AssociationRule setId(@Property(value="id") String id) {
        this.id = id;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AssociationRule addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

