/*
 * Decompiled with CFR 0.152.
 */
package io.github.crew102.rapidrake.model;

import java.util.Arrays;
import java.util.List;
import opennlp.tools.stemmer.snowball.SnowballStemmer;

public class RakeParams {
    private final List<String> stopWords;
    private final List<String> stopPOS;
    private final int wordMinChar;
    private final boolean stem;
    private final String phraseDelims;
    private final SnowballStemmer.ALGORITHM stemmerLang;

    public RakeParams(String[] stopWords, String[] stopPOS, int wordMinChar, boolean stem, String phraseDelims, SnowballStemmer.ALGORITHM stemmerLang) {
        this.stopWords = Arrays.asList(stopWords);
        this.stopPOS = Arrays.asList(stopPOS);
        this.wordMinChar = wordMinChar;
        this.stem = stem;
        this.phraseDelims = phraseDelims;
        this.stemmerLang = stemmerLang;
    }

    public RakeParams(String[] stopWords, String[] stopPOS, int wordMinChar, boolean stem, String phraseDelims) {
        this.stopWords = Arrays.asList(stopWords);
        this.stopPOS = Arrays.asList(stopPOS);
        this.wordMinChar = wordMinChar;
        this.stem = stem;
        this.phraseDelims = phraseDelims;
        this.stemmerLang = SnowballStemmer.ALGORITHM.ENGLISH;
    }

    public List<String> getStopWords() {
        return this.stopWords;
    }

    public List<String> getStopPOS() {
        return this.stopPOS;
    }

    public int getWordMinChar() {
        return this.wordMinChar;
    }

    public boolean shouldStem() {
        return this.stem;
    }

    public String getPhraseDelims() {
        return this.phraseDelims;
    }

    public SnowballStemmer.ALGORITHM getStemmerLang() {
        return this.stemmerLang;
    }
}

