/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.ci;

import java.io.FileReader;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.ci.CISearchAlgorithm;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ICSSearchAlgorithm
extends CISearchAlgorithm {
    static final long serialVersionUID = -2510985917284798576L;
    private int m_nMaxCardinality = 2;

    String name(int iAttribute) {
        return this.m_instances.attribute(iAttribute).name();
    }

    int maxn() {
        return this.m_instances.numAttributes();
    }

    public void setMaxCardinality(int nMaxCardinality) {
        this.m_nMaxCardinality = nMaxCardinality;
    }

    public int getMaxCardinality() {
        return this.m_nMaxCardinality;
    }

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        this.m_BayesNet = bayesNet;
        this.m_instances = instances;
        boolean[][] edges = new boolean[this.maxn() + 1][];
        boolean[][] arrows = new boolean[this.maxn() + 1][];
        SeparationSet[][] sepsets = new SeparationSet[this.maxn() + 1][];
        int iNode = 0;
        while (iNode < this.maxn() + 1) {
            edges[iNode] = new boolean[this.maxn()];
            arrows[iNode] = new boolean[this.maxn()];
            sepsets[iNode] = new SeparationSet[this.maxn()];
            ++iNode;
        }
        this.calcDependencyGraph(edges, sepsets);
        this.calcVeeNodes(edges, arrows, sepsets);
        this.calcArcDirections(edges, arrows);
        iNode = 0;
        while (iNode < this.maxn()) {
            ParentSet oParentSet = this.m_BayesNet.getParentSet(iNode);
            while (oParentSet.getNrOfParents() > 0) {
                oParentSet.deleteLastParent(this.m_instances);
            }
            int iParent = 0;
            while (iParent < this.maxn()) {
                if (arrows[iParent][iNode]) {
                    oParentSet.addParent(iParent, this.m_instances);
                }
                ++iParent;
            }
            ++iNode;
        }
    }

    void calcDependencyGraph(boolean[][] edges, SeparationSet[][] sepsets) {
        int iNode1 = 0;
        while (iNode1 < this.maxn()) {
            int iNode2 = 0;
            while (iNode2 < this.maxn()) {
                edges[iNode1][iNode2] = true;
                ++iNode2;
            }
            ++iNode1;
        }
        iNode1 = 0;
        while (iNode1 < this.maxn()) {
            edges[iNode1][iNode1] = false;
            ++iNode1;
        }
        int iCardinality = 0;
        while (iCardinality <= this.getMaxCardinality()) {
            int iNode2;
            int iNode12 = 0;
            while (iNode12 <= this.maxn() - 2) {
                iNode2 = iNode12 + 1;
                while (iNode2 < this.maxn()) {
                    SeparationSet oSepSet;
                    if (edges[iNode12][iNode2] && (oSepSet = this.existsSepSet(iNode12, iNode2, iCardinality, edges)) != null) {
                        edges[iNode12][iNode2] = false;
                        edges[iNode2][iNode12] = false;
                        sepsets[iNode12][iNode2] = oSepSet;
                        sepsets[iNode2][iNode12] = oSepSet;
                        System.err.print("I(" + this.name(iNode12) + ", {");
                        int iNode3 = 0;
                        while (iNode3 < iCardinality) {
                            System.err.print(String.valueOf(this.name(oSepSet.m_set[iNode3])) + " ");
                            ++iNode3;
                        }
                        System.err.print("} ," + this.name(iNode2) + ")\n");
                    }
                    ++iNode2;
                }
                ++iNode12;
            }
            System.err.print(String.valueOf(iCardinality) + " ");
            iNode12 = 0;
            while (iNode12 < this.maxn()) {
                System.err.print(String.valueOf(this.name(iNode12)) + " ");
                ++iNode12;
            }
            System.err.print('\n');
            iNode12 = 0;
            while (iNode12 < this.maxn()) {
                iNode2 = 0;
                while (iNode2 < this.maxn()) {
                    if (edges[iNode12][iNode2]) {
                        System.err.print("X ");
                    } else {
                        System.err.print(". ");
                    }
                    ++iNode2;
                }
                System.err.print(String.valueOf(this.name(iNode12)) + " ");
                System.err.print('\n');
                ++iNode12;
            }
            ++iCardinality;
        }
    }

    SeparationSet existsSepSet(int iNode1, int iNode2, int nCardinality, boolean[][] edges) {
        int iNode3;
        SeparationSet Z = new SeparationSet();
        Z.m_set[nCardinality] = -1;
        if (nCardinality > 0) {
            Z.m_set[0] = this.next(-1, iNode1, iNode2, edges);
            iNode3 = 1;
            while (iNode3 < nCardinality) {
                Z.m_set[iNode3] = this.next(Z.m_set[iNode3 - 1], iNode1, iNode2, edges);
                ++iNode3;
            }
        }
        int iZ = nCardinality > 0 ? this.maxn() - Z.m_set[nCardinality - 1] - 1 : 0;
        block1: while (iZ >= 0) {
            if (this.isConditionalIndependent(iNode2, iNode1, Z.m_set, nCardinality)) {
                return Z;
            }
            if (nCardinality > 0) {
                Z.m_set[nCardinality - 1] = this.next(Z.m_set[nCardinality - 1], iNode1, iNode2, edges);
            }
            iZ = nCardinality - 1;
            while (iZ >= 0 && Z.m_set[iZ] >= this.maxn()) {
                iZ = nCardinality - 1;
                while (iZ >= 0 && Z.m_set[iZ] >= this.maxn()) {
                    --iZ;
                }
                if (iZ < 0) continue block1;
                Z.m_set[iZ] = this.next(Z.m_set[iZ], iNode1, iNode2, edges);
                iNode3 = iZ + 1;
                while (iNode3 < nCardinality) {
                    Z.m_set[iNode3] = this.next(Z.m_set[iNode3 - 1], iNode1, iNode2, edges);
                    ++iNode3;
                }
                iZ = nCardinality - 1;
            }
        }
        return null;
    }

    int next(int x, int iNode1, int iNode2, boolean[][] edges) {
        ++x;
        while (!(x >= this.maxn() || edges[iNode1][x] && edges[iNode2][x] && x != iNode2)) {
            ++x;
        }
        return x;
    }

    void calcVeeNodes(boolean[][] edges, boolean[][] arrows, SeparationSet[][] sepsets) {
        int iNode2;
        int iNode1 = 0;
        while (iNode1 < this.maxn()) {
            iNode2 = 0;
            while (iNode2 < this.maxn()) {
                arrows[iNode1][iNode2] = false;
                ++iNode2;
            }
            ++iNode1;
        }
        iNode1 = 0;
        while (iNode1 < this.maxn() - 1) {
            iNode2 = iNode1 + 1;
            while (iNode2 < this.maxn()) {
                if (!edges[iNode1][iNode2]) {
                    int iNode3 = 0;
                    while (iNode3 < this.maxn()) {
                        if ((iNode3 != iNode1 && iNode3 != iNode2 && edges[iNode1][iNode3] && edges[iNode2][iNode3]) & !sepsets[iNode1][iNode2].contains(iNode3)) {
                            arrows[iNode1][iNode3] = true;
                            arrows[iNode2][iNode3] = true;
                        }
                        ++iNode3;
                    }
                }
                ++iNode2;
            }
            ++iNode1;
        }
    }

    void calcArcDirections(boolean[][] edges, boolean[][] arrows) {
        boolean bFound;
        do {
            int m;
            int k;
            int j;
            bFound = false;
            int i = 0;
            while (i < this.maxn()) {
                j = 0;
                while (j < this.maxn()) {
                    if (i != j && arrows[i][j]) {
                        k = 0;
                        while (k < this.maxn()) {
                            if (i != k && j != k && edges[j][k] && !edges[i][k] && !arrows[j][k] && !arrows[k][j]) {
                                arrows[j][k] = true;
                                bFound = true;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.maxn()) {
                j = 0;
                while (j < this.maxn()) {
                    if (i != j && arrows[i][j]) {
                        k = 0;
                        while (k < this.maxn()) {
                            if (i != k && j != k && edges[i][k] && arrows[j][k] && !arrows[i][k] && !arrows[k][i]) {
                                arrows[i][k] = true;
                                bFound = true;
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.maxn()) {
                j = 0;
                while (j < this.maxn()) {
                    if (i != j && arrows[i][j]) {
                        k = 0;
                        while (k < this.maxn()) {
                            if (k != i && k != j && arrows[k][j] && !edges[k][i]) {
                                m = 0;
                                while (m < this.maxn()) {
                                    if (!(m == i || m == j || m == k || !edges[m][i] || arrows[m][i] || arrows[i][m] || !edges[m][j] || arrows[m][j] || arrows[j][m] || !edges[m][k] || arrows[m][k] || arrows[k][m])) {
                                        arrows[m][j] = true;
                                        bFound = true;
                                    }
                                    ++m;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.maxn()) {
                j = 0;
                while (j < this.maxn()) {
                    if (i != j && arrows[j][i]) {
                        k = 0;
                        while (k < this.maxn()) {
                            if (k != i && k != j && edges[k][j] && !arrows[k][j] && !arrows[j][k] && edges[k][i] && !arrows[k][i] && !arrows[i][k]) {
                                m = 0;
                                while (m < this.maxn()) {
                                    if (m != i && m != j && m != k && edges[m][i] && !arrows[m][i] && !arrows[i][m] && edges[m][k] && !arrows[m][k] && !arrows[k][m]) {
                                        arrows[i][m] = true;
                                        arrows[k][m] = true;
                                        bFound = true;
                                    }
                                    ++m;
                                }
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (bFound) continue;
            i = 0;
            while (!bFound && i < this.maxn()) {
                j = 0;
                while (!bFound && j < this.maxn()) {
                    if (edges[i][j] && !arrows[i][j] && !arrows[j][i]) {
                        arrows[i][j] = true;
                        bFound = true;
                    }
                    ++j;
                }
                ++i;
            }
        } while (bFound);
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tWhen determining whether an edge exists a search is performed \n\tfor a set Z that separates the nodes. MaxCardinality determines \n\tthe maximum size of the set Z. This greatly influences the \n\tlength of the search. (default 2)", "cardinality", 1, "-cardinality <num>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption("cardinality", options);
        if (tmpStr.length() != 0) {
            this.setMaxCardinality(Integer.parseInt(tmpStr));
        } else {
            this.setMaxCardinality(2);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-cardinality");
        result.add("" + this.getMaxCardinality());
        return result.toArray(new String[result.size()]);
    }

    public String maxCardinalityTipText() {
        return "When determining whether an edge exists a search is performed for a set Z that separates the nodes. MaxCardinality determines the maximum size of the set Z. This greatly influences the length of the search. Default value is 2.";
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses conditional independence tests to find a skeleton, finds V-nodes and applies a set of rules to find the directions of the remaining arrows.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] argv) {
        try {
            BayesNet b = new BayesNet();
            b.setSearchAlgorithm(new ICSSearchAlgorithm());
            Instances instances = new Instances(new FileReader("C:\\eclipse\\workspace\\weka\\data\\contact-lenses.arff"));
            instances.setClassIndex(instances.numAttributes() - 1);
            b.buildClassifier(instances);
            System.out.println(b.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class SeparationSet
    implements RevisionHandler {
        public int[] m_set;

        public SeparationSet() {
            this.m_set = new int[ICSSearchAlgorithm.this.getMaxCardinality() + 1];
        }

        public boolean contains(int nItem) {
            int iItem = 0;
            while (iItem < ICSSearchAlgorithm.this.getMaxCardinality() && this.m_set[iItem] != -1) {
                if (this.m_set[iItem] == nItem) {
                    return true;
                }
                ++iItem;
            }
            return false;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.8 $");
        }
    }
}

