/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.ClusterGenerator;
import moa.clusterers.KMeans;
import moa.clusterers.clustream.WithKmeans;
import moa.evaluation.CMM;
import moa.evaluation.EntropyCollection;
import moa.evaluation.F1;
import moa.evaluation.General;
import moa.evaluation.MeasureCollection;
import moa.evaluation.SSQ;
import moa.evaluation.Separation;
import moa.evaluation.SilhouetteCoefficient;
import moa.evaluation.StatisticalCollection;
import moa.gui.visualization.DataPoint;
import moa.streams.clustering.ClusterEvent;
import moa.streams.clustering.ClusterEventListener;
import moa.streams.clustering.ClusteringStream;
import moa.streams.clustering.RandomRBFGeneratorEvents;

public class BatchCmd
implements ClusterEventListener {
    private ArrayList<ClusterEvent> clusterEvents;
    private AbstractClusterer clusterer;
    private ClusteringStream stream;
    private MeasureCollection[] measures;
    private int totalInstances;
    public boolean useMicroGT = false;

    public BatchCmd(AbstractClusterer clusterer, ClusteringStream stream, MeasureCollection[] measures, int totalInstances) {
        this.clusterer = clusterer;
        this.stream = stream;
        this.totalInstances = totalInstances == -1 ? Integer.MAX_VALUE : totalInstances;
        this.measures = measures;
        if (stream instanceof RandomRBFGeneratorEvents) {
            ((RandomRBFGeneratorEvents)stream).addClusterChangeListener(this);
            this.clusterEvents = new ArrayList();
        } else {
            this.clusterEvents = null;
        }
        stream.prepareForUse();
        clusterer.prepareForUse();
    }

    private ArrayList<ClusterEvent> getEventList() {
        return this.clusterEvents;
    }

    private static ArrayList<Class> getMeasureSelection(boolean[] selection) {
        ArrayList<Class> mclasses = new ArrayList<Class>();
        if (selection[0]) {
            mclasses.add(General.class);
        }
        if (selection[1]) {
            mclasses.add(F1.class);
        }
        if (selection[2]) {
            mclasses.add(EntropyCollection.class);
        }
        if (selection[3]) {
            mclasses.add(CMM.class);
        }
        if (selection[4]) {
            mclasses.add(SSQ.class);
        }
        if (selection[5]) {
            mclasses.add(Separation.class);
        }
        if (selection[6]) {
            mclasses.add(SilhouetteCoefficient.class);
        }
        if (selection[7]) {
            mclasses.add(StatisticalCollection.class);
        }
        return mclasses;
    }

    public static void main(String[] args) {
        RandomRBFGeneratorEvents stream = new RandomRBFGeneratorEvents();
        WithKmeans clusterer = new WithKmeans();
        boolean[] measureCollection = new boolean[]{true, true, true, true, true, true, true, true};
        int amountInstances = 20000;
        String testfile = "d:\\data\\test.csv";
        BatchCmd.runBatch(stream, clusterer, measureCollection, amountInstances, testfile);
    }

    public static void runBatch(ClusteringStream stream, AbstractClusterer clusterer, boolean[] measureCollection, int amountInstances, String outputFile) {
        MeasureCollection[] measures = BatchCmd.getMeasures(BatchCmd.getMeasureSelection(measureCollection));
        BatchCmd batch = new BatchCmd(clusterer, stream, measures, amountInstances);
        batch.run();
        ArrayList<ClusterEvent> clusterEvents = batch.getEventList();
        int horizon = stream.decayHorizonOption.getValue();
        BatchCmd.exportCSV(outputFile, clusterEvents, measures, horizon);
    }

    public void run() {
        ArrayList<DataPoint> pointBuffer0 = new ArrayList<DataPoint>();
        int m_timestamp = 0;
        int decayHorizon = this.stream.getDecayHorizon();
        double decay_threshold = this.stream.getDecayThreshold();
        double decay_rate = -1.0 * Math.log(decay_threshold) / (double)decayHorizon;
        int counter = decayHorizon;
        while (m_timestamp < this.totalInstances && this.stream.hasMoreInstances()) {
            --counter;
            Instance next = (Instance)this.stream.nextInstance().getData();
            DataPoint point0 = new DataPoint(next, ++m_timestamp);
            pointBuffer0.add(point0);
            DenseInstance traininst0 = new DenseInstance(point0);
            if (this.clusterer instanceof ClusterGenerator) {
                traininst0.setDataset(point0.dataset());
            } else {
                traininst0.deleteAttributeAt(point0.classIndex());
            }
            this.clusterer.trainOnInstanceImpl(traininst0);
            if (counter > 0) continue;
            for (DataPoint p : pointBuffer0) {
                p.updateWeight(m_timestamp, decay_rate);
            }
            Clustering clustering0 = null;
            Clustering gtClustering0 = new Clustering(pointBuffer0);
            if (this.useMicroGT && this.stream instanceof RandomRBFGeneratorEvents) {
                gtClustering0 = ((RandomRBFGeneratorEvents)this.stream).getMicroClustering();
            }
            clustering0 = this.clusterer.getClusteringResult();
            if (this.clusterer.implementsMicroClusterer()) {
                if (this.clusterer instanceof ClusterGenerator && this.stream instanceof RandomRBFGeneratorEvents) {
                    ((ClusterGenerator)this.clusterer).setSourceClustering(((RandomRBFGeneratorEvents)this.stream).getMicroClustering());
                }
                Clustering microC = this.clusterer.getMicroClusteringResult();
                if (this.clusterer.evaluateMicroClusteringOption.isSet()) {
                    clustering0 = microC;
                } else if (clustering0 == null && microC != null) {
                    clustering0 = KMeans.gaussianMeans(gtClustering0, microC);
                }
            }
            for (int i = 0; i < this.measures.length; ++i) {
                try {
                    this.measures[i].evaluateClusteringPerformance(clustering0, gtClustering0, pointBuffer0);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            pointBuffer0.clear();
            counter = decayHorizon;
        }
    }

    private static MeasureCollection[] getMeasures(ArrayList<Class> measure_classes) {
        MeasureCollection[] measures = new MeasureCollection[measure_classes.size()];
        for (int i = 0; i < measure_classes.size(); ++i) {
            try {
                MeasureCollection m = (MeasureCollection)measure_classes.get(i).newInstance();
                for (int j = 0; j < m.getNumMeasures(); ++j) {
                    m.setEnabled(j, true);
                }
                measures[i] = m;
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger("Couldn't create Instance for " + measure_classes.get(i).getName());
                ex.printStackTrace();
            }
        }
        return measures;
    }

    @Override
    public void changeCluster(ClusterEvent e) {
        if (this.clusterEvents != null) {
            this.clusterEvents.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportCSV(String filepath, ArrayList<ClusterEvent> clusterEvents, MeasureCollection[] measures, int horizon) {
        try (PrintWriter out = null;){
            if (!filepath.endsWith(".csv")) {
                filepath = filepath + ".csv";
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(filepath)));
            String delimiter = ";";
            int numValues = 0;
            out.write("Nr" + delimiter);
            out.write("Event" + delimiter);
            for (int m = 0; m < 1; ++m) {
                for (int i = 0; i < measures.length; ++i) {
                    for (int j = 0; j < measures[i].getNumMeasures(); ++j) {
                        if (!measures[i].isEnabled(j)) continue;
                        out.write(measures[i].getName(j) + delimiter);
                        numValues = measures[i].getNumberOfValues(j);
                    }
                }
            }
            out.write("\n");
            Iterator<ClusterEvent> eventIt = null;
            ClusterEvent event = null;
            if (clusterEvents != null && clusterEvents.size() > 0) {
                eventIt = clusterEvents.iterator();
                event = eventIt.next();
            }
            for (int v = 0; v < numValues; ++v) {
                out.write(v + delimiter);
                if (event != null && event.getTimestamp() <= (long)((v + 1) * horizon)) {
                    out.write(event.getType() + delimiter);
                    event = eventIt != null && eventIt.hasNext() ? eventIt.next() : null;
                } else {
                    out.write(delimiter);
                }
                for (int m = 0; m < 1; ++m) {
                    for (int i = 0; i < measures.length; ++i) {
                        for (int j = 0; j < measures[i].getNumMeasures(); ++j) {
                            if (!measures[i].isEnabled(j)) continue;
                            out.write(measures[i].getValue(j, v) + delimiter);
                        }
                    }
                }
                out.write("\n");
            }
            out.close();
        }
    }
}

