/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.clustertab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import moa.evaluation.MeasureCollection;

public class ClusteringVisualEvalPanel
extends JPanel {
    private ArrayList<JLabel> names;
    private ArrayList<JLabel> values;
    private ArrayList<JRadioButton> radiobuttons;
    private MeasureCollection[] measures0;
    private MeasureCollection[] measures1;
    private ButtonGroup radioGroup;
    private JLabel labelDummy;
    private JLabel labelMeasure;
    private JLabel labelCurrent0;
    private JLabel labelMean0;
    private JPanel contentPanel;
    private JScrollPane scrollPane;

    public ClusteringVisualEvalPanel() {
        this.initComponents();
        this.radioGroup = new ButtonGroup();
    }

    public void setMeasures(MeasureCollection[] measures0, MeasureCollection[] measures1, ActionListener listener) {
        int i;
        this.measures0 = measures0;
        this.measures1 = measures1;
        this.names = new ArrayList();
        this.values = new ArrayList();
        this.radiobuttons = new ArrayList();
        for (int i2 = 0; i2 < measures0.length; ++i2) {
            for (int j = 0; j < measures0[i2].getNumMeasures(); ++j) {
                if (!measures0[i2].isEnabled(j)) continue;
                this.names.add(new JLabel(measures0[i2].getName(j)));
            }
        }
        this.setLayout(new GridBagLayout());
        this.radioGroup = new ButtonGroup();
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        for (i = 0; i < this.names.size(); ++i) {
            JRadioButton rb = new JRadioButton();
            rb.setActionCommand(Integer.toString(i));
            rb.addActionListener(listener);
            this.radiobuttons.add(rb);
            gb.gridy = i + 1;
            this.contentPanel.add((Component)rb, gb);
            this.radioGroup.add(rb);
        }
        this.radiobuttons.get(0).setSelected(true);
        gb = new GridBagConstraints();
        gb.gridx = 1;
        for (i = 0; i < this.names.size(); ++i) {
            this.names.get(i).setPreferredSize(new Dimension(40, 14));
            gb.anchor = 17;
            gb.insets = new Insets(4, 7, 4, 7);
            gb.gridy = i + 1;
            this.contentPanel.add((Component)this.names.get(i), gb);
        }
        int counter = 0;
        for (int i3 = 0; i3 < measures0.length; ++i3) {
            for (int j = 0; j < measures0[i3].getNumMeasures(); ++j) {
                if (!measures0[i3].isEnabled(j)) continue;
                for (int k = 0; k < 4; ++k) {
                    String tooltip = "";
                    Color color = Color.black;
                    switch (k) {
                        case 0: {
                            tooltip = "current value";
                            color = Color.red;
                            break;
                        }
                        case 1: {
                            tooltip = "current value";
                            color = Color.blue;
                            break;
                        }
                        case 2: {
                            tooltip = "mean";
                            color = Color.black;
                            break;
                        }
                        case 3: {
                            tooltip = "mean";
                            color = Color.black;
                        }
                    }
                    JLabel l = new JLabel("-");
                    l.setHorizontalAlignment(0);
                    l.setPreferredSize(new Dimension(50, 14));
                    l.setToolTipText(measures0[i3].getName(j) + " " + tooltip);
                    l.setForeground(color);
                    this.values.add(l);
                    gb = new GridBagConstraints();
                    gb.gridy = 1 + counter;
                    gb.gridx = 2 + k;
                    gb.weightx = 1.0;
                    this.contentPanel.add((Component)l, gb);
                }
                ++counter;
            }
        }
        gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = this.names.size() + 2;
        gb.gridwidth = 6;
        gb.weighty = 1.0;
        JLabel fill = new JLabel();
        this.contentPanel.add((Component)fill, gb);
        this.addLabels();
        this.contentPanel.setPreferredSize(new Dimension(250, this.names.size() * 22 + 20));
    }

    private void addLabels() {
        this.labelMeasure = new JLabel("Measure");
        this.labelCurrent0 = new JLabel("Current");
        this.labelMean0 = new JLabel("Mean");
        this.labelDummy = new JLabel();
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridy = 0;
        gb.gridx = 0;
        this.contentPanel.add((Component)this.labelDummy, gb);
        gb.gridx = 1;
        this.contentPanel.add((Component)this.labelMeasure, gb);
        gb = new GridBagConstraints();
        gb.gridy = 0;
        gb.gridx = 2;
        gb.gridwidth = 2;
        this.contentPanel.add((Component)this.labelCurrent0, gb);
        gb = new GridBagConstraints();
        gb.gridy = 0;
        gb.gridx = 4;
        gb.gridwidth = 2;
        this.contentPanel.add((Component)this.labelMean0, gb);
    }

    public void update() {
        int i;
        int counter;
        DecimalFormat d = new DecimalFormat("0.00");
        if (this.measures0 != null) {
            counter = 0;
            for (MeasureCollection m : this.measures0) {
                for (i = 0; i < m.getNumMeasures(); ++i) {
                    if (!m.isEnabled(i)) continue;
                    if (Double.isNaN(m.getLastValue(i))) {
                        this.values.get(counter * 4).setText("-");
                    } else {
                        this.values.get(counter * 4).setText(d.format(m.getLastValue(i)));
                    }
                    if (Double.isNaN(m.getMean(i))) {
                        this.values.get(counter * 4 + 2).setText("-");
                    } else {
                        this.values.get(counter * 4 + 2).setText(d.format(m.getMean(i)));
                    }
                    ++counter;
                }
            }
        }
        if (this.measures1 != null) {
            counter = 0;
            for (MeasureCollection m : this.measures1) {
                for (i = 0; i < m.getNumMeasures(); ++i) {
                    if (!m.isEnabled(i)) continue;
                    if (Double.isNaN(m.getLastValue(i))) {
                        this.values.get(counter * 4 + 1).setText("-");
                    } else {
                        this.values.get(counter * 4 + 1).setText(d.format(m.getLastValue(i)));
                    }
                    if (Double.isNaN(m.getMean(i))) {
                        this.values.get(counter * 4 + 3).setText("-");
                    } else {
                        this.values.get(counter * 4 + 3).setText(d.format(m.getMean(i)));
                    }
                    ++counter;
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.scrollPane.setPreferredSize(new Dimension(this.getWidth() - 20, this.getHeight() - 30));
        super.paintComponent(g);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.contentPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder("Values"));
        this.setPreferredSize(new Dimension(250, 115));
        this.setLayout(new GridBagLayout());
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setPreferredSize(new Dimension(270, 180));
        this.contentPanel.setPreferredSize(new Dimension(100, 105));
        this.contentPanel.setLayout(new GridBagLayout());
        this.scrollPane.setViewportView(this.contentPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
    }
}

