/*
 * Decompiled with CFR 0.152.
 */
package moa.recommender.rc.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import moa.recommender.rc.utils.Pair;

public abstract class Vector
implements Serializable {
    private static final long serialVersionUID = 2440314068879207731L;

    public abstract int size();

    public abstract void set(int var1, double var2);

    public abstract void remove(int var1);

    public abstract Double get(int var1);

    public abstract Iterator<Pair<Integer, Double>> iterator();

    public abstract Set<Integer> getIdxs();

    public double dotProduct(Vector vec) {
        if (this.size() > vec.size()) {
            return vec.dotProduct(this);
        }
        Iterator<Pair<Integer, Double>> it = this.iterator();
        double ret = 0.0;
        while (it.hasNext()) {
            Pair<Integer, Double> ind = it.next();
            Double val1 = ind.getSecond();
            Double val2 = vec.get(ind.getFirst());
            if (val2 == null) continue;
            ret += val1 * val2;
        }
        return ret;
    }

    public double norm() {
        Iterator<Pair<Integer, Double>> it = this.iterator();
        double ret = 0.0;
        while (it.hasNext()) {
            ret += Math.pow(it.next().getSecond(), 2.0);
        }
        return Math.sqrt(ret);
    }

    public abstract Vector copy();
}

