/*
 * Decompiled with CFR 0.152.
 */
package dr.app.checkpoint;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.markovchain.MarkovChain;
import dr.inference.markovchain.MarkovChainListener;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.state.Factory;
import dr.inference.state.StateLoader;
import dr.inference.state.StateLoaderSaver;
import dr.inference.state.StateSaverChainListener;
import dr.inference.state.TimedStateSaverChainListener;
import dr.math.MathUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class BeastCheckpointer
implements StateLoaderSaver {
    private static BeastCheckpointer single_instance = null;
    private static final boolean DEBUG = false;
    private static final boolean CHECK_LOAD_STATE = true;
    public static final String LOAD_STATE_FILE = "load.state.file";
    public static final String SAVE_STATE_FILE = "save.state.file";
    public static final String SAVE_STATE_AT = "save.state.at";
    public static final String SAVE_STATE_EVERY = "save.state.every";
    public static final String SAVE_STEM = "save.state.stem";
    public static final String SAVE_STATE_TIME = "save.state.time";
    public static final String FORCE_RESUME = "force.resume";
    public static final String CHECKPOINT_SEED = "checkpoint.seed";
    public static final String FULL_CHECKPOINT_PRECISION = "full.checkpoint.precision";
    private String loadStateFileName;
    private String saveStateFileName;
    private String stemFileName;
    private boolean forceResume = false;
    private boolean useFullPrecision;
    private final List<MarkovChainListener> listeners = new ArrayList<MarkovChainListener>();

    public static synchronized BeastCheckpointer getInstance(String string, int n, int n2, boolean bl) {
        if (single_instance == null) {
            single_instance = new BeastCheckpointer(string, n, n2, bl);
        }
        return single_instance;
    }

    private BeastCheckpointer(String string, int n, int n2, boolean bl) {
        if (string == null && n == -1 && n2 == -1) {
            long l;
            this.loadStateFileName = System.getProperty(LOAD_STATE_FILE, null);
            this.saveStateFileName = System.getProperty(SAVE_STATE_FILE, null);
            this.stemFileName = System.getProperty(SAVE_STEM, null);
            if (System.getProperty(SAVE_STATE_AT) != null) {
                l = Long.parseLong(System.getProperty(SAVE_STATE_AT));
                this.listeners.add(new StateSaverChainListener(this, l, false));
            }
            if (System.getProperty(SAVE_STATE_EVERY) != null) {
                l = Long.parseLong(System.getProperty(SAVE_STATE_EVERY));
                this.listeners.add(new StateSaverChainListener(this, l, true));
            }
        } else {
            this.loadStateFileName = null;
            this.saveStateFileName = string;
            this.stemFileName = null;
            this.listeners.add(new StateSaverChainListener(this, n2, false));
            this.listeners.add(new StateSaverChainListener(this, n, true));
        }
        if (System.getProperty(SAVE_STATE_TIME) != null) {
            LocalTime localTime = LocalTime.parse(System.getProperty(SAVE_STATE_TIME), DateTimeFormatter.ofPattern("HH:mm:ss"));
            int n3 = localTime.toSecondOfDay();
            this.listeners.add(new TimedStateSaverChainListener(this, n3));
        }
        this.useFullPrecision = System.getProperty(FULL_CHECKPOINT_PRECISION) != null && System.getProperty(FULL_CHECKPOINT_PRECISION).equalsIgnoreCase("true");
        Factory.INSTANCE = new Factory(){

            @Override
            public StateLoader getInitialStateLoader() {
                if (BeastCheckpointer.this.loadStateFileName == null) {
                    return null;
                }
                return BeastCheckpointer.this.getStateLoaderObject();
            }

            @Override
            public MarkovChainListener[] getStateSaverChainListeners() {
                return BeastCheckpointer.this.listeners.toArray(new MarkovChainListener[0]);
            }

            @Override
            public StateLoaderSaver getStateLoaderSaver(final File file, final File file2) {
                return new StateLoaderSaver(){

                    @Override
                    public boolean saveState(MarkovChain markovChain, long l, double d) {
                        return BeastCheckpointer.this.writeStateToFile(file2, l, d, markovChain);
                    }

                    @Override
                    public long loadState(MarkovChain markovChain, double[] dArray) {
                        return BeastCheckpointer.this.readStateFromFile(file, markovChain, dArray);
                    }

                    @Override
                    public void checkLoadState(double d, double d2) {
                    }
                };
            }
        };
    }

    protected BeastCheckpointer() {
    }

    private BeastCheckpointer getStateLoaderObject() {
        return this;
    }

    @Override
    public boolean saveState(MarkovChain markovChain, long l, double d) {
        String string = "";
        if (this.stemFileName != null) {
            string = this.stemFileName + "_" + l;
        } else {
            String string2 = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(Calendar.getInstance().getTime());
            string = this.saveStateFileName != null ? this.saveStateFileName : "beast_state_" + string2;
        }
        return this.writeStateToFile(new File(string), l, d, markovChain);
    }

    @Override
    public long loadState(MarkovChain markovChain, double[] dArray) {
        return this.readStateFromFile(new File(this.loadStateFileName), markovChain, dArray);
    }

    @Override
    public void checkLoadState(double d, double d2) {
        if (System.getProperty(FORCE_RESUME) != null) {
            this.forceResume = Boolean.parseBoolean(System.getProperty(FORCE_RESUME));
        }
        if (this.forceResume) {
            System.out.println("Forcing analysis to resume regardless of recomputed likelihood values (" + d2 + " vs. " + d + ").");
        } else if (d2 != d) {
            System.out.println("COMPARING LIKELIHOODS: " + d2 + " vs. " + d);
            String string = Double.toString(d);
            String string2 = Double.toString(d2);
            System.out.println(d2 + "    " + string);
            System.out.println(d + "    " + string2);
            int n = 0;
            for (int i = 0; i < Math.min(string.length(), string2.length()) && string.charAt(i) == string2.charAt(i); ++i) {
                if (string.charAt(i) == '-' || string.charAt(i) == '.') continue;
                ++n;
            }
            if (n < 15) {
                double d3 = 1.0E-10;
                if (System.getProperty("mcmc.evaluation.threshold") != null) {
                    d3 = Double.parseDouble(System.getProperty("mcmc.evaluation.threshold"));
                }
                if (Math.abs(d2 - d) > d3) {
                    throw new RuntimeException("Saved lnL does not match recomputed value for loaded state: stored lnL: " + d + ", recomputed lnL: " + d2 + " (difference " + (d - d2) + ").\nYour XML may require the construction of a randomly generated starting tree. Try resuming the analysis by using the same starting seed as for the original BEAST run.");
                }
                System.out.println("Saved lnL does not match recomputed value for loaded state: stored lnL: " + d + ", recomputed lnL: " + d2 + " (difference " + (d - d2) + ").\nThreshold of " + d3 + " for restarting analysis not exceeded; continuing ...");
            }
        } else {
            System.out.println("IDENTICAL LIKELIHOODS");
            System.out.println("lnL = " + d2);
            System.out.println("savedLnL[0] = " + d);
        }
    }

    protected boolean writeStateToFile(File file, long l, double d, MarkovChain markovChain) {
        OperatorSchedule operatorSchedule = markovChain.getSchedule();
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = this.useFullPrecision ? new CheckpointPrintStream(fileOutputStream) : new PrintStream(fileOutputStream);
            ArrayList<TreeParameterModel> arrayList = new ArrayList<TreeParameterModel>();
            int[] nArray = MathUtils.getRandomState();
            printStream.print("rng");
            for (int i = 0; i < nArray.length; ++i) {
                printStream.print("\t");
                printStream.print(nArray[i]);
            }
            printStream.println();
            printStream.print("state\t");
            printStream.println(l);
            printStream.print("lnL\t");
            printStream.println(d);
            for (Parameter serializable : Parameter.CONNECTED_PARAMETER_SET) {
                if (serializable.isImmutable()) continue;
                printStream.print("parameter");
                printStream.print("\t");
                printStream.print(serializable.getParameterName());
                printStream.print("\t");
                printStream.print(serializable.getDimension());
                for (n = 0; n < serializable.getDimension(); ++n) {
                    printStream.print("\t");
                    printStream.print(serializable.getParameterUntransformedValue(n));
                }
                printStream.print("\n");
            }
            for (int i = 0; i < operatorSchedule.getOperatorCount(); ++i) {
                MCMCOperator mCMCOperator = operatorSchedule.getOperator(i);
                printStream.print("operator");
                printStream.print("\t");
                printStream.print(mCMCOperator.getOperatorName());
                printStream.print("\t");
                printStream.print(mCMCOperator.getAcceptCount());
                printStream.print("\t");
                printStream.print(mCMCOperator.getRejectCount());
                if (mCMCOperator instanceof AdaptableMCMCOperator) {
                    printStream.print("\t");
                    printStream.print(((AdaptableMCMCOperator)mCMCOperator).getAdaptableParameter());
                    printStream.print("\t");
                    printStream.print(((AdaptableMCMCOperator)mCMCOperator).getAdaptationCount());
                }
                printStream.println();
            }
            for (Model model : Model.CONNECTED_MODEL_SET) {
                if (!(model instanceof TreeParameterModel)) continue;
                arrayList.add((TreeParameterModel)model);
            }
            for (Model model : Model.CONNECTED_MODEL_SET) {
                int n2;
                if (!(model instanceof TreeModel)) continue;
                printStream.print("tree");
                printStream.print("\t");
                printStream.println(model.getModelName());
                printStream.println("#node height taxon");
                n = ((TreeModel)model).getNodeCount();
                printStream.println(n);
                for (n2 = 0; n2 < n; ++n2) {
                    printStream.print(((TreeModel)model).getNode(n2).getNumber());
                    printStream.print("\t");
                    printStream.print(((TreeModel)model).getNodeHeight(((TreeModel)model).getNode(n2)));
                    if (((TreeModel)model).isExternal(((TreeModel)model).getNode(n2))) {
                        printStream.print("\t");
                        printStream.print(((TreeModel)model).getNodeTaxon(((TreeModel)model).getNode(n2)).getId());
                    }
                    printStream.println();
                }
                printStream.println("#edges");
                printStream.println("#child-node parent-node L/R-child traits");
                printStream.println(n);
                for (n2 = 0; n2 < n; ++n2) {
                    NodeRef nodeRef = ((TreeModel)model).getParent(((TreeModel)model).getNode(n2));
                    if (nodeRef == null) continue;
                    printStream.print(((TreeModel)model).getNode(n2).getNumber());
                    printStream.print("\t");
                    printStream.print(((TreeModel)model).getParent(((TreeModel)model).getNode(n2)).getNumber());
                    printStream.print("\t");
                    if (((TreeModel)model).getChild(nodeRef, 0) == ((TreeModel)model).getNode(n2)) {
                        printStream.print(0);
                    } else if (((TreeModel)model).getChild(nodeRef, 1) == ((TreeModel)model).getNode(n2)) {
                        printStream.print(1);
                    } else {
                        throw new RuntimeException("Operation currently only supported for nodes with 2 children.");
                    }
                    for (TreeParameterModel treeParameterModel : arrayList) {
                        if (model != treeParameterModel.getTreeModel()) continue;
                        printStream.print("\t");
                        printStream.print(treeParameterModel.getNodeValue((TreeModel)model, ((TreeModel)model).getNode(n2)));
                    }
                    printStream.println();
                }
            }
            printStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("Unable to write file: " + iOException.getMessage());
            return false;
        }
        return true;
    }

    protected long readStateFromFile(File file, MarkovChain markovChain, double[] dArray) {
        DoubleParser doubleParser = this.useFullPrecision ? DoubleParser.HEX : DoubleParser.TEXT;
        OperatorSchedule operatorSchedule = markovChain.getSchedule();
        long l = -1L;
        ArrayList<TreeParameterModel> arrayList = new ArrayList<TreeParameterModel>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            int[] nArray = null;
            String string = bufferedReader.readLine();
            String[] stringArray = string.split("\t");
            if (stringArray[0].equals("rng")) {
                try {
                    nArray = new int[stringArray.length - 1];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = Integer.parseInt(stringArray[i + 1]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException("Unable to read state number from state file");
                }
                string = bufferedReader.readLine();
                stringArray = string.split("\t");
            }
            try {
                if (!stringArray[0].equals("state")) {
                    throw new RuntimeException("Unable to read state number from state file");
                }
                l = Long.parseLong(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Unable to read state number from state file");
            }
            string = bufferedReader.readLine();
            stringArray = string.split("\t");
            try {
                if (!stringArray[0].equals("lnL")) {
                    throw new RuntimeException("Unable to read lnL from state file");
                }
                if (dArray != null) {
                    dArray[0] = doubleParser.parseDouble(stringArray[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Unable to read lnL from state file");
            }
            for (Parameter serializable2 : Parameter.CONNECTED_PARAMETER_SET) {
                int stringBuilder;
                if (serializable2.isImmutable()) continue;
                string = bufferedReader.readLine();
                stringArray = string.split("\t");
                int n = Integer.parseInt(stringArray[2]);
                if (n != serializable2.getDimension()) {
                    System.err.println("Unable to match state parameter dimension: " + n + ", expecting " + serializable2.getDimension() + " for parameter: " + serializable2.getParameterName());
                    System.err.print("Read from file: ");
                    for (stringBuilder = 0; stringBuilder < stringArray.length; ++stringBuilder) {
                        System.err.print(stringArray[stringBuilder] + "\t");
                    }
                    System.err.println();
                }
                if (stringArray[1].equals("branchRates.categories.rootNodeNumber")) {
                    double d = doubleParser.parseDouble(stringArray[3]);
                    serializable2.setParameterValue(0, d);
                    continue;
                }
                for (stringBuilder = 0; stringBuilder < serializable2.getDimension(); ++stringBuilder) {
                    try {
                        serializable2.setParameterUntransformedValue(stringBuilder, doubleParser.parseDouble(stringArray[stringBuilder + 3]));
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println(runtimeException);
                    }
                }
            }
            for (int i = 0; i < operatorSchedule.getOperatorCount(); ++i) {
                MCMCOperator mCMCOperator = operatorSchedule.getOperator(i);
                string = bufferedReader.readLine();
                stringArray = string.split("\t");
                if (!stringArray[1].equals(mCMCOperator.getOperatorName())) {
                    throw new RuntimeException("Unable to match " + mCMCOperator.getOperatorName() + " operator: " + stringArray[1]);
                }
                if (stringArray.length < 4) {
                    throw new RuntimeException("Operator missing values: " + stringArray[1]);
                }
                mCMCOperator.setAcceptCount(Integer.parseInt(stringArray[2]));
                mCMCOperator.setRejectCount(Integer.parseInt(stringArray[3]));
                if (!(mCMCOperator instanceof AdaptableMCMCOperator)) continue;
                if (stringArray.length != 6) {
                    throw new RuntimeException("Coercable operator missing parameter: " + stringArray[1]);
                }
                ((AdaptableMCMCOperator)mCMCOperator).setAdaptableParameter(doubleParser.parseDouble(stringArray[4]));
                ((AdaptableMCMCOperator)mCMCOperator).setAdaptationCount(Long.parseLong(stringArray[5]));
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            ArrayList<TreeModel> arrayList2 = new ArrayList<TreeModel>();
            for (Model model : Model.CONNECTED_MODEL_SET) {
                if (model instanceof TreeModel) {
                    arrayList2.add((TreeModel)model);
                    linkedHashSet.add(model.getModelName());
                }
                if (!(model instanceof TreeParameterModel)) continue;
                arrayList.add((TreeParameterModel)model);
            }
            HashMap hashMap = new HashMap();
            for (String string2 : linkedHashSet) {
                ArrayList<TreeParameterModel> arrayList3 = new ArrayList<TreeParameterModel>();
                for (TreeParameterModel treeParameterModel : arrayList) {
                    if (!treeParameterModel.getTreeModel().getId().equals(string2)) continue;
                    arrayList3.add(treeParameterModel);
                }
                hashMap.put(string2, arrayList3);
            }
            string = bufferedReader.readLine();
            stringArray = string.split("\t");
            while (stringArray[0].equals("tree")) {
                for (Model model : Model.CONNECTED_MODEL_SET) {
                    int n;
                    int n2;
                    if (!(model instanceof TreeModel) || !stringArray[1].equals(model.getModelName())) continue;
                    string = bufferedReader.readLine();
                    string = bufferedReader.readLine();
                    stringArray = string.split("\t");
                    int n3 = Integer.parseInt(stringArray[0]);
                    Object object = new double[n3];
                    String[] stringArray2 = new String[(n3 + 1) / 2];
                    for (n2 = 0; n2 < n3; ++n2) {
                        string = bufferedReader.readLine();
                        stringArray = string.split("\t");
                        object[n2] = doubleParser.parseDouble(stringArray[1]);
                        if (n2 >= stringArray2.length) continue;
                        stringArray2[n2] = stringArray[2];
                    }
                    string = bufferedReader.readLine();
                    string = bufferedReader.readLine();
                    string = bufferedReader.readLine();
                    stringArray = string.split("\t");
                    n2 = Integer.parseInt(stringArray[0]);
                    double[][] dArray2 = new double[((ArrayList)hashMap.get(model.getId())).size()][n2];
                    int[] nArray2 = new int[n2];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = -1;
                    }
                    int[] nArray3 = new int[n2];
                    for (n = 0; n < n2; ++n) {
                        nArray3[n] = -1;
                    }
                    for (n = 0; n < n2 - 1; ++n) {
                        string = bufferedReader.readLine();
                        if (string == null) continue;
                        stringArray = string.split("\t");
                        nArray3[Integer.parseInt((String)stringArray[0])] = Integer.parseInt(stringArray[1]);
                        nArray2[Integer.parseInt((String)stringArray[0])] = Integer.parseInt(stringArray[2]);
                        for (int i = 0; i < ((ArrayList)hashMap.get(model.getId())).size(); ++i) {
                            dArray2[i][Integer.parseInt((String)stringArray[0])] = doubleParser.parseDouble(stringArray[3 + i]);
                        }
                    }
                    ((TreeModel)model).beginTreeEdit();
                    ((TreeModel)model).adoptTreeStructure(nArray3, (double[])object, nArray2, stringArray2);
                    if (arrayList.size() > 0) {
                        System.out.println("adopting " + arrayList.size() + " trait models to treeModel " + ((TreeModel)model).getId());
                        ((TreeModel)model).adoptTraitData(nArray3, arrayList, dArray2, stringArray2);
                    }
                    ((TreeModel)model).endTreeEdit();
                    linkedHashSet.remove(model.getModelName());
                }
                string = bufferedReader.readLine();
                if (string == null) continue;
                stringArray = string.split("\t");
            }
            if (linkedHashSet.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String string3 : linkedHashSet) {
                    stringBuilder.append("Expecting, but unable to match state parameter:" + string3 + "\n");
                }
                throw new RuntimeException("\n" + stringBuilder.toString());
            }
            if (System.getProperty(CHECKPOINT_SEED) != null) {
                MathUtils.setSeed(Long.parseLong(System.getProperty(CHECKPOINT_SEED)));
            } else if (nArray != null) {
                MathUtils.setRandomState(nArray);
            }
            bufferedReader.close();
            fileReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read file: " + iOException.getMessage());
        }
        return l;
    }

    class CheckpointPrintStream
    extends PrintStream {
        public CheckpointPrintStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void print(double d) {
            String string = Long.toHexString(Double.doubleToRawLongBits(d));
            super.print(d + "/" + string);
        }

        @Override
        public void println(double d) {
            String string = Long.toHexString(Double.doubleToRawLongBits(d));
            super.println(d + "/" + string);
        }
    }

    static enum DoubleParser {
        TEXT{

            @Override
            public double parseDouble(String string) {
                return Double.parseDouble(string);
            }
        }
        ,
        HEX{

            @Override
            public double parseDouble(String string) {
                String[] stringArray = string.split("/");
                return this.convertHexStrToDouble(stringArray[1]);
            }

            private double convertHexStrToDouble(String string) {
                String string2 = this.preprocess(string);
                boolean bl = true;
                if (string.equalsIgnoreCase(string2)) {
                    bl = false;
                }
                long l = Long.parseLong(string2, 16);
                double d = Double.longBitsToDouble(l);
                if (bl) {
                    return -d;
                }
                return d;
            }

            private String preprocess(String string) {
                String string2 = string.substring(0, 1);
                int n = Integer.parseInt(string2, 16);
                if (n < 8) {
                    return string;
                }
                string2 = Integer.toString(n -= 8);
                if (n == 0) {
                    string2 = "";
                }
                return string2 + string.substring(1);
            }
        };


        public abstract double parseDouble(String var1);
    }
}

