/*
 * Decompiled with CFR 0.152.
 */
package dr.app.util;

import dr.app.util.Arguments;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Utils {
    public static final String TRAITS = "traits";

    public static String absName(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    public static String getLoadFileName(String string) {
        return Utils.absName(Utils.getLoadFile(string));
    }

    public static String getSaveFileName(String string) {
        return Utils.absName(Utils.getSaveFile(string));
    }

    public static File getLoadFile(String string) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, string, 0);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null) {
            return null;
        }
        File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
        fileDialog.dispose();
        frame.dispose();
        return file;
    }

    public static File[] getLoadFiles(String string, File file, String string2, String ... stringArray) {
        Frame frame = new Frame();
        frame.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileSelectionMode(2);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(string2, stringArray);
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showOpenDialog(frame);
        File[] fileArray = null;
        if (n == 0) {
            fileArray = jFileChooser.getSelectedFiles();
        }
        frame.dispose();
        return fileArray;
    }

    public static File getSaveFile(String string) {
        Frame frame = new Frame();
        FileDialog fileDialog = new FileDialog(frame, string, 1);
        fileDialog.setVisible(true);
        File file = new File(fileDialog.getDirectory(), fileDialog.getFile());
        fileDialog.dispose();
        frame.dispose();
        return file;
    }

    public static Class detectType(String string) {
        if (string.equalsIgnoreCase("TRUE") || string.equalsIgnoreCase("FALSE")) {
            return Boolean.class;
        }
        try {
            double d = Double.parseDouble(string);
            if ((double)Math.round(d) == d) {
                return Integer.class;
            }
            return Double.class;
        }
        catch (NumberFormatException numberFormatException) {
            return String.class;
        }
    }

    public static Object constructFromString(Class clazz, String string) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != 1 || !classArray[0].equals(String.class)) continue;
            try {
                return constructor.newInstance(string);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static String nextNonCommentLine(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && (string.trim().length() == 0 || string.trim().charAt(0) == '#')) {
        }
        return string;
    }

    public static Map<String, List<String[]>> importTraitsFromFile(File file, String string) throws IOException, Arguments.ArgumentException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = Utils.nextNonCommentLine(bufferedReader);
        String[] stringArray = string2.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        if (!stringArray[0].equalsIgnoreCase(TRAITS) && stringArray[0].length() >= 1) {
            throw new Arguments.ArgumentException("Wrong file format:\ntrait key word should be declared in the 1st row");
        }
        HashMap<String, List<String[]>> hashMap = new HashMap<String, List<String[]>>();
        for (int i = 1; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], new ArrayList());
        }
        string2 = Utils.nextNonCommentLine(bufferedReader);
        while (string2 != null) {
            String[] stringArray2 = string2.split(string);
            assert (stringArray2.length > 0);
            if (stringArray2.length != stringArray.length) {
                throw new Arguments.ArgumentException("Wrong file format:\neach trait should have its corresponding value");
            }
            try {
                if (stringArray[0].equalsIgnoreCase(TRAITS)) {
                    Utils.importStatesMoreThanTaxon(hashMap, stringArray2, stringArray, 1);
                } else {
                    Utils.importSpecies(hashMap, stringArray2, stringArray, 1);
                }
            }
            catch (Arguments.ArgumentException argumentException) {
                argumentException.printStackTrace();
            }
            string2 = Utils.nextNonCommentLine(bufferedReader);
        }
        return hashMap;
    }

    private static void importSpecies(Map<String, List<String[]>> map, String[] stringArray, String[] stringArray2, int n) throws Arguments.ArgumentException {
        String string = stringArray[0].trim();
        int n2 = Arrays.asList(stringArray2).indexOf(string);
        if (n2 >= 0) {
            List<String[]> list = map.get(string);
            if (list == null) {
                throw new Arguments.ArgumentException("undefined trait " + string);
            }
            String string2 = stringArray[1].trim();
            for (int i = 2; i < stringArray.length; ++i) {
                list.add(new String[]{stringArray[i], string2});
            }
        } else {
            for (int i = n; i < stringArray.length; ++i) {
                if (i >= stringArray2.length) continue;
                List<String[]> list = map.get(stringArray2[i]);
                list.add(new String[]{string, stringArray[i].trim()});
            }
        }
    }

    private static void importStatesMoreThanTaxon(Map<String, List<String[]>> map, String[] stringArray, String[] stringArray2, int n) throws Arguments.ArgumentException {
        if (stringArray2.length < 2) {
            throw new Arguments.ArgumentException("Wrong file format:\ntrait key words in the 1st row are loaded improperly");
        }
        if (stringArray2.length - n < 1) {
            throw new Arguments.ArgumentException("startAt set improperly");
        }
        for (int i = 0; i < stringArray2.length - n; ++i) {
            List<String[]> list = map.get(stringArray2[i + n]);
            if (list == null) {
                throw new Arguments.ArgumentException("undefined trait " + stringArray2[i + n]);
            }
            list.add(new String[]{stringArray[0].trim(), stringArray[i + n].trim()});
        }
    }

    public static String trimExtensions(String string, String[] stringArray) {
        String string2 = null;
        for (String string3 : stringArray) {
            String string4 = "." + string3;
            if (!string.toUpperCase().endsWith(string4.toUpperCase())) continue;
            string2 = string.substring(0, string.length() - string4.length());
        }
        return string2 != null ? string2 : string;
    }

    public static Image getImage(Object object, String string) {
        URL uRL = object.getClass().getResource(string);
        if (uRL != null) {
            return Toolkit.getDefaultToolkit().createImage(uRL);
        }
        if (object instanceof Component) {
            Component component = (Component)object;
            Image image = component.createImage(100, 20);
            Graphics graphics = component.getGraphics();
            graphics.drawString("Not found!", 1, 15);
            return image;
        }
        return null;
    }

    public static File getCWD() {
        String string = System.getProperty("user.dir");
        return new File(string);
    }
}

