/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.io;

import dr.evolution.datatype.DataType;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;

public abstract class Importer {
    private boolean isEOF;
    private Reader reader;
    private BufferedWriter commentWriter = null;
    private int lastChar = 0;
    private int lastDelimiter = 0;
    private boolean hasComments = false;
    private boolean processComments = true;
    private char startComment = (char)65535;
    private char stopComment = (char)65535;
    private char lineComment = (char)65535;
    private char writeComment = (char)65535;
    private char metaComment = (char)65535;
    private String lastMetaComment = null;

    public Importer(Reader reader) {
        this(reader, true);
    }

    public Importer(Reader reader, boolean bl) {
        this.reader = reader;
        this.commentWriter = null;
        this.processComments = bl;
        this.isEOF = false;
    }

    public Importer(Reader reader, Writer writer) {
        this.reader = reader;
        this.commentWriter = writer != null ? new BufferedWriter(writer) : null;
        this.isEOF = false;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setCommentDelimiters(char c) {
        this.hasComments = true;
        this.lineComment = c;
    }

    public void setCommentDelimiters(char c, char c2) {
        this.hasComments = true;
        this.startComment = c;
        this.stopComment = c2;
    }

    public void setCommentDelimiters(char c, char c2, char c3) {
        this.hasComments = true;
        this.startComment = c;
        this.stopComment = c2;
        this.lineComment = c3;
    }

    public void setCommentDelimiters(char c, char c2, char c3, char c4, char c5) {
        this.hasComments = true;
        this.startComment = c;
        this.stopComment = c2;
        this.lineComment = c3;
        this.writeComment = c4;
        this.metaComment = c5;
    }

    public void setCommentWriter(Writer writer) {
        this.commentWriter = new BufferedWriter(writer);
    }

    public int getLineNumber() {
        if (this.reader instanceof LineNumberReader) {
            return ((LineNumberReader)this.reader).getLineNumber();
        }
        return -1;
    }

    public int getLastDelimiter() {
        return this.lastDelimiter;
    }

    public char nextCharacter() throws IOException {
        if (this.lastChar == 0) {
            this.lastChar = this.readCharacter();
        }
        return (char)this.lastChar;
    }

    public char readCharacter() throws IOException {
        this.skipSpace();
        char c = this.read();
        while (this.hasComments && (c == this.startComment || c == this.lineComment)) {
            this.skipComments(c);
            this.skipSpace();
            c = this.read();
        }
        return c;
    }

    public void unreadCharacter(char c) {
        this.lastChar = c;
    }

    public char next() throws IOException {
        if (this.lastChar == 0) {
            this.lastChar = this.read();
        }
        return (char)this.lastChar;
    }

    public char read() throws IOException {
        int n;
        if (this.lastChar == 0) {
            n = this.reader.read();
            if (n <= 0) {
                this.isEOF = true;
                throw new EOFException();
            }
        } else {
            n = this.lastChar;
            this.lastChar = 0;
        }
        return (char)n;
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    public String readLine(boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        char c = this.read();
        try {
            while (c != '\n' && c != '\r') {
                if (!bl && this.hasComments) {
                    if (c == this.lineComment) {
                        this.skipComments(c);
                        break;
                    }
                    if (c == this.startComment) {
                        this.skipComments(c);
                        c = this.read();
                    }
                }
                stringBuilder.append(c);
                c = this.read();
            }
            if (c == '\r' && this.next() == '\n') {
                this.read();
            }
            this.lastDelimiter = c;
        }
        catch (EOFException eOFException) {
            this.isEOF = true;
        }
        return stringBuilder.toString();
    }

    public String readLineStart(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            char c = this.read();
            while (c != '\n' && c != '\r' && string.indexOf(c) == -1) {
                stringBuilder.append(c);
                c = this.read();
            }
            this.lastDelimiter = c;
            while (c != '\n' && c != '\r') {
                c = this.read();
            }
        }
        catch (EOFException eOFException) {
            this.isEOF = true;
        }
        return stringBuilder.toString();
    }

    public void readSequence(StringBuilder stringBuilder, DataType dataType, String string, int n, String string2, String string3, String string4, String string5) throws IOException, ImportException {
        char c = this.read();
        try {
            int n2 = 0;
            while (n2 < n && string.indexOf(c) == -1) {
                if (this.hasComments && (c == this.startComment || c == this.lineComment)) {
                    this.skipComments(c);
                    c = this.read();
                }
                if (!Character.isWhitespace(c)) {
                    char c2 = c;
                    if (string2.indexOf(c) != -1) {
                        c2 = '-';
                    } else if (string3.indexOf(c) != -1) {
                        c2 = '?';
                    } else if (string4.indexOf(c) != -1) {
                        if (string5 == null) {
                            throw new ImportException("Match character in first sequences");
                        }
                        if (n2 >= string5.length()) {
                            throw new ImportException("Match sequences too short");
                        }
                        c2 = string5.charAt(n2);
                    }
                    stringBuilder.append(c2);
                    ++n2;
                }
                c = this.read();
            }
            this.lastDelimiter = c;
            if (Character.isWhitespace((char)this.lastDelimiter) && string.indexOf(c = this.nextCharacter()) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        catch (EOFException eOFException) {
            this.isEOF = true;
        }
    }

    public void readSequenceLine(StringBuilder stringBuilder, DataType dataType, String string, String string2, String string3, String string4, String string5) throws IOException, ImportException {
        char c = this.read();
        try {
            int n = 0;
            while (c != '\r' && c != '\n' && string.indexOf(c) == -1) {
                if (this.hasComments) {
                    if (c == this.lineComment) {
                        this.skipComments(c);
                        break;
                    }
                    if (c == this.startComment) {
                        this.skipComments(c);
                        c = this.read();
                    }
                }
                if (c != ' ' && c != '\t') {
                    char c2 = c;
                    if (string2.indexOf(c) != -1) {
                        c2 = '-';
                    } else if (string3.indexOf(c) != -1) {
                        c2 = '?';
                    } else if (string4.indexOf(c) != -1) {
                        if (string5 == null) {
                            throw new ImportException("Match character in first sequences");
                        }
                        if (n >= string5.length()) {
                            throw new ImportException("Match sequences too short");
                        }
                        c2 = string5.charAt(n);
                    }
                    stringBuilder.append(c2);
                    ++n;
                }
                c = this.read();
            }
            if (c == '\r' && this.next() == '\n') {
                this.read();
            }
            this.lastDelimiter = c;
            if (Character.isWhitespace((char)this.lastDelimiter) && string.indexOf(c = this.nextCharacter()) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        catch (EOFException eOFException) {
            this.isEOF = true;
        }
    }

    public int readInteger() throws IOException, ImportException {
        String string = this.readToken();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public int readInteger(String string) throws IOException, ImportException {
        String string2 = this.readToken(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public long readLong() throws IOException, ImportException {
        String string = this.readToken();
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public long readLong(String string) throws IOException, ImportException {
        String string2 = this.readToken(string);
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public double readDouble() throws IOException, ImportException {
        String string = this.readToken();
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public double readDouble(String string) throws IOException, ImportException {
        String string2 = this.readToken(string);
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("Number format error: " + numberFormatException.getMessage());
        }
    }

    public String readToken() throws IOException {
        return this.readToken("");
    }

    public String readToken(String string) throws IOException {
        return this.readToken(string, false);
    }

    public String readToken(String string, boolean bl) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        this.nextCharacter();
        StringBuilder stringBuilder = new StringBuilder();
        while (!bl2) {
            n = this.read();
            try {
                boolean bl5 = Character.isWhitespace((char)n);
                if (bl4 && n == n3) {
                    char c = this.read();
                    if (n == c) {
                        stringBuilder.append((char)n);
                        continue;
                    }
                    this.lastDelimiter = 32;
                    this.unreadCharacter(c);
                    bl2 = true;
                    bl4 = false;
                    continue;
                }
                if (bl3 && (n == 39 || n == 34)) {
                    bl4 = true;
                    n3 = n;
                    bl3 = false;
                    n2 = 0;
                    continue;
                }
                if (!(bl || n != this.startComment && n != this.lineComment)) {
                    this.skipComments((char)n);
                    this.lastDelimiter = 32;
                    bl2 = true;
                    continue;
                }
                if (bl4) {
                    if (bl5) {
                        ++n2;
                        n = 32;
                    } else {
                        n2 = 0;
                    }
                    if (n2 >= 2) continue;
                    stringBuilder.append((char)n);
                    continue;
                }
                if (bl5) {
                    this.lastDelimiter = 32;
                    bl2 = true;
                    continue;
                }
                if (string.indexOf(n) != -1) {
                    bl2 = true;
                    this.lastDelimiter = n;
                    continue;
                }
                stringBuilder.append((char)n);
                bl3 = false;
            }
            catch (EOFException eOFException) {
                this.isEOF = true;
                bl2 = true;
            }
        }
        if (!this.isEOF() && Character.isWhitespace((char)this.lastDelimiter)) {
            n = this.nextCharacter();
            while (Character.isWhitespace((char)n)) {
                this.read();
                n = this.nextCharacter();
            }
            if (string.indexOf(n) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
        return stringBuilder.toString();
    }

    public void skipToken(String string) throws IOException {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        this.nextCharacter();
        while (!bl) {
            n = this.read();
            try {
                boolean bl4 = Character.isWhitespace((char)n);
                if (bl3 && n == n3) {
                    char c = this.read();
                    if (n == c) continue;
                    this.lastDelimiter = 32;
                    this.unreadCharacter(c);
                    bl = true;
                    bl3 = false;
                    continue;
                }
                if (bl2 && (n == 39 || n == 34)) {
                    bl3 = true;
                    n3 = n;
                    bl2 = false;
                    n2 = 0;
                    continue;
                }
                if (bl3) {
                    if (bl4) {
                        ++n2;
                        n = 32;
                        continue;
                    }
                    n2 = 0;
                    continue;
                }
                if (bl4) {
                    this.lastDelimiter = 32;
                    bl = true;
                    continue;
                }
                if (string.indexOf(n) == -1) continue;
                bl = true;
                this.lastDelimiter = n;
                bl2 = false;
            }
            catch (EOFException eOFException) {
                this.isEOF = true;
                bl = true;
            }
        }
        if (!this.isEOF() && Character.isWhitespace((char)this.lastDelimiter)) {
            n = this.nextCharacter();
            while (Character.isWhitespace((char)n)) {
                this.read();
                n = this.nextCharacter();
            }
            if (string.indexOf(n) != -1) {
                this.lastDelimiter = this.readCharacter();
            }
        }
    }

    protected void skipComments(char c) throws IOException {
        int n = 1;
        boolean bl = false;
        StringBuilder stringBuilder = null;
        if (this.processComments) {
            if (this.nextCharacter() == this.writeComment) {
                this.read();
                bl = true;
            } else if (this.nextCharacter() == this.metaComment) {
                this.read();
                stringBuilder = this.lastMetaComment != null ? new StringBuilder(this.lastMetaComment + ";") : new StringBuilder();
            }
            this.lastMetaComment = null;
            if (c == this.lineComment) {
                String string = this.readLine();
                if (bl && this.commentWriter != null) {
                    this.commentWriter.write(string, 0, string.length());
                    this.commentWriter.newLine();
                } else if (stringBuilder != null) {
                    stringBuilder.append(string);
                }
            } else {
                do {
                    char c2;
                    if ((c2 = this.read()) == this.startComment) {
                        ++n;
                        continue;
                    }
                    if (c2 == this.stopComment) {
                        if (bl && this.commentWriter != null) {
                            this.commentWriter.newLine();
                        }
                        --n;
                        continue;
                    }
                    if (bl && this.commentWriter != null) {
                        this.commentWriter.write(c2);
                        continue;
                    }
                    if (stringBuilder == null) continue;
                    stringBuilder.append(c2);
                } while (n > 0);
            }
            if (stringBuilder != null) {
                this.lastMetaComment = stringBuilder.toString();
            }
        } else if (c == this.lineComment) {
            this.skipToEndOfLine(true);
        } else {
            do {
                char c3;
                if ((c3 = this.read()) == this.startComment) {
                    ++n;
                    continue;
                }
                if (c3 != this.stopComment) continue;
                --n;
            } while (n > 0);
        }
    }

    public void skipToEndOfLine(boolean bl) throws IOException {
        char c;
        do {
            c = this.read();
            if (!this.hasComments || bl) continue;
            if (c == this.lineComment) {
                this.skipComments(c);
                break;
            }
            if (c != this.startComment) continue;
            this.skipComments(c);
            c = this.read();
        } while (c != '\n' && c != '\r');
        if (c == '\r' && this.nextCharacter() == '\n') {
            this.read();
        }
    }

    public void skipWhile(String string) throws IOException {
        char c;
        while (string.indexOf(c = this.read()) > -1) {
        }
        this.unreadCharacter(c);
    }

    public void skipSpace() throws IOException {
        this.skipWhile(" \t\r\n");
    }

    public void skipCharacters(String string) throws IOException {
        this.skipWhile(string + " \t\r\n");
    }

    public char skipUntil(String string) throws IOException {
        char c;
        while (string.indexOf(c = this.readCharacter()) == -1) {
        }
        return c;
    }

    public char skipUntilToken(String string, String string2) throws IOException {
        String string3;
        do {
            string3 = this.readToken(string2);
        } while (!this.isEOF() && !string3.equals(string));
        return (char)this.lastDelimiter;
    }

    public String getLastMetaComment() {
        return this.lastMetaComment;
    }

    public void clearLastMetaComment() {
        this.lastMetaComment = null;
    }

    public boolean isEOF() {
        return this.isEOF;
    }

    public static class ImportException
    extends Exception {
        private static final long serialVersionUID = 7858834683324203750L;

        public ImportException() {
        }

        public ImportException(String string) {
            super(string);
        }
    }

    public static class UnknownTaxonException
    extends ImportException {
        private static final long serialVersionUID = 6611115782536515250L;

        public UnknownTaxonException() {
        }

        public UnknownTaxonException(String string) {
            super(string);
        }
    }

    public static class TooFewTaxaException
    extends ImportException {
        private static final long serialVersionUID = -6349041350075169247L;

        public TooFewTaxaException() {
        }

        public TooFewTaxaException(String string) {
            super(string);
        }
    }

    public static class ShortSequenceException
    extends ImportException {
        private static final long serialVersionUID = 7460033398106047073L;

        public ShortSequenceException() {
        }

        public ShortSequenceException(String string) {
            super(string);
        }
    }

    public static class MissingFieldException
    extends ImportException {
        private static final long serialVersionUID = -7576489210458327552L;

        public MissingFieldException() {
        }

        public MissingFieldException(String string) {
            super(string);
        }
    }

    public static class UnparsableDataException
    extends ImportException {
        private static final long serialVersionUID = 5905130039882401006L;

        public UnparsableDataException() {
        }

        public UnparsableDataException(String string) {
            super(string);
        }
    }

    public static class BadFormatException
    extends ImportException {
        private static final long serialVersionUID = -8206831989674620748L;

        public BadFormatException() {
        }

        public BadFormatException(String string) {
            super(string);
        }
    }

    public static class DuplicateFieldException
    extends ImportException {
        private static final long serialVersionUID = 8047146381348414810L;

        public DuplicateFieldException() {
        }

        public DuplicateFieldException(String string) {
            super(string);
        }
    }
}

