/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.io.Importer;
import dr.evolution.io.NewickImporter;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import java.io.IOException;
import java.util.HashSet;

public class TestTreeUtils {
    public static void main(String[] stringArray) {
        try {
            NewickImporter newickImporter = new NewickImporter("(((('A':0.6,'B':0.6):0.1,'C':0.5):0.4,'D':0.7):0.1,'E':1.3)");
            Tree tree = newickImporter.importNextTree();
            System.out.println("5-taxon tree: " + tree);
            System.out.println("Tree length: " + TreeUtils.getTreeLength(tree, tree.getRoot()));
            System.out.println();
            HashSet<Taxon> hashSet = new HashSet<Taxon>();
            hashSet.add(tree.getTaxon(0));
            hashSet.add(tree.getTaxon(1));
            hashSet.add(tree.getTaxon(2));
            System.out.println("Subtree taxa: " + ((Object)hashSet).toString());
            System.out.println("Subtree length: " + TreeUtils.getSubTreeLength(tree, hashSet));
            HashSet<Taxon> hashSet2 = new HashSet<Taxon>();
            hashSet2.add(tree.getTaxon(0));
            hashSet2.add(tree.getTaxon(1));
            hashSet2.add(tree.getTaxon(3));
            System.out.println("Subtree taxa: " + ((Object)hashSet2).toString());
            System.out.println("Subtree length: " + TreeUtils.getSubTreeLength(tree, hashSet2));
            HashSet<Taxon> hashSet3 = new HashSet<Taxon>();
            hashSet3.add(tree.getTaxon(0));
            hashSet3.add(tree.getTaxon(2));
            hashSet3.add(tree.getTaxon(3));
            hashSet3.add(tree.getTaxon(4));
            System.out.println("Subtree taxa: " + ((Object)hashSet3).toString());
            System.out.println("Subtree length: " + TreeUtils.getSubTreeLength(tree, hashSet3));
        }
        catch (Importer.ImportException importException) {
            System.err.println(importException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

