/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.logging.Logger;

public class CRPClusterRandomWalkOperator
extends AbstractAdaptableOperator {
    public static final String WINDOW_SIZE = "windowSize";
    public static final String VIRUS_LOCATIONS = "virusLocations";
    public static final String CLUSTER_ASSIGNMENTS = "clusterAssignments";
    public static final String CRP_CLUSTER_RW_OPERATOR = "CRPClusterRandomWalkOperator";
    private final MatrixParameter virusLocations;
    private final Parameter assignments;
    private double windowSize;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("virusLocations", MatrixParameter.class), new ElementRule("clusterAssignments", Parameter.class), AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("windowSize")};

        @Override
        public String getParserName() {
            return CRPClusterRandomWalkOperator.CRP_CLUSTER_RW_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(CRPClusterRandomWalkOperator.WINDOW_SIZE);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject.getElementFirstChild(CRPClusterRandomWalkOperator.VIRUS_LOCATIONS);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(CRPClusterRandomWalkOperator.CLUSTER_ASSIGNMENTS);
            return new CRPClusterRandomWalkOperator(parameter, matrixParameter, d2, d);
        }

        @Override
        public String getParserDescription() {
            return "This element returns an operator moves simultaneously locations for all viruses in same cluster in ddCRP and BMDS.";
        }

        @Override
        public Class getReturnType() {
            return CRPClusterRandomWalkOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public CRPClusterRandomWalkOperator(Parameter parameter, MatrixParameter matrixParameter, double d, double d2) {
        super(AdaptationMode.ADAPTATION_ON);
        this.virusLocations = matrixParameter;
        this.windowSize = d;
        this.assignments = parameter;
        this.setWeight(d2);
    }

    @Override
    public double doOperation() {
        int n = this.findMax(this.assignments);
        int n2 = MathUtils.nextInt(n + 1);
        if (this.windowSize > 50.0) {
            this.windowSize = 50.0;
        }
        double d = (2.0 * MathUtils.nextDouble() - 1.0) * this.windowSize;
        double d2 = (2.0 * MathUtils.nextDouble() - 1.0) * this.windowSize;
        for (int i = 0; i < this.assignments.getDimension(); ++i) {
            if ((int)this.assignments.getParameterValue(i) != n2) continue;
            double d3 = this.virusLocations.getParameter(i).getParameterValue(0) + d;
            double d4 = this.virusLocations.getParameter(i).getParameterValue(1) + d2;
            this.virusLocations.setParameterValue(2 * i, d3);
            this.virusLocations.setParameterValue(2 * i + 1, d4);
            this.virusLocations.fireParameterChangedEvent(2 * i, Variable.ChangeType.VALUE_CHANGED);
            this.virusLocations.fireParameterChangedEvent(2 * i + 1, Variable.ChangeType.VALUE_CHANGED);
        }
        return 0.0;
    }

    private int findMax(Parameter parameter) {
        int n = 0;
        for (int i = 0; i < parameter.getDimension(); ++i) {
            if (!(parameter.getParameterValue(i) > (double)n)) continue;
            n = (int)parameter.getParameterValue(i);
        }
        return n;
    }

    private void printInformation(double[] dArray, int n) {
        StringBuffer stringBuffer = new StringBuffer("\n \n double vector \n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(dArray[i] + "\t");
        }
        Logger.getLogger("dr.evomodel").info(stringBuffer.toString());
    }

    private void printInformation(Parameter parameter, String string) {
        StringBuffer stringBuffer = new StringBuffer("\n ");
        stringBuffer.append(string);
        stringBuffer.append("\t\t");
        for (int i = 0; i < parameter.getDimension(); ++i) {
            stringBuffer.append(parameter.getParameterValue(i) + "\t");
        }
        Logger.getLogger("dr.evomodel").info(stringBuffer.toString());
    }

    private void printInformation(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(string);
        stringBuffer.append("\t\t");
        stringBuffer.append(n);
        Logger.getLogger("dr.evomodel").info(stringBuffer.toString());
    }

    private void printInformation(double d, String string) {
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append(string);
        stringBuffer.append("\t\t");
        stringBuffer.append(d);
        Logger.getLogger("dr.evomodel").info(stringBuffer.toString());
    }

    @Override
    public String getAdaptableParameterName() {
        return WINDOW_SIZE;
    }

    @Override
    public String getOperatorName() {
        return CRP_CLUSTER_RW_OPERATOR;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.windowSize);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.windowSize = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.windowSize;
    }
}

